/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ApplyBonusCount
extends LootItemConditionalFunction {
    private static final Map<ResourceLocation, FormulaType> FORMULAS = Stream.of(BinomialWithBonusCount.TYPE, OreDrops.TYPE, UniformBonusCount.TYPE).collect(Collectors.toMap(FormulaType::id, Function.identity()));
    private static final Codec<FormulaType> FORMULA_TYPE_CODEC = ResourceLocation.CODEC.comapFlatMap(p_298052_ -> {
        FormulaType applybonuscount$formulatype = FORMULAS.get(p_298052_);
        return applybonuscount$formulatype != null ? DataResult.success((Object)applybonuscount$formulatype) : DataResult.error(() -> "No formula type with id: '" + String.valueOf(p_298052_) + "'");
    }, FormulaType::id);
    private static final MapCodec<Formula> FORMULA_CODEC = ExtraCodecs.dispatchOptionalValue("formula", "parameters", FORMULA_TYPE_CODEC, Formula::getType, FormulaType::codec);
    public static final MapCodec<ApplyBonusCount> CODEC = RecordCodecBuilder.mapCodec(p_344674_ -> ApplyBonusCount.commonFields(p_344674_).and(p_344674_.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(p_298051_ -> p_298051_.enchantment), (App)FORMULA_CODEC.forGetter(p_298061_ -> p_298061_.formula))).apply((Applicative)p_344674_, ApplyBonusCount::new));
    private final Holder<Enchantment> enchantment;
    private final Formula formula;

    private ApplyBonusCount(List<LootItemCondition> p_298532_, Holder<Enchantment> p_298797_, Formula p_79905_) {
        super(p_298532_);
        this.enchantment = p_298797_;
        this.formula = p_79905_;
    }

    public LootItemFunctionType<ApplyBonusCount> getType() {
        return LootItemFunctions.APPLY_BONUS;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.TOOL);
    }

    @Override
    public ItemStack run(ItemStack p_79913_, LootContext p_79914_) {
        ItemStack itemstack = p_79914_.getOptionalParameter(LootContextParams.TOOL);
        if (itemstack != null) {
            int i = EnchantmentHelper.getItemEnchantmentLevel(this.enchantment, itemstack);
            int j = this.formula.calculateNewCount(p_79914_.getRandom(), p_79913_.getCount(), i);
            p_79913_.setCount(j);
        }
        return p_79913_;
    }

    public static LootItemConditionalFunction.Builder<?> addBonusBinomialDistributionCount(Holder<Enchantment> p_345484_, float p_79919_, int p_79920_) {
        return ApplyBonusCount.simpleBuilder(p_344680_ -> new ApplyBonusCount((List<LootItemCondition>)p_344680_, p_345484_, new BinomialWithBonusCount(p_79920_, p_79919_)));
    }

    public static LootItemConditionalFunction.Builder<?> addOreBonusCount(Holder<Enchantment> p_344867_) {
        return ApplyBonusCount.simpleBuilder(p_344682_ -> new ApplyBonusCount((List<LootItemCondition>)p_344682_, p_344867_, new OreDrops()));
    }

    public static LootItemConditionalFunction.Builder<?> addUniformBonusCount(Holder<Enchantment> p_345095_) {
        return ApplyBonusCount.simpleBuilder(p_344676_ -> new ApplyBonusCount((List<LootItemCondition>)p_344676_, p_345095_, new UniformBonusCount(1)));
    }

    public static LootItemConditionalFunction.Builder<?> addUniformBonusCount(Holder<Enchantment> p_344758_, int p_79923_) {
        return ApplyBonusCount.simpleBuilder(p_344673_ -> new ApplyBonusCount((List<LootItemCondition>)p_344673_, p_344758_, new UniformBonusCount(p_79923_)));
    }

    static interface Formula {
        public int calculateNewCount(RandomSource var1, int var2, int var3);

        public FormulaType getType();
    }

    record UniformBonusCount(int bonusMultiplier) implements Formula
    {
        public static final Codec<UniformBonusCount> CODEC = RecordCodecBuilder.create(p_298501_ -> p_298501_.group((App)Codec.INT.fieldOf("bonusMultiplier").forGetter(UniformBonusCount::bonusMultiplier)).apply((Applicative)p_298501_, UniformBonusCount::new));
        public static final FormulaType TYPE = new FormulaType(ResourceLocation.withDefaultNamespace("uniform_bonus_count"), CODEC);

        @Override
        public int calculateNewCount(RandomSource p_230976_, int p_230977_, int p_230978_) {
            return p_230977_ + p_230976_.nextInt(this.bonusMultiplier * p_230978_ + 1);
        }

        @Override
        public FormulaType getType() {
            return TYPE;
        }
    }

    record OreDrops() implements Formula
    {
        public static final Codec<OreDrops> CODEC = Codec.unit(OreDrops::new);
        public static final FormulaType TYPE = new FormulaType(ResourceLocation.withDefaultNamespace("ore_drops"), CODEC);

        @Override
        public int calculateNewCount(RandomSource p_230972_, int p_230973_, int p_230974_) {
            if (p_230974_ > 0) {
                int i = p_230972_.nextInt(p_230974_ + 2) - 1;
                if (i < 0) {
                    i = 0;
                }
                return p_230973_ * (i + 1);
            }
            return p_230973_;
        }

        @Override
        public FormulaType getType() {
            return TYPE;
        }
    }

    record BinomialWithBonusCount(int extraRounds, float probability) implements Formula
    {
        private static final Codec<BinomialWithBonusCount> CODEC = RecordCodecBuilder.create(p_298226_ -> p_298226_.group((App)Codec.INT.fieldOf("extra").forGetter(BinomialWithBonusCount::extraRounds), (App)Codec.FLOAT.fieldOf("probability").forGetter(BinomialWithBonusCount::probability)).apply((Applicative)p_298226_, BinomialWithBonusCount::new));
        public static final FormulaType TYPE = new FormulaType(ResourceLocation.withDefaultNamespace("binomial_with_bonus_count"), CODEC);

        @Override
        public int calculateNewCount(RandomSource p_230965_, int p_230966_, int p_230967_) {
            for (int i = 0; i < p_230967_ + this.extraRounds; ++i) {
                if (!(p_230965_.nextFloat() < this.probability)) continue;
                ++p_230966_;
            }
            return p_230966_;
        }

        @Override
        public FormulaType getType() {
            return TYPE;
        }
    }

    record FormulaType(ResourceLocation id, Codec<? extends Formula> codec) {
    }
}

