/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;

public class LootParams {
    private final ServerLevel level;
    private final ContextMap params;
    private final Map<ResourceLocation, DynamicDrop> dynamicDrops;
    private final float luck;

    public LootParams(ServerLevel p_287766_, ContextMap p_380934_, Map<ResourceLocation, DynamicDrop> p_287705_, float p_287671_) {
        this.level = p_287766_;
        this.params = p_380934_;
        this.dynamicDrops = p_287705_;
        this.luck = p_287671_;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public ContextMap contextMap() {
        return this.params;
    }

    public void addDynamicDrops(ResourceLocation p_287768_, Consumer<ItemStack> p_287711_) {
        DynamicDrop lootparams$dynamicdrop = this.dynamicDrops.get(p_287768_);
        if (lootparams$dynamicdrop != null) {
            lootparams$dynamicdrop.add(p_287711_);
        }
    }

    public float getLuck() {
        return this.luck;
    }

    @FunctionalInterface
    public static interface DynamicDrop {
        public void add(Consumer<ItemStack> var1);
    }

    public static class Builder {
        private final ServerLevel level;
        private final ContextMap.Builder params = new ContextMap.Builder();
        private final Map<ResourceLocation, DynamicDrop> dynamicDrops = Maps.newHashMap();
        private float luck;

        public Builder(ServerLevel p_287594_) {
            this.level = p_287594_;
        }

        public ServerLevel getLevel() {
            return this.level;
        }

        public <T> Builder withParameter(ContextKey<T> p_381018_, T p_287606_) {
            this.params.withParameter(p_381018_, p_287606_);
            return this;
        }

        public <T> Builder withOptionalParameter(ContextKey<T> p_381070_, @Nullable T p_287630_) {
            this.params.withOptionalParameter(p_381070_, p_287630_);
            return this;
        }

        public <T> T getParameter(ContextKey<T> p_381125_) {
            return this.params.getParameter(p_381125_);
        }

        @Nullable
        public <T> T getOptionalParameter(ContextKey<T> p_381097_) {
            return this.params.getOptionalParameter(p_381097_);
        }

        public Builder withDynamicDrop(ResourceLocation p_287734_, DynamicDrop p_287724_) {
            DynamicDrop lootparams$dynamicdrop = this.dynamicDrops.put(p_287734_, p_287724_);
            if (lootparams$dynamicdrop != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + String.valueOf(this.dynamicDrops) + "'");
            }
            return this;
        }

        public Builder withLuck(float p_287703_) {
            this.luck = p_287703_;
            return this;
        }

        public LootParams create(ContextKeySet p_381021_) {
            ContextMap contextmap = this.params.create(p_381021_);
            return new LootParams(this.level, contextmap, this.dynamicDrops, this.luck);
        }
    }
}

