/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import net.neoforged.neoforge.common.CommonHooks;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();
    public static final String TAG_DATA = "Data";
    private static final PathMatcher NO_SYMLINKS_ALLOWED = p_294087_ -> false;
    public static final String ALLOWED_SYMLINKS_CONFIG_NAME = "allowed_symlinks.txt";
    private static final int UNCOMPRESSED_NBT_QUOTA = 0x6400000;
    private static final int DISK_SPACE_WARNING_THRESHOLD = 0x4000000;
    private final Path baseDir;
    private final Path backupDir;
    final DataFixer fixerUpper;
    private final DirectoryValidator worldDirValidator;

    public LevelStorageSource(Path p_289985_, Path p_289978_, DirectoryValidator p_289922_, DataFixer p_289940_) {
        this.fixerUpper = p_289940_;
        try {
            FileUtil.createDirectoriesSafe(p_289985_);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
        this.baseDir = p_289985_;
        this.backupDir = p_289978_;
        this.worldDirValidator = p_289922_;
    }

    public static DirectoryValidator parseValidator(Path p_289968_) {
        if (Files.exists(p_289968_, new LinkOption[0])) {
            try {
                DirectoryValidator directoryvalidator;
                try (BufferedReader bufferedreader = Files.newBufferedReader(p_289968_);){
                    directoryvalidator = new DirectoryValidator(PathAllowList.readPlain(bufferedreader));
                }
                return directoryvalidator;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to parse {}, disallowing all symbolic links", (Object)ALLOWED_SYMLINKS_CONFIG_NAME, (Object)exception);
            }
        }
        return new DirectoryValidator(NO_SYMLINKS_ALLOWED);
    }

    public static LevelStorageSource createDefault(Path p_78243_) {
        DirectoryValidator directoryvalidator = LevelStorageSource.parseValidator(p_78243_.resolve(ALLOWED_SYMLINKS_CONFIG_NAME));
        return new LevelStorageSource(p_78243_, p_78243_.resolve("../backups"), directoryvalidator, DataFixers.getDataFixer());
    }

    public static WorldDataConfiguration readDataConfig(Dynamic<?> p_250884_) {
        return WorldDataConfiguration.CODEC.parse(p_250884_).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(WorldDataConfiguration.DEFAULT);
    }

    public static WorldLoader.PackConfig getPackConfig(Dynamic<?> p_307282_, PackRepository p_307421_, boolean p_307393_) {
        return new WorldLoader.PackConfig(p_307421_, LevelStorageSource.readDataConfig(p_307282_), p_307393_, false);
    }

    public static LevelDataAndDimensions getLevelDataAndDimensions(Dynamic<?> p_307313_, WorldDataConfiguration p_307486_, Registry<LevelStem> p_307597_, HolderLookup.Provider p_362036_) {
        Dynamic<?> dynamic = RegistryOps.injectRegistryContext(p_307313_, p_362036_);
        Dynamic dynamic1 = dynamic.get("WorldGenSettings").orElseEmptyMap();
        WorldGenSettings worldgensettings = (WorldGenSettings)WorldGenSettings.CODEC.parse(dynamic1).getOrThrow();
        LevelSettings levelsettings = LevelSettings.parse(dynamic, p_307486_);
        WorldDimensions.Complete worlddimensions$complete = worldgensettings.dimensions().bake(p_307597_);
        Lifecycle lifecycle = worlddimensions$complete.lifecycle().add(p_362036_.allRegistriesLifecycle());
        PrimaryLevelData primaryleveldata = PrimaryLevelData.parse(dynamic, levelsettings, worlddimensions$complete.specialWorldProperty(), worldgensettings.options(), lifecycle);
        return new LevelDataAndDimensions(primaryleveldata, worlddimensions$complete);
    }

    public String getName() {
        return "Anvil";
    }

    public LevelCandidates findLevelCandidates() throws LevelStorageException {
        if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
            throw new LevelStorageException(Component.translatable("selectWorld.load_folder_access"));
        }
        try {
            LevelCandidates levelstoragesource$levelcandidates;
            try (Stream<Path> stream = Files.list(this.baseDir);){
                List<LevelDirectory> list = stream.filter(p_230839_ -> Files.isDirectory(p_230839_, new LinkOption[0])).map(LevelDirectory::new).filter(p_230835_ -> Files.isRegularFile(p_230835_.dataFile(), new LinkOption[0]) || Files.isRegularFile(p_230835_.oldDataFile(), new LinkOption[0])).toList();
                levelstoragesource$levelcandidates = new LevelCandidates(list);
            }
            return levelstoragesource$levelcandidates;
        }
        catch (IOException ioexception) {
            throw new LevelStorageException(Component.translatable("selectWorld.load_folder_access"));
        }
    }

    public CompletableFuture<List<LevelSummary>> loadLevelSummaries(LevelCandidates p_230814_) {
        ArrayList<CompletableFuture<LevelSummary>> list = new ArrayList<CompletableFuture<LevelSummary>>(p_230814_.levels.size());
        for (LevelDirectory levelstoragesource$leveldirectory : p_230814_.levels) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean flag;
                try {
                    flag = DirectoryLock.isLocked(levelstoragesource$leveldirectory.path());
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to read {} lock", (Object)levelstoragesource$leveldirectory.path(), (Object)exception);
                    return null;
                }
                try {
                    return this.readLevelSummary(levelstoragesource$leveldirectory, flag);
                }
                catch (OutOfMemoryError outofmemoryerror1) {
                    MemoryReserve.release();
                    String s = "Ran out of memory trying to read summary of world folder \"" + levelstoragesource$leveldirectory.directoryName() + "\"";
                    LOGGER.error(LogUtils.FATAL_MARKER, s);
                    OutOfMemoryError outofmemoryerror = new OutOfMemoryError("Ran out of memory reading level data");
                    outofmemoryerror.initCause(outofmemoryerror1);
                    CrashReport crashreport = CrashReport.forThrowable(outofmemoryerror, s);
                    CrashReportCategory crashreportcategory = crashreport.addCategory("World details");
                    crashreportcategory.setDetail("Folder Name", levelstoragesource$leveldirectory.directoryName());
                    try {
                        long i = Files.size(levelstoragesource$leveldirectory.dataFile());
                        crashreportcategory.setDetail("level.dat size", i);
                    }
                    catch (IOException ioexception) {
                        crashreportcategory.setDetailError("level.dat size", ioexception);
                    }
                    throw new ReportedException(crashreport);
                }
            }, Util.backgroundExecutor().forName("loadLevelSummaries")));
        }
        return Util.sequenceFailFastAndCancel(list).thenApply(p_230832_ -> p_230832_.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int getStorageVersion() {
        return 19133;
    }

    static CompoundTag readLevelDataTagRaw(Path p_307408_) throws IOException {
        return NbtIo.readCompressed(p_307408_, NbtAccounter.create(0x6400000L));
    }

    static Dynamic<?> readLevelDataTagFixed(Path p_307371_, DataFixer p_307468_) throws IOException {
        CompoundTag compoundtag = LevelStorageSource.readLevelDataTagRaw(p_307371_);
        CompoundTag compoundtag1 = compoundtag.getCompoundOrEmpty(TAG_DATA);
        int i = NbtUtils.getDataVersion(compoundtag1, -1);
        Dynamic dynamic = DataFixTypes.LEVEL.updateToCurrentVersion(p_307468_, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag1), i);
        dynamic = dynamic.update("Player", p_341581_ -> DataFixTypes.PLAYER.updateToCurrentVersion(p_307468_, p_341581_, i));
        return dynamic.update("WorldGenSettings", p_341584_ -> DataFixTypes.WORLD_GEN_SETTINGS.updateToCurrentVersion(p_307468_, p_341584_, i));
    }

    private LevelSummary readLevelSummary(LevelDirectory p_307237_, boolean p_307368_) {
        Path path = p_307237_.dataFile();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> list;
                if (Files.isSymbolicLink(path) && !(list = this.worldDirValidator.validateSymlink(path)).isEmpty()) {
                    LOGGER.warn("{}", (Object)ContentValidationException.getMessage(path, list));
                    return new LevelSummary.SymlinkLevelSummary(p_307237_.directoryName(), p_307237_.iconFile());
                }
                Tag tag = LevelStorageSource.readLightweightData(path);
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundtag = (CompoundTag)tag;
                    CompoundTag compoundtag1 = compoundtag.getCompoundOrEmpty(TAG_DATA);
                    int i = NbtUtils.getDataVersion(compoundtag1, -1);
                    Dynamic dynamic = DataFixTypes.LEVEL_SUMMARY.updateToCurrentVersion(this.fixerUpper, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag1), i);
                    return this.makeLevelSummary(dynamic, p_307237_, p_307368_);
                }
                LOGGER.warn("Invalid root tag in {}", (Object)path);
            }
            catch (Exception exception) {
                LOGGER.error("Exception reading {}", (Object)path, (Object)exception);
            }
        }
        return new LevelSummary.CorruptedLevelSummary(p_307237_.directoryName(), p_307237_.iconFile(), LevelStorageSource.getFileModificationTime(p_307237_));
    }

    private static long getFileModificationTime(LevelDirectory p_307642_) {
        Instant instant = LevelStorageSource.getFileModificationTime(p_307642_.dataFile());
        if (instant == null) {
            instant = LevelStorageSource.getFileModificationTime(p_307642_.oldDataFile());
        }
        return instant == null ? -1L : instant.toEpochMilli();
    }

    @Nullable
    static Instant getFileModificationTime(Path p_307529_) {
        try {
            return Files.getLastModifiedTime(p_307529_, new LinkOption[0]).toInstant();
        }
        catch (IOException ioexception) {
            return null;
        }
    }

    LevelSummary makeLevelSummary(Dynamic<?> p_307300_, LevelDirectory p_307426_, boolean p_307364_) {
        LevelVersion levelversion = LevelVersion.parse(p_307300_);
        int i = levelversion.levelDataVersion();
        if (i != 19132 && i != 19133) {
            throw new NbtFormatException("Unknown data version: " + Integer.toHexString(i));
        }
        boolean flag = i != this.getStorageVersion();
        Path path = p_307426_.iconFile();
        WorldDataConfiguration worlddataconfiguration = LevelStorageSource.readDataConfig(p_307300_);
        LevelSettings levelsettings = LevelSettings.parse(p_307300_, worlddataconfiguration);
        FeatureFlagSet featureflagset = LevelStorageSource.parseFeatureFlagsFromSummary(p_307300_);
        boolean flag1 = FeatureFlags.isExperimental(featureflagset);
        return new LevelSummary(levelsettings, levelversion, p_307426_.directoryName(), flag, p_307364_, flag1, path);
    }

    private static FeatureFlagSet parseFeatureFlagsFromSummary(Dynamic<?> p_249466_) {
        Set<ResourceLocation> set = p_249466_.get("enabled_features").asStream().flatMap(p_338115_ -> p_338115_.asString().result().map(ResourceLocation::tryParse).stream()).collect(Collectors.toSet());
        return FeatureFlags.REGISTRY.fromNames(set, p_248503_ -> {});
    }

    @Nullable
    private static Tag readLightweightData(Path p_230837_) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector(TAG_DATA, CompoundTag.TYPE, "Player"), new FieldSelector(TAG_DATA, CompoundTag.TYPE, "WorldGenSettings"));
        NbtIo.parseCompressed(p_230837_, (StreamTagVisitor)skipfields, NbtAccounter.create(0x6400000L));
        return skipfields.getResult();
    }

    public boolean isNewLevelIdAcceptable(String p_78241_) {
        try {
            Path path = this.getLevelPath(p_78241_);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean levelExists(String p_78256_) {
        try {
            return Files.isDirectory(this.getLevelPath(p_78256_), new LinkOption[0]);
        }
        catch (InvalidPathException invalidpathexception) {
            return false;
        }
    }

    public Path getLevelPath(String p_289974_) {
        return this.baseDir.resolve(p_289974_);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBackupPath() {
        return this.backupDir;
    }

    public LevelStorageAccess validateAndCreateAccess(String p_289980_) throws IOException, ContentValidationException {
        Path path = this.getLevelPath(p_289980_);
        List<ForbiddenSymlinkInfo> list = this.worldDirValidator.validateDirectory(path, true);
        if (!list.isEmpty()) {
            throw new ContentValidationException(path, list);
        }
        return new LevelStorageAccess(p_289980_, path);
    }

    public LevelStorageAccess createAccess(String p_78261_) throws IOException {
        Path path = this.getLevelPath(p_78261_);
        return new LevelStorageAccess(p_78261_, path);
    }

    public DirectoryValidator getWorldDirValidator() {
        return this.worldDirValidator;
    }

    public record LevelCandidates(List<LevelDirectory> levels) implements Iterable<LevelDirectory>
    {
        public boolean isEmpty() {
            return this.levels.isEmpty();
        }

        @Override
        public Iterator<LevelDirectory> iterator() {
            return this.levels.iterator();
        }
    }

    public record LevelDirectory(Path path) {
        public String directoryName() {
            return this.path.getFileName().toString();
        }

        public Path dataFile() {
            return this.resourcePath(LevelResource.LEVEL_DATA_FILE);
        }

        public Path oldDataFile() {
            return this.resourcePath(LevelResource.OLD_LEVEL_DATA_FILE);
        }

        public Path corruptedDataFile(LocalDateTime p_230857_) {
            return this.path.resolve(LevelResource.LEVEL_DATA_FILE.getId() + "_corrupted_" + p_230857_.format(FORMATTER));
        }

        public Path rawDataFile(LocalDateTime p_307373_) {
            return this.path.resolve(LevelResource.LEVEL_DATA_FILE.getId() + "_raw_" + p_307373_.format(FORMATTER));
        }

        public Path iconFile() {
            return this.resourcePath(LevelResource.ICON_FILE);
        }

        public Path lockFile() {
            return this.resourcePath(LevelResource.LOCK_FILE);
        }

        public Path resourcePath(LevelResource p_230855_) {
            return this.path.resolve(p_230855_.getId());
        }
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock lock;
        final LevelDirectory levelDirectory;
        private final String levelId;
        private final Map<LevelResource, Path> resources = Maps.newHashMap();

        LevelStorageAccess(String p_289967_, Path p_289988_) throws IOException {
            this.levelId = p_289967_;
            this.levelDirectory = new LevelDirectory(p_289988_);
            this.lock = DirectoryLock.create(p_289988_);
        }

        public long estimateDiskSpace() {
            try {
                return Files.getFileStore(this.levelDirectory.path).getUsableSpace();
            }
            catch (Exception exception) {
                return Long.MAX_VALUE;
            }
        }

        public boolean checkForLowDiskSpace() {
            return this.estimateDiskSpace() < 0x4000000L;
        }

        public void safeClose() {
            try {
                this.close();
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to unlock access to level {}", (Object)this.getLevelId(), (Object)ioexception);
            }
        }

        public LevelStorageSource parent() {
            return LevelStorageSource.this;
        }

        public LevelDirectory getLevelDirectory() {
            return this.levelDirectory;
        }

        public String getLevelId() {
            return this.levelId;
        }

        public Path getLevelPath(LevelResource p_78284_) {
            return this.resources.computeIfAbsent(p_78284_, this.levelDirectory::resourcePath);
        }

        public Path getDimensionPath(ResourceKey<Level> p_197395_) {
            return DimensionType.getStorageFolder(p_197395_, this.levelDirectory.path());
        }

        private void checkLock() {
            if (!this.lock.isValid()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public void readAdditionalLevelSaveData(boolean fallback) {
            this.checkLock();
            Path path = fallback ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile();
            try {
                Tag tag = LevelStorageSource.readLightweightData(path);
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)tag;
                    CommonHooks.readAdditionalLevelSaveData((CompoundTag)compoundTag, (LevelDirectory)this.levelDirectory);
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception reading {}", (Object)path, (Object)e);
            }
        }

        public PlayerDataStorage createPlayerStorage() {
            this.checkLock();
            return new PlayerDataStorage(this, LevelStorageSource.this.fixerUpper);
        }

        public LevelSummary getSummary(Dynamic<?> p_307314_) {
            this.checkLock();
            return LevelStorageSource.this.makeLevelSummary(p_307314_, this.levelDirectory, false);
        }

        public Dynamic<?> getDataTag() throws IOException {
            return this.getDataTag(false);
        }

        public Dynamic<?> getDataTagFallback() throws IOException {
            return this.getDataTag(true);
        }

        private Dynamic<?> getDataTag(boolean p_307503_) throws IOException {
            this.checkLock();
            return LevelStorageSource.readLevelDataTagFixed(p_307503_ ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile(), LevelStorageSource.this.fixerUpper);
        }

        public void saveDataTag(RegistryAccess p_78288_, WorldData p_78289_) {
            this.saveDataTag(p_78288_, p_78289_, null);
        }

        public void saveDataTag(RegistryAccess p_78291_, WorldData p_78292_, @Nullable CompoundTag p_78293_) {
            CompoundTag compoundtag = p_78292_.createTag(p_78291_, p_78293_);
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.put(LevelStorageSource.TAG_DATA, compoundtag);
            CommonHooks.writeAdditionalLevelSaveData((WorldData)p_78292_, (CompoundTag)compoundtag1);
            this.saveLevelData(compoundtag1);
        }

        private void saveLevelData(CompoundTag p_307262_) {
            Path path = this.levelDirectory.path();
            try {
                Path path1 = Files.createTempFile(path, "level", ".dat", new FileAttribute[0]);
                NbtIo.writeCompressed(p_307262_, path1);
                Path path2 = this.levelDirectory.oldDataFile();
                Path path3 = this.levelDirectory.dataFile();
                Util.safeReplaceFile(path3, path1, path2);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to save level {}", (Object)path, (Object)exception);
            }
        }

        public Optional<Path> getIconFile() {
            return !this.lock.isValid() ? Optional.empty() : Optional.of(this.levelDirectory.iconFile());
        }

        public Path getWorldDir() {
            return LevelStorageSource.this.baseDir;
        }

        public void deleteLevel() throws IOException {
            this.checkLock();
            final Path path = this.levelDirectory.lockFile();
            LOGGER.info("Deleting level {}", (Object)this.levelId);
            for (int i = 1; i <= 5; ++i) {
                LOGGER.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals(path)) {
                                LOGGER.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, @Nullable IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.levelDirectory.path())) {
                                LevelStorageAccess.this.lock.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i >= 5) {
                        throw ioexception;
                    }
                    LOGGER.warn("Failed to delete {}", (Object)this.levelDirectory.path(), (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void renameLevel(String p_78298_) throws IOException {
            this.modifyLevelDataWithoutDatafix(p_307270_ -> p_307270_.putString("LevelName", p_78298_.trim()));
        }

        public void renameAndDropPlayer(String p_307319_) throws IOException {
            this.modifyLevelDataWithoutDatafix(p_307287_ -> {
                p_307287_.putString("LevelName", p_307319_.trim());
                p_307287_.remove("Player");
            });
        }

        private void modifyLevelDataWithoutDatafix(Consumer<CompoundTag> p_307346_) throws IOException {
            this.checkLock();
            CompoundTag compoundtag = LevelStorageSource.readLevelDataTagRaw(this.levelDirectory.dataFile());
            p_307346_.accept(compoundtag.getCompoundOrEmpty(LevelStorageSource.TAG_DATA));
            this.saveLevelData(compoundtag);
        }

        public long makeWorldBackup() throws IOException {
            this.checkLock();
            String s = LocalDateTime.now().format(FORMATTER) + "_" + this.levelId;
            Path path = LevelStorageSource.this.getBackupPath();
            try {
                FileUtil.createDirectoriesSafe(path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtil.findAvailableName(path, s, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.levelId, new String[0]);
                Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s1 = path2.resolve(LevelStorageAccess.this.levelDirectory.path().relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s1);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        public boolean hasWorldData() {
            return Files.exists(this.levelDirectory.dataFile(), new LinkOption[0]) || Files.exists(this.levelDirectory.oldDataFile(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.lock.close();
        }

        public boolean restoreLevelDataFromOld() {
            return Util.safeReplaceOrMoveFile(this.levelDirectory.dataFile(), this.levelDirectory.oldDataFile(), this.levelDirectory.corruptedDataFile(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant getFileModificationTime(boolean p_307470_) {
            return LevelStorageSource.getFileModificationTime(p_307470_ ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile());
        }
    }
}

