/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.neoforge.common.IOUtilities;
import org.slf4j.Logger;

public class DimensionDataStorage
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final SavedData.Context context;
    private final Map<SavedDataType<?>, Optional<SavedData>> cache = new HashMap();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final Path dataFolder;
    private CompletableFuture<?> pendingWriteFuture = CompletableFuture.completedFuture(null);

    public DimensionDataStorage(SavedData.Context p_401422_, Path p_362421_, DataFixer p_78150_, HolderLookup.Provider p_324180_) {
        this.context = p_401422_;
        this.fixerUpper = p_78150_;
        this.dataFolder = p_362421_;
        this.registries = p_324180_;
    }

    private Path getDataFile(String p_78157_) {
        return this.dataFolder.resolve(p_78157_ + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedDataType<T> p_401394_) {
        T t = this.get(p_401394_);
        if (t != null) {
            return t;
        }
        SavedData t1 = (SavedData)p_401394_.constructor().apply(this.context);
        this.set(p_401394_, t1);
        return (T)t1;
    }

    @Nullable
    public <T extends SavedData> T get(SavedDataType<T> p_401285_) {
        Optional<SavedData> optional = this.cache.get(p_401285_);
        if (optional == null) {
            optional = Optional.ofNullable(this.readSavedData(p_401285_));
            this.cache.put(p_401285_, optional);
        }
        return (T)((SavedData)optional.orElse(null));
    }

    @Nullable
    private <T extends SavedData> T readSavedData(SavedDataType<T> p_401056_) {
        try {
            Path path = this.getDataFile(p_401056_.id());
            if (Files.exists(path, new LinkOption[0])) {
                CompoundTag compoundtag = this.readTagFromDisk(p_401056_.id(), p_401056_.dataFixType(), SharedConstants.getCurrentVersion().dataVersion().version());
                RegistryOps<Tag> registryops = this.registries.createSerializationContext(NbtOps.INSTANCE);
                return (T)((SavedData)p_401056_.codec().apply(this.context).parse(registryops, (Object)compoundtag.get("data")).resultOrPartial(p_400985_ -> LOGGER.error("Failed to parse saved data for '{}': {}", (Object)p_401056_, p_400985_)).orElse(null));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error loading saved data: {}", p_401056_, (Object)exception);
        }
        return null;
    }

    public <T extends SavedData> void set(SavedDataType<T> p_401359_, T p_164857_) {
        this.cache.put(p_401359_, Optional.of(p_164857_));
        p_164857_.setDirty();
    }

    public CompoundTag readTagFromDisk(String p_78159_, @Nullable DataFixTypes p_295038_, int p_78160_) throws IOException {
        CompoundTag compoundtag1;
        try (InputStream inputstream = Files.newInputStream(this.getDataFile(p_78159_), new OpenOption[0]);
             PushbackInputStream pushbackinputstream = new PushbackInputStream(new FastBufferedInputStream(inputstream), 2);){
            CompoundTag compoundtag;
            if (this.isGzip(pushbackinputstream)) {
                compoundtag = NbtIo.readCompressed(pushbackinputstream, NbtAccounter.unlimitedHeap());
            } else {
                try (DataInputStream datainputstream = new DataInputStream(pushbackinputstream);){
                    compoundtag = NbtIo.read(datainputstream);
                }
            }
            if (p_295038_ != null) {
                int i = NbtUtils.getDataVersion(compoundtag, 1343);
                compoundtag1 = p_295038_.update(this.fixerUpper, compoundtag, i, p_78160_);
            } else {
                compoundtag1 = compoundtag;
            }
        }
        this.pendingWriteFuture = this.pendingWriteFuture.thenRunAsync(() -> IOUtilities.tryCleanupTempFiles((Path)this.dataFolder, (String)p_78159_), Util.ioPool());
        return compoundtag1;
    }

    private boolean isGzip(PushbackInputStream p_78155_) throws IOException {
        int j;
        byte[] abyte = new byte[2];
        boolean flag = false;
        int i = p_78155_.read(abyte, 0, 2);
        if (i == 2 && (j = (abyte[1] & 0xFF) << 8 | abyte[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i != 0) {
            p_78155_.unread(abyte, 0, i);
        }
        return flag;
    }

    public CompletableFuture<?> scheduleSave() {
        Map<SavedDataType<?>, CompoundTag> map = this.collectDirtyTagsToSave();
        if (map.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        int i = Util.maxAllowedExecutorThreads();
        int j = map.size();
        this.pendingWriteFuture = j > i ? this.pendingWriteFuture.thenCompose(p_400982_ -> {
            ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>(i);
            int k = Mth.positiveCeilDiv(j, i);
            for (List list1 : Iterables.partition(map.entrySet(), (int)k)) {
                list.add(CompletableFuture.runAsync(() -> {
                    for (Map.Entry entry : list1) {
                        this.tryWrite((SavedDataType)entry.getKey(), (CompoundTag)entry.getValue());
                    }
                }, Util.ioPool()));
            }
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        }) : this.pendingWriteFuture.thenCompose(p_400974_ -> CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(p_400983_ -> CompletableFuture.runAsync(() -> this.tryWrite((SavedDataType)p_400983_.getKey(), (CompoundTag)p_400983_.getValue()), Util.ioPool())).toArray(CompletableFuture[]::new)));
        return this.pendingWriteFuture;
    }

    private Map<SavedDataType<?>, CompoundTag> collectDirtyTagsToSave() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        RegistryOps<Tag> registryops = this.registries.createSerializationContext(NbtOps.INSTANCE);
        this.cache.forEach((arg_0, arg_1) -> this.lambda$collectDirtyTagsToSave$10((Map)map, registryops, arg_0, arg_1));
        return map;
    }

    private <T extends SavedData> CompoundTag encodeUnchecked(SavedDataType<T> p_401078_, SavedData p_401244_, RegistryOps<Tag> p_401357_) {
        Codec<T> codec = p_401078_.codec().apply(this.context);
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.put("data", (Tag)codec.encodeStart(p_401357_, (Object)p_401244_).getOrThrow());
        NbtUtils.addCurrentDataVersion(compoundtag);
        return compoundtag;
    }

    private void tryWrite(SavedDataType<?> p_401021_, CompoundTag p_390657_) {
        Path path = this.getDataFile(p_401021_.id());
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            IOUtilities.writeNbtCompressed((CompoundTag)p_390657_, (Path)path);
        }
        catch (IOException ioexception) {
            LOGGER.error("Could not save data to {}", (Object)path.getFileName(), (Object)ioexception);
        }
    }

    public void saveAndJoin() {
        this.scheduleSave().join();
    }

    @Override
    public void close() {
        this.saveAndJoin();
    }

    private /* synthetic */ void lambda$collectDirtyTagsToSave$10(Map map, RegistryOps registryops, SavedDataType p_400971_, Optional p_400972_) {
        p_400972_.filter(SavedData::isDirty).ifPresent(p_400978_ -> {
            map.put(p_400971_, this.encodeUnchecked(p_400971_, (SavedData)p_400978_, registryops));
            p_400978_.setDirty(false);
        });
    }
}

