/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, Container> namespaces = new HashMap<String, Container>();
    private final DimensionDataStorage storage;

    public CommandStorage(DimensionDataStorage p_78035_) {
        this.storage = p_78035_;
    }

    public CompoundTag get(ResourceLocation p_78045_) {
        Container commandstorage$container = this.getContainer(p_78045_.getNamespace());
        return commandstorage$container != null ? commandstorage$container.get(p_78045_.getPath()) : new CompoundTag();
    }

    @Nullable
    private Container getContainer(String p_401283_) {
        Container commandstorage$container = this.namespaces.get(p_401283_);
        if (commandstorage$container != null) {
            return commandstorage$container;
        }
        Container commandstorage$container1 = this.storage.get(Container.type(p_401283_));
        if (commandstorage$container1 != null) {
            this.namespaces.put(p_401283_, commandstorage$container1);
        }
        return commandstorage$container1;
    }

    private Container getOrCreateContainer(String p_401189_) {
        Container commandstorage$container = this.namespaces.get(p_401189_);
        if (commandstorage$container != null) {
            return commandstorage$container;
        }
        Container commandstorage$container1 = this.storage.computeIfAbsent(Container.type(p_401189_));
        this.namespaces.put(p_401189_, commandstorage$container1);
        return commandstorage$container1;
    }

    public void set(ResourceLocation p_78047_, CompoundTag p_78048_) {
        this.getOrCreateContainer(p_78047_.getNamespace()).put(p_78047_.getPath(), p_78048_);
    }

    public Stream<ResourceLocation> keys() {
        return this.namespaces.entrySet().stream().flatMap(p_164841_ -> ((Container)p_164841_.getValue()).getKeys((String)p_164841_.getKey()));
    }

    static String createId(String p_78038_) {
        return ID_PREFIX + p_78038_;
    }

    static class Container
    extends SavedData {
        public static final Codec<Container> CODEC = RecordCodecBuilder.create(p_400967_ -> p_400967_.group((App)Codec.unboundedMap(ExtraCodecs.RESOURCE_PATH_CODEC, CompoundTag.CODEC).fieldOf("contents").forGetter(p_400968_ -> p_400968_.storage)).apply((Applicative)p_400967_, Container::new));
        private final Map<String, CompoundTag> storage;

        private Container(Map<String, CompoundTag> p_401367_) {
            this.storage = new HashMap<String, CompoundTag>(p_401367_);
        }

        private Container() {
            this(new HashMap<String, CompoundTag>());
        }

        public static SavedDataType<Container> type(String p_401227_) {
            return new SavedDataType<Container>(CommandStorage.createId(p_401227_), Container::new, CODEC, DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
        }

        public CompoundTag get(String p_78059_) {
            CompoundTag compoundtag = this.storage.get(p_78059_);
            return compoundtag != null ? compoundtag : new CompoundTag();
        }

        public void put(String p_78064_, CompoundTag p_78065_) {
            if (p_78065_.isEmpty()) {
                this.storage.remove(p_78064_);
            } else {
                this.storage.put(p_78064_, p_78065_);
            }
            this.setDirty();
        }

        public Stream<ResourceLocation> getKeys(String p_78073_) {
            return this.storage.keySet().stream().map(p_350257_ -> ResourceLocation.fromNamespaceAndPath(p_78073_, p_350257_));
        }
    }
}

