/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;

public class FlyNodeEvaluator
extends WalkNodeEvaluator {
    private final Long2ObjectMap<PathType> pathTypeByPosCache = new Long2ObjectOpenHashMap();
    private static final float SMALL_MOB_SIZE = 1.0f;
    private static final float SMALL_MOB_INFLATED_START_NODE_BOUNDING_BOX = 1.1f;
    private static final int MAX_START_NODE_CANDIDATES = 10;

    @Override
    public void prepare(PathNavigationRegion p_77261_, Mob p_77262_) {
        super.prepare(p_77261_, p_77262_);
        this.pathTypeByPosCache.clear();
        p_77262_.onPathfindingStart();
    }

    @Override
    public void done() {
        this.mob.onPathfindingDone();
        this.pathTypeByPosCache.clear();
        super.done();
    }

    @Override
    public Node getStart() {
        BlockPos blockpos1;
        int i;
        if (this.canFloat() && this.mob.isInWater()) {
            i = this.mob.getBlockY();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(this.mob.getX(), (double)i, this.mob.getZ());
            BlockState blockstate = this.currentContext.getBlockState(blockpos$mutableblockpos);
            while (blockstate.is(Blocks.WATER)) {
                blockpos$mutableblockpos.set(this.mob.getX(), (double)(++i), this.mob.getZ());
                blockstate = this.currentContext.getBlockState(blockpos$mutableblockpos);
            }
        } else {
            i = Mth.floor(this.mob.getY() + 0.5);
        }
        if (!this.canStartAt(blockpos1 = BlockPos.containing(this.mob.getX(), i, this.mob.getZ()))) {
            for (BlockPos blockpos : this.iteratePathfindingStartNodeCandidatePositions(this.mob)) {
                if (!this.canStartAt(blockpos)) continue;
                return super.getStartNode(blockpos);
            }
        }
        return super.getStartNode(blockpos1);
    }

    @Override
    protected boolean canStartAt(BlockPos p_262645_) {
        PathType pathtype = this.getCachedPathType(p_262645_.getX(), p_262645_.getY(), p_262645_.getZ());
        return this.mob.getPathfindingMalus(pathtype) >= 0.0f;
    }

    @Override
    public Target getTarget(double p_326875_, double p_326936_, double p_326811_) {
        return this.getTargetNodeAt(p_326875_, p_326936_, p_326811_);
    }

    @Override
    public int getNeighbors(Node[] p_77266_, Node p_77267_) {
        Node node25;
        Node node24;
        Node node23;
        Node node22;
        Node node21;
        Node node20;
        Node node19;
        Node node18;
        Node node17;
        Node node16;
        Node node15;
        Node node14;
        Node node13;
        Node node12;
        Node node11;
        Node node10;
        Node node9;
        Node node8;
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node node3;
        Node node2;
        Node node1;
        int i = 0;
        Node node = this.findAcceptedNode(p_77267_.x, p_77267_.y, p_77267_.z + 1);
        if (this.isOpen(node)) {
            p_77266_[i++] = node;
        }
        if (this.isOpen(node1 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y, p_77267_.z))) {
            p_77266_[i++] = node1;
        }
        if (this.isOpen(node2 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y, p_77267_.z))) {
            p_77266_[i++] = node2;
        }
        if (this.isOpen(node3 = this.findAcceptedNode(p_77267_.x, p_77267_.y, p_77267_.z - 1))) {
            p_77266_[i++] = node3;
        }
        if (this.isOpen(node4 = this.findAcceptedNode(p_77267_.x, p_77267_.y + 1, p_77267_.z))) {
            p_77266_[i++] = node4;
        }
        if (this.isOpen(node5 = this.findAcceptedNode(p_77267_.x, p_77267_.y - 1, p_77267_.z))) {
            p_77266_[i++] = node5;
        }
        if (this.isOpen(node6 = this.findAcceptedNode(p_77267_.x, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node4)) {
            p_77266_[i++] = node6;
        }
        if (this.isOpen(node7 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z)) && this.hasMalus(node1) && this.hasMalus(node4)) {
            p_77266_[i++] = node7;
        }
        if (this.isOpen(node8 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z)) && this.hasMalus(node2) && this.hasMalus(node4)) {
            p_77266_[i++] = node8;
        }
        if (this.isOpen(node9 = this.findAcceptedNode(p_77267_.x, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node4)) {
            p_77266_[i++] = node9;
        }
        if (this.isOpen(node10 = this.findAcceptedNode(p_77267_.x, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node5)) {
            p_77266_[i++] = node10;
        }
        if (this.isOpen(node11 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z)) && this.hasMalus(node1) && this.hasMalus(node5)) {
            p_77266_[i++] = node11;
        }
        if (this.isOpen(node12 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z)) && this.hasMalus(node2) && this.hasMalus(node5)) {
            p_77266_[i++] = node12;
        }
        if (this.isOpen(node13 = this.findAcceptedNode(p_77267_.x, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node5)) {
            p_77266_[i++] = node13;
        }
        if (this.isOpen(node14 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node2)) {
            p_77266_[i++] = node14;
        }
        if (this.isOpen(node15 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node2)) {
            p_77266_[i++] = node15;
        }
        if (this.isOpen(node16 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y, p_77267_.z - 1)) && this.hasMalus(node3) && this.hasMalus(node1)) {
            p_77266_[i++] = node16;
        }
        if (this.isOpen(node17 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y, p_77267_.z + 1)) && this.hasMalus(node) && this.hasMalus(node1)) {
            p_77266_[i++] = node17;
        }
        if (this.isOpen(node18 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus(node14) && this.hasMalus(node3) && this.hasMalus(node2) && this.hasMalus(node4) && this.hasMalus(node9) && this.hasMalus(node8)) {
            p_77266_[i++] = node18;
        }
        if (this.isOpen(node19 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus(node15) && this.hasMalus(node) && this.hasMalus(node2) && this.hasMalus(node4) && this.hasMalus(node6) && this.hasMalus(node8)) {
            p_77266_[i++] = node19;
        }
        if (this.isOpen(node20 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus(node16) && this.hasMalus(node3) && this.hasMalus(node1) && this.hasMalus(node4) && this.hasMalus(node9) && this.hasMalus(node7)) {
            p_77266_[i++] = node20;
        }
        if (this.isOpen(node21 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus(node17) && this.hasMalus(node) && this.hasMalus(node1) && this.hasMalus(node4) && this.hasMalus(node6) && this.hasMalus(node7)) {
            p_77266_[i++] = node21;
        }
        if (this.isOpen(node22 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus(node14) && this.hasMalus(node3) && this.hasMalus(node2) && this.hasMalus(node5) && this.hasMalus(node13) && this.hasMalus(node12)) {
            p_77266_[i++] = node22;
        }
        if (this.isOpen(node23 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus(node15) && this.hasMalus(node) && this.hasMalus(node2) && this.hasMalus(node5) && this.hasMalus(node10) && this.hasMalus(node12)) {
            p_77266_[i++] = node23;
        }
        if (this.isOpen(node24 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus(node16) && this.hasMalus(node3) && this.hasMalus(node1) && this.hasMalus(node5) && this.hasMalus(node13) && this.hasMalus(node11)) {
            p_77266_[i++] = node24;
        }
        if (this.isOpen(node25 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus(node17) && this.hasMalus(node) && this.hasMalus(node1) && this.hasMalus(node5) && this.hasMalus(node10) && this.hasMalus(node11)) {
            p_77266_[i++] = node25;
        }
        return i;
    }

    private boolean hasMalus(@Nullable Node p_77264_) {
        return p_77264_ != null && p_77264_.costMalus >= 0.0f;
    }

    private boolean isOpen(@Nullable Node p_77270_) {
        return p_77270_ != null && !p_77270_.closed;
    }

    @Nullable
    protected Node findAcceptedNode(int p_262970_, int p_263018_, int p_262947_) {
        Node node = null;
        PathType pathtype = this.getCachedPathType(p_262970_, p_263018_, p_262947_);
        float f = this.mob.getPathfindingMalus(pathtype);
        if (f >= 0.0f) {
            node = this.getNode(p_262970_, p_263018_, p_262947_);
            node.type = pathtype;
            node.costMalus = Math.max(node.costMalus, f);
            if (pathtype == PathType.WALKABLE) {
                node.costMalus += 1.0f;
            }
        }
        return node;
    }

    @Override
    protected PathType getCachedPathType(int p_326867_, int p_326833_, int p_326788_) {
        return (PathType)((Object)this.pathTypeByPosCache.computeIfAbsent(BlockPos.asLong(p_326867_, p_326833_, p_326788_), p_330153_ -> this.getPathTypeOfMob(this.currentContext, p_326867_, p_326833_, p_326788_, this.mob)));
    }

    @Override
    public PathType getPathType(PathfindingContext p_331058_, int p_77246_, int p_77247_, int p_77248_) {
        PathType pathtype = p_331058_.getPathTypeFromState(p_77246_, p_77247_, p_77248_);
        if (pathtype == PathType.OPEN && p_77247_ >= p_331058_.level().getMinY() + 1) {
            BlockPos blockpos = new BlockPos(p_77246_, p_77247_ - 1, p_77248_);
            PathType pathtype1 = p_331058_.getPathTypeFromState(blockpos.getX(), blockpos.getY(), blockpos.getZ());
            if (pathtype1 == PathType.DAMAGE_FIRE || pathtype1 == PathType.LAVA) {
                pathtype = PathType.DAMAGE_FIRE;
            } else if (pathtype1 == PathType.DAMAGE_OTHER) {
                pathtype = PathType.DAMAGE_OTHER;
            } else if (pathtype1 == PathType.COCOA) {
                pathtype = PathType.COCOA;
            } else if (pathtype1 == PathType.FENCE) {
                if (!blockpos.equals(p_331058_.mobPosition())) {
                    pathtype = PathType.FENCE;
                }
            } else {
                PathType pathType = pathtype = pathtype1 != PathType.WALKABLE && pathtype1 != PathType.OPEN && pathtype1 != PathType.WATER ? PathType.WALKABLE : PathType.OPEN;
            }
        }
        if (pathtype == PathType.WALKABLE || pathtype == PathType.OPEN) {
            pathtype = FlyNodeEvaluator.checkNeighbourBlocks(p_331058_, p_77246_, p_77247_, p_77248_, pathtype);
        }
        return pathtype;
    }

    private Iterable<BlockPos> iteratePathfindingStartNodeCandidatePositions(Mob p_263108_) {
        boolean flag;
        AABB aabb = p_263108_.getBoundingBox();
        boolean bl = flag = aabb.getSize() < 1.0;
        if (!flag) {
            return List.of(BlockPos.containing(aabb.minX, p_263108_.getBlockY(), aabb.minZ), BlockPos.containing(aabb.minX, p_263108_.getBlockY(), aabb.maxZ), BlockPos.containing(aabb.maxX, p_263108_.getBlockY(), aabb.minZ), BlockPos.containing(aabb.maxX, p_263108_.getBlockY(), aabb.maxZ));
        }
        double d0 = Math.max(0.0, (double)1.1f - aabb.getZsize());
        double d1 = Math.max(0.0, (double)1.1f - aabb.getXsize());
        double d2 = Math.max(0.0, (double)1.1f - aabb.getYsize());
        AABB aabb1 = aabb.inflate(d1, d2, d0);
        return BlockPos.randomBetweenClosed(p_263108_.getRandom(), 10, Mth.floor(aabb1.minX), Mth.floor(aabb1.minY), Mth.floor(aabb1.minZ), Mth.floor(aabb1.maxX), Mth.floor(aabb1.maxY), Mth.floor(aabb1.maxZ));
    }
}

