/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class PerlinSimplexNoise {
    private final SimplexNoise[] noiseLevels;
    private final double highestFreqValueFactor;
    private final double highestFreqInputFactor;

    public PerlinSimplexNoise(RandomSource p_230546_, List<Integer> p_230547_) {
        this(p_230546_, (IntSortedSet)new IntRBTreeSet(p_230547_));
    }

    private PerlinSimplexNoise(RandomSource p_230543_, IntSortedSet p_230544_) {
        int j;
        if (p_230544_.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i = -p_230544_.firstInt();
        int k = i + (j = p_230544_.lastInt()) + 1;
        if (k < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        SimplexNoise simplexnoise = new SimplexNoise(p_230543_);
        int l = j;
        this.noiseLevels = new SimplexNoise[k];
        if (j >= 0 && j < k && p_230544_.contains(0)) {
            this.noiseLevels[j] = simplexnoise;
        }
        for (int i1 = j + 1; i1 < k; ++i1) {
            if (i1 >= 0 && p_230544_.contains(l - i1)) {
                this.noiseLevels[i1] = new SimplexNoise(p_230543_);
                continue;
            }
            p_230543_.consumeCount(262);
        }
        if (j > 0) {
            long k1 = (long)(simplexnoise.getValue(simplexnoise.xo, simplexnoise.yo, simplexnoise.zo) * 9.223372036854776E18);
            WorldgenRandom randomsource = new WorldgenRandom(new LegacyRandomSource(k1));
            for (int j1 = l - 1; j1 >= 0; --j1) {
                if (j1 < k && p_230544_.contains(l - j1)) {
                    this.noiseLevels[j1] = new SimplexNoise(randomsource);
                    continue;
                }
                randomsource.consumeCount(262);
            }
        }
        this.highestFreqInputFactor = Math.pow(2.0, j);
        this.highestFreqValueFactor = 1.0 / (Math.pow(2.0, k) - 1.0);
    }

    public double getValue(double p_75450_, double p_75451_, boolean p_75452_) {
        double d0 = 0.0;
        double d1 = this.highestFreqInputFactor;
        double d2 = this.highestFreqValueFactor;
        for (SimplexNoise simplexnoise : this.noiseLevels) {
            if (simplexnoise != null) {
                d0 += simplexnoise.getValue(p_75450_ * d1 + (p_75452_ ? simplexnoise.xo : 0.0), p_75451_ * d1 + (p_75452_ ? simplexnoise.yo : 0.0)) * d2;
            }
            d1 /= 2.0;
            d2 *= 2.0;
        }
        return d0;
    }
}

