/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class PaleMossDecorator
extends TreeDecorator {
    public static final MapCodec<PaleMossDecorator> CODEC = RecordCodecBuilder.mapCodec(p_379602_ -> p_379602_.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("leaves_probability").forGetter(p_379568_ -> Float.valueOf(p_379568_.leavesProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trunk_probability").forGetter(p_379338_ -> Float.valueOf(p_379338_.trunkProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ground_probability").forGetter(p_379346_ -> Float.valueOf(p_379346_.groundProbability))).apply((Applicative)p_379602_, PaleMossDecorator::new));
    private final float leavesProbability;
    private final float trunkProbability;
    private final float groundProbability;

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.PALE_MOSS;
    }

    public PaleMossDecorator(float p_379816_, float p_379583_, float p_380313_) {
        this.leavesProbability = p_379816_;
        this.trunkProbability = p_379583_;
        this.groundProbability = p_380313_;
    }

    @Override
    public void place(TreeDecorator.Context p_379317_) {
        RandomSource randomsource = p_379317_.random();
        WorldGenLevel worldgenlevel = (WorldGenLevel)p_379317_.level();
        List<BlockPos> list = Util.shuffledCopy(p_379317_.logs(), randomsource);
        if (!list.isEmpty()) {
            MutableObject mutable = new MutableObject((Object)list.getFirst());
            list.forEach(arg_0 -> PaleMossDecorator.lambda$place$4((Mutable)mutable, arg_0));
            BlockPos blockpos = (BlockPos)mutable.getValue();
            if (randomsource.nextFloat() < this.groundProbability) {
                worldgenlevel.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(p_382782_ -> p_382782_.get(VegetationFeatures.PALE_MOSS_PATCH)).ifPresent(p_380064_ -> ((ConfiguredFeature)p_380064_.value()).place(worldgenlevel, worldgenlevel.getLevel().getChunkSource().getGenerator(), randomsource, blockpos.above()));
            }
            p_379317_.logs().forEach(p_382781_ -> {
                BlockPos blockpos1;
                if (randomsource.nextFloat() < this.trunkProbability && p_379317_.isAir(blockpos1 = p_382781_.below())) {
                    PaleMossDecorator.addMossHanger(blockpos1, p_379317_);
                }
            });
            p_379317_.leaves().forEach(p_380012_ -> {
                BlockPos blockpos1;
                if (randomsource.nextFloat() < this.leavesProbability && p_379317_.isAir(blockpos1 = p_380012_.below())) {
                    PaleMossDecorator.addMossHanger(blockpos1, p_379317_);
                }
            });
        }
    }

    private static void addMossHanger(BlockPos p_379694_, TreeDecorator.Context p_379973_) {
        while (p_379973_.isAir(p_379694_.below()) && !((double)p_379973_.random().nextFloat() < 0.5)) {
            p_379973_.setBlock(p_379694_, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, false));
            p_379694_ = p_379694_.below();
        }
        p_379973_.setBlock(p_379694_, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, true));
    }

    private static /* synthetic */ void lambda$place$4(Mutable mutable, BlockPos p_379657_) {
        if (p_379657_.getY() < ((BlockPos)mutable.getValue()).getY()) {
            mutable.setValue((Object)p_379657_);
        }
    }
}

