/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LeaveVineDecorator
extends TreeDecorator {
    public static final MapCodec<LeaveVineDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(LeaveVineDecorator::new, p_226037_ -> Float.valueOf(p_226037_.probability));
    private final float probability;

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.LEAVE_VINE;
    }

    public LeaveVineDecorator(float p_226031_) {
        this.probability = p_226031_;
    }

    @Override
    public void place(TreeDecorator.Context p_226039_) {
        RandomSource randomsource = p_226039_.random();
        p_226039_.leaves().forEach(p_226035_ -> {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos1;
            BlockPos blockpos;
            if (randomsource.nextFloat() < this.probability && p_226039_.isAir(blockpos = p_226035_.west())) {
                LeaveVineDecorator.addHangingVine(blockpos, VineBlock.EAST, p_226039_);
            }
            if (randomsource.nextFloat() < this.probability && p_226039_.isAir(blockpos1 = p_226035_.east())) {
                LeaveVineDecorator.addHangingVine(blockpos1, VineBlock.WEST, p_226039_);
            }
            if (randomsource.nextFloat() < this.probability && p_226039_.isAir(blockpos2 = p_226035_.north())) {
                LeaveVineDecorator.addHangingVine(blockpos2, VineBlock.SOUTH, p_226039_);
            }
            if (randomsource.nextFloat() < this.probability && p_226039_.isAir(blockpos3 = p_226035_.south())) {
                LeaveVineDecorator.addHangingVine(blockpos3, VineBlock.NORTH, p_226039_);
            }
        });
    }

    private static void addHangingVine(BlockPos p_226041_, BooleanProperty p_226042_, TreeDecorator.Context p_226043_) {
        p_226043_.placeVine(p_226041_, p_226042_);
        BlockPos blockpos = p_226041_.below();
        for (int i = 4; p_226043_.isAir(blockpos) && i > 0; --i) {
            p_226043_.placeVine(blockpos, p_226042_);
            blockpos = blockpos.below();
        }
    }
}

