/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CreakingHeartDecorator
extends TreeDecorator {
    public static final MapCodec<CreakingHeartDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CreakingHeartDecorator::new, p_379513_ -> Float.valueOf(p_379513_.probability));
    private final float probability;

    public CreakingHeartDecorator(float p_379887_) {
        this.probability = p_379887_;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.CREAKING_HEART;
    }

    @Override
    public void place(TreeDecorator.Context p_379637_) {
        RandomSource randomsource = p_379637_.random();
        ObjectArrayList<BlockPos> list = p_379637_.logs();
        if (!list.isEmpty() && !(randomsource.nextFloat() >= this.probability)) {
            ArrayList<BlockPos> list1 = new ArrayList<BlockPos>((Collection<BlockPos>)list);
            Util.shuffle(list1, randomsource);
            Optional<BlockPos> optional = list1.stream().filter(p_380105_ -> {
                for (Direction direction : Direction.values()) {
                    if (p_379637_.checkBlock(p_380105_.relative(direction), p_379435_ -> p_379435_.is(BlockTags.LOGS))) continue;
                    return false;
                }
                return true;
            }).findFirst();
            if (!optional.isEmpty()) {
                p_379637_.setBlock(optional.get(), (BlockState)((BlockState)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.STATE, CreakingHeartState.DORMANT)).setValue(CreakingHeartBlock.NATURAL, true));
            }
        }
    }
}

