/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CocoaDecorator
extends TreeDecorator {
    public static final MapCodec<CocoaDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CocoaDecorator::new, p_69989_ -> Float.valueOf(p_69989_.probability));
    private final float probability;

    public CocoaDecorator(float p_69976_) {
        this.probability = p_69976_;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.COCOA;
    }

    @Override
    public void place(TreeDecorator.Context p_226028_) {
        ObjectArrayList<BlockPos> list;
        RandomSource randomsource = p_226028_.random();
        if (!(randomsource.nextFloat() >= this.probability) && !(list = p_226028_.logs()).isEmpty()) {
            int i = ((BlockPos)list.getFirst()).getY();
            list.stream().filter(p_69980_ -> p_69980_.getY() - i <= 2).forEach(p_226026_ -> {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction1;
                    BlockPos blockpos;
                    if (!(randomsource.nextFloat() <= 0.25f) || !p_226028_.isAir(blockpos = p_226026_.offset((direction1 = direction.getOpposite()).getStepX(), 0, direction1.getStepZ()))) continue;
                    p_226028_.setBlock(blockpos, (BlockState)((BlockState)Blocks.COCOA.defaultBlockState().setValue(CocoaBlock.AGE, randomsource.nextInt(3))).setValue(CocoaBlock.FACING, direction));
                }
            });
        }
    }
}

