/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EndPodiumFeature
extends Feature<NoneFeatureConfiguration> {
    public static final int PODIUM_RADIUS = 4;
    public static final int PODIUM_PILLAR_HEIGHT = 4;
    public static final int RIM_RADIUS = 1;
    public static final float CORNER_ROUNDING = 0.5f;
    private static final BlockPos END_PODIUM_LOCATION = BlockPos.ZERO;
    private final boolean active;

    public static BlockPos getLocation(BlockPos p_287614_) {
        return END_PODIUM_LOCATION.offset(p_287614_);
    }

    public EndPodiumFeature(boolean p_65718_) {
        super(NoneFeatureConfiguration.CODEC);
        this.active = p_65718_;
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> p_159723_) {
        BlockPos blockpos = p_159723_.origin();
        WorldGenLevel worldgenlevel = p_159723_.level();
        for (BlockPos blockpos1 : BlockPos.betweenClosed(new BlockPos(blockpos.getX() - 4, blockpos.getY() - 1, blockpos.getZ() - 4), new BlockPos(blockpos.getX() + 4, blockpos.getY() + 32, blockpos.getZ() + 4))) {
            boolean flag = blockpos1.closerThan(blockpos, 2.5);
            if (!flag && !blockpos1.closerThan(blockpos, 3.5)) continue;
            if (blockpos1.getY() < blockpos.getY()) {
                if (flag) {
                    this.setBlock(worldgenlevel, blockpos1, Blocks.BEDROCK.defaultBlockState());
                    continue;
                }
                if (blockpos1.getY() >= blockpos.getY()) continue;
                if (this.active) {
                    this.dropPreviousAndSetBlock(worldgenlevel, blockpos1, Blocks.END_STONE);
                    continue;
                }
                this.setBlock(worldgenlevel, blockpos1, Blocks.END_STONE.defaultBlockState());
                continue;
            }
            if (blockpos1.getY() > blockpos.getY()) {
                if (this.active) {
                    this.dropPreviousAndSetBlock(worldgenlevel, blockpos1, Blocks.AIR);
                    continue;
                }
                this.setBlock(worldgenlevel, blockpos1, Blocks.AIR.defaultBlockState());
                continue;
            }
            if (!flag) {
                this.setBlock(worldgenlevel, blockpos1, Blocks.BEDROCK.defaultBlockState());
                continue;
            }
            if (this.active) {
                this.dropPreviousAndSetBlock(worldgenlevel, new BlockPos(blockpos1), Blocks.END_PORTAL);
                continue;
            }
            this.setBlock(worldgenlevel, new BlockPos(blockpos1), Blocks.AIR.defaultBlockState());
        }
        for (int i = 0; i < 4; ++i) {
            this.setBlock(worldgenlevel, blockpos.above(i), Blocks.BEDROCK.defaultBlockState());
        }
        BlockPos blockpos2 = blockpos.above(2);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.setBlock(worldgenlevel, blockpos2.relative(direction), (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, direction));
        }
        return true;
    }

    private void dropPreviousAndSetBlock(WorldGenLevel p_397617_, BlockPos p_397897_, Block p_397762_) {
        if (!p_397617_.getBlockState(p_397897_).is(p_397762_)) {
            p_397617_.destroyBlock(p_397897_, true, null);
            this.setBlock(p_397617_, p_397897_, p_397762_.defaultBlockState());
        }
    }
}

