/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class SurfaceRules {
    public static final ConditionSource ON_FLOOR = SurfaceRules.stoneDepthCheck(0, false, CaveSurface.FLOOR);
    public static final ConditionSource UNDER_FLOOR = SurfaceRules.stoneDepthCheck(0, true, CaveSurface.FLOOR);
    public static final ConditionSource DEEP_UNDER_FLOOR = SurfaceRules.stoneDepthCheck(0, true, 6, CaveSurface.FLOOR);
    public static final ConditionSource VERY_DEEP_UNDER_FLOOR = SurfaceRules.stoneDepthCheck(0, true, 30, CaveSurface.FLOOR);
    public static final ConditionSource ON_CEILING = SurfaceRules.stoneDepthCheck(0, false, CaveSurface.CEILING);
    public static final ConditionSource UNDER_CEILING = SurfaceRules.stoneDepthCheck(0, true, CaveSurface.CEILING);

    public static ConditionSource stoneDepthCheck(int p_202177_, boolean p_202178_, CaveSurface p_202179_) {
        return new StoneDepthCheck(p_202177_, p_202178_, 0, p_202179_);
    }

    public static ConditionSource stoneDepthCheck(int p_202172_, boolean p_202173_, int p_202174_, CaveSurface p_202175_) {
        return new StoneDepthCheck(p_202172_, p_202173_, p_202174_, p_202175_);
    }

    public static ConditionSource not(ConditionSource p_189393_) {
        return new NotConditionSource(p_189393_);
    }

    public static ConditionSource yBlockCheck(VerticalAnchor p_189401_, int p_189402_) {
        return new YConditionSource(p_189401_, p_189402_, false);
    }

    public static ConditionSource yStartCheck(VerticalAnchor p_189423_, int p_189424_) {
        return new YConditionSource(p_189423_, p_189424_, true);
    }

    public static ConditionSource waterBlockCheck(int p_189383_, int p_189384_) {
        return new WaterConditionSource(p_189383_, p_189384_, false);
    }

    public static ConditionSource waterStartCheck(int p_189420_, int p_189421_) {
        return new WaterConditionSource(p_189420_, p_189421_, true);
    }

    @SafeVarargs
    public static ConditionSource isBiome(ResourceKey<Biome> ... p_189417_) {
        return SurfaceRules.isBiome(List.of(p_189417_));
    }

    private static BiomeConditionSource isBiome(List<ResourceKey<Biome>> p_189408_) {
        return new BiomeConditionSource(p_189408_);
    }

    public static ConditionSource noiseCondition(ResourceKey<NormalNoise.NoiseParameters> p_189410_, double p_189411_) {
        return SurfaceRules.noiseCondition(p_189410_, p_189411_, Double.MAX_VALUE);
    }

    public static ConditionSource noiseCondition(ResourceKey<NormalNoise.NoiseParameters> p_189413_, double p_189414_, double p_189415_) {
        return new NoiseThresholdConditionSource(p_189413_, p_189414_, p_189415_);
    }

    public static ConditionSource verticalGradient(String p_189404_, VerticalAnchor p_189405_, VerticalAnchor p_189406_) {
        return new VerticalGradientConditionSource(ResourceLocation.parse(p_189404_), p_189405_, p_189406_);
    }

    public static ConditionSource steep() {
        return Steep.INSTANCE;
    }

    public static ConditionSource hole() {
        return Hole.INSTANCE;
    }

    public static ConditionSource abovePreliminarySurface() {
        return AbovePreliminarySurface.INSTANCE;
    }

    public static ConditionSource temperature() {
        return Temperature.INSTANCE;
    }

    public static RuleSource ifTrue(ConditionSource p_189395_, RuleSource p_189396_) {
        return new TestRuleSource(p_189395_, p_189396_);
    }

    public static RuleSource sequence(RuleSource ... p_198273_) {
        if (p_198273_.length == 0) {
            throw new IllegalArgumentException("Need at least 1 rule for a sequence");
        }
        return new SequenceRuleSource(Arrays.asList(p_198273_));
    }

    public static RuleSource state(BlockState p_189391_) {
        return new BlockRuleSource(p_189391_);
    }

    public static RuleSource bandlands() {
        return Bandlands.INSTANCE;
    }

    static <A> MapCodec<? extends A> register(Registry<MapCodec<? extends A>> p_224604_, String p_224605_, KeyDispatchDataCodec<? extends A> p_224606_) {
        return Registry.register(p_224604_, p_224605_, p_224606_.codec());
    }

    record StoneDepthCheck(int offset, boolean addSurfaceDepth, int secondaryDepthRange, CaveSurface surfaceType) implements ConditionSource
    {
        static final KeyDispatchDataCodec<StoneDepthCheck> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(p_189753_ -> p_189753_.group((App)Codec.INT.fieldOf("offset").forGetter(StoneDepthCheck::offset), (App)Codec.BOOL.fieldOf("add_surface_depth").forGetter(StoneDepthCheck::addSurfaceDepth), (App)Codec.INT.fieldOf("secondary_depth_range").forGetter(StoneDepthCheck::secondaryDepthRange), (App)CaveSurface.CODEC.fieldOf("surface_type").forGetter(StoneDepthCheck::surfaceType)).apply((Applicative)p_189753_, StoneDepthCheck::new)));

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(final Context p_189755_) {
            final boolean flag = this.surfaceType == CaveSurface.CEILING;
            class StoneDepthCondition
            extends LazyYCondition {
                StoneDepthCondition() {
                    super(context);
                }

                @Override
                protected boolean compute() {
                    int i = flag ? this.context.stoneDepthBelow : this.context.stoneDepthAbove;
                    int j = StoneDepthCheck.this.addSurfaceDepth ? this.context.surfaceDepth : 0;
                    int k = StoneDepthCheck.this.secondaryDepthRange == 0 ? 0 : (int)Mth.map(this.context.getSurfaceSecondary(), -1.0, 1.0, 0.0, (double)StoneDepthCheck.this.secondaryDepthRange);
                    return i <= 1 + StoneDepthCheck.this.offset + j + k;
                }
            }
            return new StoneDepthCondition();
        }
    }

    record NotConditionSource(ConditionSource target) implements ConditionSource
    {
        static final KeyDispatchDataCodec<NotConditionSource> CODEC = KeyDispatchDataCodec.of(ConditionSource.CODEC.xmap(NotConditionSource::new, NotConditionSource::target).fieldOf("invert"));

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context p_189674_) {
            return new NotCondition((Condition)this.target.apply(p_189674_));
        }
    }

    public static interface ConditionSource
    extends Function<Context, Condition> {
        public static final Codec<ConditionSource> CODEC = BuiltInRegistries.MATERIAL_CONDITION.byNameCodec().dispatch(p_338094_ -> p_338094_.codec().codec(), Function.identity());

        public static MapCodec<? extends ConditionSource> bootstrap(Registry<MapCodec<? extends ConditionSource>> p_204625_) {
            SurfaceRules.register(p_204625_, "biome", BiomeConditionSource.CODEC);
            SurfaceRules.register(p_204625_, "noise_threshold", NoiseThresholdConditionSource.CODEC);
            SurfaceRules.register(p_204625_, "vertical_gradient", VerticalGradientConditionSource.CODEC);
            SurfaceRules.register(p_204625_, "y_above", YConditionSource.CODEC);
            SurfaceRules.register(p_204625_, "water", WaterConditionSource.CODEC);
            SurfaceRules.register(p_204625_, "temperature", Temperature.CODEC);
            SurfaceRules.register(p_204625_, "steep", Steep.CODEC);
            SurfaceRules.register(p_204625_, "not", NotConditionSource.CODEC);
            SurfaceRules.register(p_204625_, "hole", Hole.CODEC);
            SurfaceRules.register(p_204625_, "above_preliminary_surface", AbovePreliminarySurface.CODEC);
            return SurfaceRules.register(p_204625_, "stone_depth", StoneDepthCheck.CODEC);
        }

        public KeyDispatchDataCodec<? extends ConditionSource> codec();
    }

    record YConditionSource(VerticalAnchor anchor, int surfaceDepthMultiplier, boolean addStoneDepth) implements ConditionSource
    {
        static final KeyDispatchDataCodec<YConditionSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(p_189455_ -> p_189455_.group((App)VerticalAnchor.CODEC.fieldOf("anchor").forGetter(YConditionSource::anchor), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(YConditionSource::surfaceDepthMultiplier), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(YConditionSource::addStoneDepth)).apply((Applicative)p_189455_, YConditionSource::new)));

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(final Context p_189457_) {
            class YCondition
            extends LazyYCondition {
                YCondition() {
                    super(context);
                }

                @Override
                protected boolean compute() {
                    return this.context.blockY + (YConditionSource.this.addStoneDepth ? this.context.stoneDepthAbove : 0) >= YConditionSource.this.anchor.resolveY(this.context.context) + this.context.surfaceDepth * YConditionSource.this.surfaceDepthMultiplier;
                }
            }
            return new YCondition();
        }
    }

    record WaterConditionSource(int offset, int surfaceDepthMultiplier, boolean addStoneDepth) implements ConditionSource
    {
        static final KeyDispatchDataCodec<WaterConditionSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(p_189874_ -> p_189874_.group((App)Codec.INT.fieldOf("offset").forGetter(WaterConditionSource::offset), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(WaterConditionSource::surfaceDepthMultiplier), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(WaterConditionSource::addStoneDepth)).apply((Applicative)p_189874_, WaterConditionSource::new)));

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(final Context p_189876_) {
            class WaterCondition
            extends LazyYCondition {
                WaterCondition() {
                    super(context);
                }

                @Override
                protected boolean compute() {
                    return this.context.waterHeight == Integer.MIN_VALUE || this.context.blockY + (WaterConditionSource.this.addStoneDepth ? this.context.stoneDepthAbove : 0) >= this.context.waterHeight + WaterConditionSource.this.offset + this.context.surfaceDepth * WaterConditionSource.this.surfaceDepthMultiplier;
                }
            }
            return new WaterCondition();
        }
    }

    static final class BiomeConditionSource
    implements ConditionSource {
        static final KeyDispatchDataCodec<BiomeConditionSource> CODEC = KeyDispatchDataCodec.of(ResourceKey.codec(Registries.BIOME).listOf().fieldOf("biome_is").xmap(SurfaceRules::isBiome, p_204620_ -> p_204620_.biomes));
        private final List<ResourceKey<Biome>> biomes;
        final Predicate<ResourceKey<Biome>> biomeNameTest;

        BiomeConditionSource(List<ResourceKey<Biome>> p_189493_) {
            this.biomes = p_189493_;
            this.biomeNameTest = Set.copyOf(p_189493_)::contains;
        }

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(final Context p_189496_) {
            class BiomeCondition
            extends LazyYCondition {
                BiomeCondition() {
                    super(context);
                }

                @Override
                protected boolean compute() {
                    return this.context.biome.get().is(BiomeConditionSource.this.biomeNameTest);
                }
            }
            return new BiomeCondition();
        }

        public boolean equals(Object p_209694_) {
            boolean bl;
            if (this == p_209694_) {
                return true;
            }
            if (p_209694_ instanceof BiomeConditionSource) {
                BiomeConditionSource surfacerules$biomeconditionsource = (BiomeConditionSource)p_209694_;
                bl = this.biomes.equals(surfacerules$biomeconditionsource.biomes);
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.biomes.hashCode();
        }

        public String toString() {
            return "BiomeConditionSource[biomes=" + String.valueOf(this.biomes) + "]";
        }
    }

    record NoiseThresholdConditionSource(ResourceKey<NormalNoise.NoiseParameters> noise, double minThreshold, double maxThreshold) implements ConditionSource
    {
        static final KeyDispatchDataCodec<NoiseThresholdConditionSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(p_258995_ -> p_258995_.group((App)ResourceKey.codec(Registries.NOISE).fieldOf("noise").forGetter(NoiseThresholdConditionSource::noise), (App)Codec.DOUBLE.fieldOf("min_threshold").forGetter(NoiseThresholdConditionSource::minThreshold), (App)Codec.DOUBLE.fieldOf("max_threshold").forGetter(NoiseThresholdConditionSource::maxThreshold)).apply((Applicative)p_258995_, NoiseThresholdConditionSource::new)));

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(final Context p_189640_) {
            final NormalNoise normalnoise = p_189640_.randomState.getOrCreateNoise(this.noise);
            class NoiseThresholdCondition
            extends LazyXZCondition {
                NoiseThresholdCondition() {
                    super(context);
                }

                @Override
                protected boolean compute() {
                    double d0 = normalnoise.getValue(this.context.blockX, 0.0, this.context.blockZ);
                    return d0 >= NoiseThresholdConditionSource.this.minThreshold && d0 <= NoiseThresholdConditionSource.this.maxThreshold;
                }
            }
            return new NoiseThresholdCondition();
        }
    }

    record VerticalGradientConditionSource(ResourceLocation randomName, VerticalAnchor trueAtAndBelow, VerticalAnchor falseAtAndAbove) implements ConditionSource
    {
        static final KeyDispatchDataCodec<VerticalGradientConditionSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(p_189839_ -> p_189839_.group((App)ResourceLocation.CODEC.fieldOf("random_name").forGetter(VerticalGradientConditionSource::randomName), (App)VerticalAnchor.CODEC.fieldOf("true_at_and_below").forGetter(VerticalGradientConditionSource::trueAtAndBelow), (App)VerticalAnchor.CODEC.fieldOf("false_at_and_above").forGetter(VerticalGradientConditionSource::falseAtAndAbove)).apply((Applicative)p_189839_, VerticalGradientConditionSource::new)));

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(final Context p_189841_) {
            final int i = this.trueAtAndBelow().resolveY(p_189841_.context);
            final int j = this.falseAtAndAbove().resolveY(p_189841_.context);
            final PositionalRandomFactory positionalrandomfactory = p_189841_.randomState.getOrCreateRandomFactory(this.randomName());
            class VerticalGradientCondition
            extends LazyYCondition {
                VerticalGradientCondition() {
                    super(context);
                }

                @Override
                protected boolean compute() {
                    int k = this.context.blockY;
                    if (k <= i) {
                        return true;
                    }
                    if (k >= j) {
                        return false;
                    }
                    double d0 = Mth.map((double)k, (double)i, (double)j, 1.0, 0.0);
                    RandomSource randomsource = positionalrandomfactory.at(this.context.blockX, k, this.context.blockZ);
                    return (double)randomsource.nextFloat() < d0;
                }
            }
            return new VerticalGradientCondition();
        }
    }

    static enum Steep implements ConditionSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<Steep> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context p_189733_) {
            return p_189733_.steep;
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    static enum Hole implements ConditionSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<Hole> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context p_189608_) {
            return p_189608_.hole;
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    static enum AbovePreliminarySurface implements ConditionSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<AbovePreliminarySurface> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context p_189437_) {
            return p_189437_.abovePreliminarySurface;
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    static enum Temperature implements ConditionSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<Temperature> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context p_189786_) {
            return p_189786_.temperature;
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    record TestRuleSource(ConditionSource ifTrue, RuleSource thenRun) implements RuleSource
    {
        static final KeyDispatchDataCodec<TestRuleSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(p_189817_ -> p_189817_.group((App)ConditionSource.CODEC.fieldOf("if_true").forGetter(TestRuleSource::ifTrue), (App)RuleSource.CODEC.fieldOf("then_run").forGetter(TestRuleSource::thenRun)).apply((Applicative)p_189817_, TestRuleSource::new)));

        @Override
        public KeyDispatchDataCodec<? extends RuleSource> codec() {
            return CODEC;
        }

        @Override
        public SurfaceRule apply(Context p_189819_) {
            return new TestRule((Condition)this.ifTrue.apply(p_189819_), (SurfaceRule)this.thenRun.apply(p_189819_));
        }
    }

    public static interface RuleSource
    extends Function<Context, SurfaceRule> {
        public static final Codec<RuleSource> CODEC = BuiltInRegistries.MATERIAL_RULE.byNameCodec().dispatch(p_338095_ -> p_338095_.codec().codec(), Function.identity());

        public static MapCodec<? extends RuleSource> bootstrap(Registry<MapCodec<? extends RuleSource>> p_204631_) {
            SurfaceRules.register(p_204631_, "bandlands", Bandlands.CODEC);
            SurfaceRules.register(p_204631_, "block", BlockRuleSource.CODEC);
            SurfaceRules.register(p_204631_, "sequence", SequenceRuleSource.CODEC);
            return SurfaceRules.register(p_204631_, "condition", TestRuleSource.CODEC);
        }

        public KeyDispatchDataCodec<? extends RuleSource> codec();
    }

    record SequenceRuleSource(List<RuleSource> sequence) implements RuleSource
    {
        static final KeyDispatchDataCodec<SequenceRuleSource> CODEC = KeyDispatchDataCodec.of(RuleSource.CODEC.listOf().xmap(SequenceRuleSource::new, SequenceRuleSource::sequence).fieldOf("sequence"));

        @Override
        public KeyDispatchDataCodec<? extends RuleSource> codec() {
            return CODEC;
        }

        @Override
        public SurfaceRule apply(Context p_189704_) {
            if (this.sequence.size() == 1) {
                return (SurfaceRule)this.sequence.get(0).apply(p_189704_);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RuleSource surfacerules$rulesource : this.sequence) {
                builder.add((Object)((SurfaceRule)surfacerules$rulesource.apply(p_189704_)));
            }
            return new SequenceRule((List<SurfaceRule>)builder.build());
        }
    }

    record BlockRuleSource(BlockState resultState, StateRule rule) implements RuleSource
    {
        static final KeyDispatchDataCodec<BlockRuleSource> CODEC = KeyDispatchDataCodec.of(BlockState.CODEC.xmap(BlockRuleSource::new, BlockRuleSource::resultState).fieldOf("result_state"));

        BlockRuleSource(BlockState p_189517_) {
            this(p_189517_, new StateRule(p_189517_));
        }

        @Override
        public KeyDispatchDataCodec<? extends RuleSource> codec() {
            return CODEC;
        }

        @Override
        public SurfaceRule apply(Context p_189523_) {
            return this.rule;
        }
    }

    static enum Bandlands implements RuleSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<Bandlands> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends RuleSource> codec() {
            return CODEC;
        }

        @Override
        public SurfaceRule apply(Context p_189482_) {
            return p_189482_.system::getBand;
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    record TestRule(Condition condition, SurfaceRule followup) implements SurfaceRule
    {
        @Override
        @Nullable
        public BlockState tryApply(int p_189805_, int p_189806_, int p_189807_) {
            return !this.condition.test() ? null : this.followup.tryApply(p_189805_, p_189806_, p_189807_);
        }
    }

    protected static interface SurfaceRule {
        @Nullable
        public BlockState tryApply(int var1, int var2, int var3);
    }

    record StateRule(BlockState state) implements SurfaceRule
    {
        @Override
        public BlockState tryApply(int p_189721_, int p_189722_, int p_189723_) {
            return this.state;
        }
    }

    record SequenceRule(List<SurfaceRule> rules) implements SurfaceRule
    {
        @Override
        @Nullable
        public BlockState tryApply(int p_189694_, int p_189695_, int p_189696_) {
            for (SurfaceRule surfacerules$surfacerule : this.rules) {
                BlockState blockstate = surfacerules$surfacerule.tryApply(p_189694_, p_189695_, p_189696_);
                if (blockstate == null) continue;
                return blockstate;
            }
            return null;
        }
    }

    record NotCondition(Condition target) implements Condition
    {
        @Override
        public boolean test() {
            return !this.target.test();
        }
    }

    static abstract class LazyYCondition
    extends LazyCondition {
        protected LazyYCondition(Context p_189625_) {
            super(p_189625_);
        }

        @Override
        protected long getContextLastUpdate() {
            return this.context.lastUpdateY;
        }
    }

    static abstract class LazyXZCondition
    extends LazyCondition {
        protected LazyXZCondition(Context p_189622_) {
            super(p_189622_);
        }

        @Override
        protected long getContextLastUpdate() {
            return this.context.lastUpdateXZ;
        }
    }

    static abstract class LazyCondition
    implements Condition {
        protected final Context context;
        private long lastUpdate;
        @Nullable
        Boolean result;

        protected LazyCondition(Context p_189619_) {
            this.context = p_189619_;
            this.lastUpdate = this.getContextLastUpdate() - 1L;
        }

        @Override
        public boolean test() {
            long i = this.getContextLastUpdate();
            if (i == this.lastUpdate) {
                if (this.result == null) {
                    throw new IllegalStateException("Update triggered but the result is null");
                }
                return this.result;
            }
            this.lastUpdate = i;
            this.result = this.compute();
            return this.result;
        }

        protected abstract long getContextLastUpdate();

        protected abstract boolean compute();
    }

    protected static final class Context {
        private static final int HOW_FAR_BELOW_PRELIMINARY_SURFACE_LEVEL_TO_BUILD_SURFACE = 8;
        private static final int SURFACE_CELL_BITS = 4;
        private static final int SURFACE_CELL_SIZE = 16;
        private static final int SURFACE_CELL_MASK = 15;
        final SurfaceSystem system;
        final Condition temperature = new TemperatureHelperCondition(this);
        final Condition steep = new SteepMaterialCondition(this);
        final Condition hole = new HoleCondition(this);
        final Condition abovePreliminarySurface = new AbovePreliminarySurfaceCondition();
        final RandomState randomState;
        final ChunkAccess chunk;
        private final NoiseChunk noiseChunk;
        private final Function<BlockPos, Holder<Biome>> biomeGetter;
        final WorldGenerationContext context;
        private long lastPreliminarySurfaceCellOrigin = Long.MAX_VALUE;
        private final int[] preliminarySurfaceCache = new int[4];
        long lastUpdateXZ = -9223372036854775807L;
        int blockX;
        int blockZ;
        int surfaceDepth;
        private long lastSurfaceDepth2Update = this.lastUpdateXZ - 1L;
        private double surfaceSecondary;
        private long lastMinSurfaceLevelUpdate = this.lastUpdateXZ - 1L;
        private int minSurfaceLevel;
        long lastUpdateY = -9223372036854775807L;
        final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Supplier<Holder<Biome>> biome;
        int blockY;
        int waterHeight;
        int stoneDepthBelow;
        int stoneDepthAbove;

        protected Context(SurfaceSystem p_224616_, RandomState p_224617_, ChunkAccess p_224618_, NoiseChunk p_224619_, Function<BlockPos, Holder<Biome>> p_224620_, Registry<Biome> p_224621_, WorldGenerationContext p_224622_) {
            this.system = p_224616_;
            this.randomState = p_224617_;
            this.chunk = p_224618_;
            this.noiseChunk = p_224619_;
            this.biomeGetter = p_224620_;
            this.context = p_224622_;
        }

        protected void updateXZ(int p_189570_, int p_189571_) {
            ++this.lastUpdateXZ;
            ++this.lastUpdateY;
            this.blockX = p_189570_;
            this.blockZ = p_189571_;
            this.surfaceDepth = this.system.getSurfaceDepth(p_189570_, p_189571_);
        }

        protected void updateY(int p_189577_, int p_189578_, int p_189579_, int p_189580_, int p_189581_, int p_189582_) {
            ++this.lastUpdateY;
            this.biome = Suppliers.memoize(() -> this.biomeGetter.apply(this.pos.set(p_189580_, p_189581_, p_189582_)));
            this.blockY = p_189581_;
            this.waterHeight = p_189579_;
            this.stoneDepthBelow = p_189578_;
            this.stoneDepthAbove = p_189577_;
        }

        protected double getSurfaceSecondary() {
            if (this.lastSurfaceDepth2Update != this.lastUpdateXZ) {
                this.lastSurfaceDepth2Update = this.lastUpdateXZ;
                this.surfaceSecondary = this.system.getSurfaceSecondary(this.blockX, this.blockZ);
            }
            return this.surfaceSecondary;
        }

        public int getSeaLevel() {
            return this.system.getSeaLevel();
        }

        private static int blockCoordToSurfaceCell(int p_198281_) {
            return p_198281_ >> 4;
        }

        private static int surfaceCellToBlockCoord(int p_198283_) {
            return p_198283_ << 4;
        }

        protected int getMinSurfaceLevel() {
            if (this.lastMinSurfaceLevelUpdate != this.lastUpdateXZ) {
                int j;
                this.lastMinSurfaceLevelUpdate = this.lastUpdateXZ;
                int i = Context.blockCoordToSurfaceCell(this.blockX);
                long k = ChunkPos.asLong(i, j = Context.blockCoordToSurfaceCell(this.blockZ));
                if (this.lastPreliminarySurfaceCellOrigin != k) {
                    this.lastPreliminarySurfaceCellOrigin = k;
                    this.preliminarySurfaceCache[0] = this.noiseChunk.preliminarySurfaceLevel(Context.surfaceCellToBlockCoord(i), Context.surfaceCellToBlockCoord(j));
                    this.preliminarySurfaceCache[1] = this.noiseChunk.preliminarySurfaceLevel(Context.surfaceCellToBlockCoord(i + 1), Context.surfaceCellToBlockCoord(j));
                    this.preliminarySurfaceCache[2] = this.noiseChunk.preliminarySurfaceLevel(Context.surfaceCellToBlockCoord(i), Context.surfaceCellToBlockCoord(j + 1));
                    this.preliminarySurfaceCache[3] = this.noiseChunk.preliminarySurfaceLevel(Context.surfaceCellToBlockCoord(i + 1), Context.surfaceCellToBlockCoord(j + 1));
                }
                int l = Mth.floor(Mth.lerp2((float)(this.blockX & 0xF) / 16.0f, (float)(this.blockZ & 0xF) / 16.0f, this.preliminarySurfaceCache[0], this.preliminarySurfaceCache[1], this.preliminarySurfaceCache[2], this.preliminarySurfaceCache[3]));
                this.minSurfaceLevel = l + this.surfaceDepth - 8;
            }
            return this.minSurfaceLevel;
        }

        static class TemperatureHelperCondition
        extends LazyYCondition {
            TemperatureHelperCondition(Context p_189597_) {
                super(p_189597_);
            }

            @Override
            protected boolean compute() {
                return this.context.biome.get().value().coldEnoughToSnow(this.context.pos.set(this.context.blockX, this.context.blockY, this.context.blockZ), this.context.getSeaLevel());
            }
        }

        static class SteepMaterialCondition
        extends LazyXZCondition {
            SteepMaterialCondition(Context p_189594_) {
                super(p_189594_);
            }

            @Override
            protected boolean compute() {
                int j2;
                int i = this.context.blockX & 0xF;
                int j = this.context.blockZ & 0xF;
                int k = Math.max(j - 1, 0);
                int l = Math.min(j + 1, 15);
                ChunkAccess chunkaccess = this.context.chunk;
                int i1 = chunkaccess.getHeight(Heightmap.Types.WORLD_SURFACE_WG, i, k);
                int j1 = chunkaccess.getHeight(Heightmap.Types.WORLD_SURFACE_WG, i, l);
                if (j1 >= i1 + 4) {
                    return true;
                }
                int k1 = Math.max(i - 1, 0);
                int l1 = Math.min(i + 1, 15);
                int i2 = chunkaccess.getHeight(Heightmap.Types.WORLD_SURFACE_WG, k1, j);
                return i2 >= (j2 = chunkaccess.getHeight(Heightmap.Types.WORLD_SURFACE_WG, l1, j)) + 4;
            }
        }

        static final class HoleCondition
        extends LazyXZCondition {
            HoleCondition(Context p_189591_) {
                super(p_189591_);
            }

            @Override
            protected boolean compute() {
                return this.context.surfaceDepth <= 0;
            }
        }

        final class AbovePreliminarySurfaceCondition
        implements Condition {
            AbovePreliminarySurfaceCondition() {
            }

            @Override
            public boolean test() {
                return Context.this.blockY >= Context.this.getMinSurfaceLevel();
            }
        }
    }

    static interface Condition {
        public boolean test();
    }
}

