/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Longs;
import java.util.concurrent.atomic.AtomicLong;

public final class RandomSupport {
    public static final long GOLDEN_RATIO_64 = -7046029254386353131L;
    public static final long SILVER_RATIO_64 = 7640891576956012809L;
    private static final HashFunction MD5_128 = Hashing.md5();
    private static final AtomicLong SEED_UNIQUIFIER = new AtomicLong(8682522807148012L);

    @VisibleForTesting
    public static long mixStafford13(long p_189330_) {
        p_189330_ = (p_189330_ ^ p_189330_ >>> 30) * -4658895280553007687L;
        p_189330_ = (p_189330_ ^ p_189330_ >>> 27) * -7723592293110705685L;
        return p_189330_ ^ p_189330_ >>> 31;
    }

    public static Seed128bit upgradeSeedTo128bitUnmixed(long p_289660_) {
        long i = p_289660_ ^ 0x6A09E667F3BCC909L;
        long j = i + -7046029254386353131L;
        return new Seed128bit(i, j);
    }

    public static Seed128bit upgradeSeedTo128bit(long p_189332_) {
        return RandomSupport.upgradeSeedTo128bitUnmixed(p_189332_).mixed();
    }

    public static Seed128bit seedFromHashOf(String p_288994_) {
        byte[] abyte = MD5_128.hashString((CharSequence)p_288994_, Charsets.UTF_8).asBytes();
        long i = Longs.fromBytes((byte)abyte[0], (byte)abyte[1], (byte)abyte[2], (byte)abyte[3], (byte)abyte[4], (byte)abyte[5], (byte)abyte[6], (byte)abyte[7]);
        long j = Longs.fromBytes((byte)abyte[8], (byte)abyte[9], (byte)abyte[10], (byte)abyte[11], (byte)abyte[12], (byte)abyte[13], (byte)abyte[14], (byte)abyte[15]);
        return new Seed128bit(i, j);
    }

    public static long generateUniqueSeed() {
        return SEED_UNIQUIFIER.updateAndGet(p_224601_ -> p_224601_ * 1181783497276652981L) ^ System.nanoTime();
    }

    public record Seed128bit(long seedLo, long seedHi) {
        public Seed128bit xor(long p_288963_, long p_288992_) {
            return new Seed128bit(this.seedLo ^ p_288963_, this.seedHi ^ p_288992_);
        }

        public Seed128bit xor(Seed128bit p_289009_) {
            return this.xor(p_289009_.seedLo, p_289009_.seedHi);
        }

        public Seed128bit mixed() {
            return new Seed128bit(RandomSupport.mixStafford13(this.seedLo), RandomSupport.mixStafford13(this.seedHi));
        }
    }
}

