/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerSpawnPhantomsEvent;

public class PhantomSpawner
implements CustomSpawner {
    private int nextTick;

    @Override
    public void tick(ServerLevel p_64576_, boolean p_64577_, boolean p_64578_) {
        if (p_64577_ && p_64576_.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA)) {
            RandomSource randomsource = p_64576_.random;
            --this.nextTick;
            if (this.nextTick <= 0) {
                this.nextTick += (60 + randomsource.nextInt(60)) * 20;
                if (p_64576_.getSkyDarken() >= 5 || !p_64576_.dimensionType().hasSkyLight()) {
                    for (ServerPlayer serverplayer : p_64576_.players()) {
                        FluidState fluidstate;
                        BlockState blockstate;
                        BlockPos blockpos1;
                        boolean isAllow;
                        if (serverplayer.isSpectator()) continue;
                        BlockPos blockpos = serverplayer.blockPosition();
                        PlayerSpawnPhantomsEvent event = EventHooks.firePlayerSpawnPhantoms((ServerPlayer)serverplayer, (ServerLevel)p_64576_, (BlockPos)blockpos);
                        boolean bl = isAllow = event.getResult() == PlayerSpawnPhantomsEvent.Result.ALLOW;
                        if (!event.shouldSpawnPhantoms(p_64576_, blockpos)) continue;
                        DifficultyInstance difficultyinstance = p_64576_.getCurrentDifficultyAt(blockpos);
                        if (!isAllow && !difficultyinstance.isHarderThan(randomsource.nextFloat() * 3.0f)) continue;
                        ServerStatsCounter serverstatscounter = serverplayer.getStats();
                        int i = Mth.clamp(serverstatscounter.getValue(Stats.CUSTOM.get(Stats.TIME_SINCE_REST)), 1, Integer.MAX_VALUE);
                        int j = 24000;
                        if (!isAllow && randomsource.nextInt(i) < 72000 || !NaturalSpawner.isValidEmptySpawnBlock(p_64576_, blockpos1 = blockpos.above(20 + randomsource.nextInt(15)).east(-10 + randomsource.nextInt(21)).south(-10 + randomsource.nextInt(21)), blockstate = p_64576_.getBlockState(blockpos1), fluidstate = p_64576_.getFluidState(blockpos1), EntityType.PHANTOM)) continue;
                        SpawnGroupData spawngroupdata = null;
                        int k = event.getPhantomsToSpawn();
                        for (int l = 0; l < k; ++l) {
                            Phantom phantom = EntityType.PHANTOM.create(p_64576_, EntitySpawnReason.NATURAL);
                            if (phantom == null) continue;
                            phantom.snapTo(blockpos1, 0.0f, 0.0f);
                            spawngroupdata = phantom.finalizeSpawn(p_64576_, difficultyinstance, EntitySpawnReason.NATURAL, spawngroupdata);
                            p_64576_.addFreshEntityWithPassengers(phantom);
                        }
                    }
                }
            }
        }
    }
}

