/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.PriorityConsecutiveExecutor;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final PriorityConsecutiveExecutor consecutiveExecutor;
    private final RegionFileStorage storage;
    private final SequencedMap<ChunkPos, PendingStore> pendingWrites = new LinkedHashMap<ChunkPos, PendingStore>();
    private final Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> regionCacheForBlender = new Long2ObjectLinkedOpenHashMap();
    private static final int REGION_CACHE_SIZE = 1024;

    protected IOWorker(RegionStorageInfo p_325953_, Path p_196930_, boolean p_196931_) {
        this.storage = new RegionFileStorage(p_325953_, p_196930_, p_196931_);
        this.consecutiveExecutor = new PriorityConsecutiveExecutor(Priority.values().length, (Executor)Util.ioPool(), "IOWorker-" + p_325953_.type());
    }

    public boolean isOldChunkAround(ChunkPos p_223472_, int p_223473_) {
        ChunkPos chunkpos = new ChunkPos(p_223472_.x - p_223473_, p_223472_.z - p_223473_);
        ChunkPos chunkpos1 = new ChunkPos(p_223472_.x + p_223473_, p_223472_.z + p_223473_);
        for (int i = chunkpos.getRegionX(); i <= chunkpos1.getRegionX(); ++i) {
            for (int j = chunkpos.getRegionZ(); j <= chunkpos1.getRegionZ(); ++j) {
                BitSet bitset = this.getOrCreateOldDataForRegion(i, j).join();
                if (bitset.isEmpty()) continue;
                ChunkPos chunkpos2 = ChunkPos.minFromRegion(i, j);
                int k = Math.max(chunkpos.x - chunkpos2.x, 0);
                int l = Math.max(chunkpos.z - chunkpos2.z, 0);
                int i1 = Math.min(chunkpos1.x - chunkpos2.x, 31);
                int j1 = Math.min(chunkpos1.z - chunkpos2.z, 31);
                for (int k1 = k; k1 <= i1; ++k1) {
                    for (int l1 = l; l1 <= j1; ++l1) {
                        int i2 = l1 * 32 + k1;
                        if (!bitset.get(i2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<BitSet> getOrCreateOldDataForRegion(int p_223464_, int p_223465_) {
        long i = ChunkPos.asLong(p_223464_, p_223465_);
        Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> long2ObjectLinkedOpenHashMap = this.regionCacheForBlender;
        synchronized (long2ObjectLinkedOpenHashMap) {
            CompletableFuture<BitSet> completablefuture = (CompletableFuture<BitSet>)this.regionCacheForBlender.getAndMoveToFirst(i);
            if (completablefuture == null) {
                completablefuture = this.createOldDataForRegion(p_223464_, p_223465_);
                this.regionCacheForBlender.putAndMoveToFirst(i, completablefuture);
                if (this.regionCacheForBlender.size() > 1024) {
                    this.regionCacheForBlender.removeLast();
                }
            }
            return completablefuture;
        }
    }

    private CompletableFuture<BitSet> createOldDataForRegion(int p_223490_, int p_223491_) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkPos chunkpos = ChunkPos.minFromRegion(p_223490_, p_223491_);
            ChunkPos chunkpos1 = ChunkPos.maxFromRegion(p_223490_, p_223491_);
            BitSet bitset = new BitSet();
            ChunkPos.rangeClosed(chunkpos, chunkpos1).forEach(p_223480_ -> {
                CompoundTag compoundtag;
                CollectFields collectfields = new CollectFields(new FieldSelector(IntTag.TYPE, "DataVersion"), new FieldSelector(CompoundTag.TYPE, "blending_data"));
                try {
                    this.scanChunk((ChunkPos)p_223480_, collectfields).join();
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to scan chunk {}", p_223480_, (Object)exception);
                    return;
                }
                Tag patt0$temp = collectfields.getResult();
                if (patt0$temp instanceof CompoundTag && this.isOldChunk(compoundtag = (CompoundTag)patt0$temp)) {
                    int i = p_223480_.getRegionLocalZ() * 32 + p_223480_.getRegionLocalX();
                    bitset.set(i);
                }
            });
            return bitset;
        }, Util.backgroundExecutor());
    }

    private boolean isOldChunk(CompoundTag p_223485_) {
        return p_223485_.getIntOr("DataVersion", 0) < 4295 ? true : p_223485_.getCompound("blending_data").isPresent();
    }

    public CompletableFuture<Void> store(ChunkPos p_63539_, @Nullable CompoundTag p_63540_) {
        return this.store(p_63539_, () -> p_63540_);
    }

    public CompletableFuture<Void> store(ChunkPos p_360728_, Supplier<CompoundTag> p_361805_) {
        return this.submitTask(() -> {
            CompoundTag compoundtag = (CompoundTag)p_361805_.get();
            PendingStore ioworker$pendingstore = this.pendingWrites.computeIfAbsent(p_360728_, p_223488_ -> new PendingStore(compoundtag));
            ioworker$pendingstore.data = compoundtag;
            return ioworker$pendingstore.result;
        }).thenCompose(Function.identity());
    }

    public CompletableFuture<Optional<CompoundTag>> loadAsync(ChunkPos p_156588_) {
        return this.submitThrowingTask(() -> {
            PendingStore ioworker$pendingstore = (PendingStore)this.pendingWrites.get(p_156588_);
            if (ioworker$pendingstore != null) {
                return Optional.ofNullable(ioworker$pendingstore.copyData());
            }
            try {
                CompoundTag compoundtag = this.storage.read(p_156588_);
                return Optional.ofNullable(compoundtag);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to read chunk {}", (Object)p_156588_, (Object)exception);
                throw exception;
            }
        });
    }

    public CompletableFuture<Void> synchronize(boolean p_182499_) {
        CompletionStage completablefuture = this.submitTask(() -> CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(p_223475_ -> p_223475_.result).toArray(CompletableFuture[]::new))).thenCompose(Function.identity());
        return p_182499_ ? ((CompletableFuture)completablefuture).thenCompose(p_371174_ -> this.submitThrowingTask(() -> {
            try {
                this.storage.flush();
                return null;
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to synchronize chunks", (Throwable)exception);
                throw exception;
            }
        })) : ((CompletableFuture)completablefuture).thenCompose(p_223477_ -> this.submitTask(() -> null));
    }

    @Override
    public CompletableFuture<Void> scanChunk(ChunkPos p_196939_, StreamTagVisitor p_196940_) {
        return this.submitThrowingTask(() -> {
            try {
                PendingStore ioworker$pendingstore = (PendingStore)this.pendingWrites.get(p_196939_);
                if (ioworker$pendingstore != null) {
                    if (ioworker$pendingstore.data != null) {
                        ioworker$pendingstore.data.acceptAsRoot(p_196940_);
                    }
                } else {
                    this.storage.scanChunk(p_196939_, p_196940_);
                }
                return null;
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to bulk scan chunk {}", (Object)p_196939_, (Object)exception);
                throw exception;
            }
        });
    }

    private <T> CompletableFuture<T> submitThrowingTask(ThrowingSupplier<T> p_371938_) {
        return this.consecutiveExecutor.scheduleWithResult(Priority.FOREGROUND.ordinal(), p_371168_ -> {
            if (!this.shutdownRequested.get()) {
                try {
                    p_371168_.complete(p_371938_.get());
                }
                catch (Exception exception) {
                    p_371168_.completeExceptionally(exception);
                }
            }
            this.tellStorePending();
        });
    }

    private <T> CompletableFuture<T> submitTask(Supplier<T> p_63546_) {
        return this.consecutiveExecutor.scheduleWithResult(Priority.FOREGROUND.ordinal(), p_371173_ -> {
            if (!this.shutdownRequested.get()) {
                p_371173_.complete(p_63546_.get());
            }
            this.tellStorePending();
        });
    }

    private void storePendingChunk() {
        Map.Entry<ChunkPos, PendingStore> entry = this.pendingWrites.pollFirstEntry();
        if (entry != null) {
            this.runStore(entry.getKey(), entry.getValue());
            this.tellStorePending();
        }
    }

    private void tellStorePending() {
        this.consecutiveExecutor.schedule(new StrictQueue.RunnableWithPriority(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(ChunkPos p_63536_, PendingStore p_63537_) {
        try {
            this.storage.write(p_63536_, p_63537_.data);
            p_63537_.result.complete(null);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to store chunk {}", (Object)p_63536_, (Object)exception);
            p_63537_.result.completeExceptionally(exception);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.shutdownRequested.compareAndSet(false, true)) {
            this.waitForShutdown();
            this.consecutiveExecutor.close();
            try {
                this.storage.close();
            }
            catch (Exception exception) {
                LOGGER.error("Failed to close storage", (Throwable)exception);
            }
        }
    }

    private void waitForShutdown() {
        this.consecutiveExecutor.scheduleWithResult(Priority.SHUTDOWN.ordinal(), p_371169_ -> p_371169_.complete(Unit.INSTANCE)).join();
    }

    public RegionStorageInfo storageInfo() {
        return this.storage.info();
    }

    static enum Priority {
        FOREGROUND,
        BACKGROUND,
        SHUTDOWN;

    }

    @FunctionalInterface
    static interface ThrowingSupplier<T> {
        @Nullable
        public T get() throws Exception;
    }

    static class PendingStore {
        @Nullable
        CompoundTag data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public PendingStore(@Nullable CompoundTag p_63568_) {
            this.data = p_63568_;
        }

        @Nullable
        CompoundTag copyData() {
            CompoundTag compoundtag = this.data;
            return compoundtag == null ? null : compoundtag.copy();
        }
    }
}

