/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.Property;

public final class EnumProperty<T extends Enum<T>>
extends Property<T> {
    private final List<T> values;
    private final Map<String, T> names;
    private final int[] ordinalToIndex;

    private EnumProperty(String p_61579_, Class<T> p_61580_, List<T> p_372820_) {
        super(p_61579_, p_61580_);
        if (p_372820_.isEmpty()) {
            throw new IllegalArgumentException("Trying to make empty EnumProperty '" + p_61579_ + "'");
        }
        this.values = List.copyOf(p_372820_);
        Enum[] at = (Enum[])p_61580_.getEnumConstants();
        this.ordinalToIndex = new int[at.length];
        for (Enum t : at) {
            this.ordinalToIndex[t.ordinal()] = p_372820_.indexOf(t);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Enum t1 : p_372820_) {
            String s = ((StringRepresentable)((Object)t1)).getSerializedName();
            builder.put((Object)s, (Object)t1);
        }
        this.names = builder.buildOrThrow();
    }

    @Override
    public List<T> getPossibleValues() {
        return this.values;
    }

    @Override
    public Optional<T> getValue(String p_61604_) {
        return Optional.ofNullable((Enum)this.names.get(p_61604_));
    }

    @Override
    public String getName(T p_61586_) {
        return ((StringRepresentable)p_61586_).getSerializedName();
    }

    @Override
    public int getInternalIndex(T p_373052_) {
        return this.ordinalToIndex[((Enum)p_373052_).ordinal()];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object p_61606_) {
        if (this == p_61606_) {
            return true;
        }
        if (!(p_61606_ instanceof EnumProperty)) return false;
        EnumProperty enumproperty = (EnumProperty)p_61606_;
        if (!super.equals(p_61606_)) return false;
        boolean bl = this.values.equals(enumproperty.values);
        return bl;
    }

    @Override
    public int generateHashCode() {
        int i = super.generateHashCode();
        return 31 * i + this.values.hashCode();
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String p_61588_, Class<T> p_61589_) {
        return EnumProperty.create(p_61588_, p_61589_, (T p_187560_) -> true);
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String p_61595_, Class<T> p_61596_, Predicate<T> p_61597_) {
        return EnumProperty.create(p_61595_, p_61596_, Arrays.stream((Enum[])p_61596_.getEnumConstants()).filter(p_61597_).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumProperty<T> create(String p_61599_, Class<T> p_61600_, T ... p_61601_) {
        return EnumProperty.create(p_61599_, p_61600_, List.of(p_61601_));
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String p_61591_, Class<T> p_61592_, List<T> p_372944_) {
        return new EnumProperty<T>(p_61591_, p_61592_, p_372944_);
    }
}

