/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public enum TrialSpawnerState implements StringRepresentable
{
    INACTIVE("inactive", 0, ParticleEmission.NONE, -1.0, false),
    WAITING_FOR_PLAYERS("waiting_for_players", 4, ParticleEmission.SMALL_FLAMES, 200.0, true),
    ACTIVE("active", 8, ParticleEmission.FLAMES_AND_SMOKE, 1000.0, true),
    WAITING_FOR_REWARD_EJECTION("waiting_for_reward_ejection", 8, ParticleEmission.SMALL_FLAMES, -1.0, false),
    EJECTING_REWARD("ejecting_reward", 8, ParticleEmission.SMALL_FLAMES, -1.0, false),
    COOLDOWN("cooldown", 0, ParticleEmission.SMOKE_INSIDE_AND_TOP_FACE, -1.0, false);

    private static final float DELAY_BEFORE_EJECT_AFTER_KILLING_LAST_MOB = 40.0f;
    private static final int TIME_BETWEEN_EACH_EJECTION;
    private final String name;
    private final int lightLevel;
    private final double spinningMobSpeed;
    private final ParticleEmission particleEmission;
    private final boolean isCapableOfSpawning;

    private TrialSpawnerState(String p_312098_, int p_312873_, ParticleEmission p_312259_, double p_312005_, boolean p_312451_) {
        this.name = p_312098_;
        this.lightLevel = p_312873_;
        this.particleEmission = p_312259_;
        this.spinningMobSpeed = p_312005_;
        this.isCapableOfSpawning = p_312451_;
    }

    TrialSpawnerState tickAndGetNext(BlockPos p_312221_, TrialSpawner p_311912_, ServerLevel p_311974_) {
        TrialSpawnerStateData trialspawnerstatedata = p_311912_.getStateData();
        TrialSpawnerConfig trialspawnerconfig = p_311912_.activeConfig();
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (trialspawnerstatedata.getOrCreateDisplayEntity(p_311912_, p_311974_, WAITING_FOR_PLAYERS) == null) {
                    yield this;
                }
                yield WAITING_FOR_PLAYERS;
            }
            case 1 -> {
                if (!p_311912_.canSpawnInLevel(p_311974_)) {
                    trialspawnerstatedata.resetStatistics();
                    yield this;
                }
                if (!trialspawnerstatedata.hasMobToSpawn(p_311912_, p_311974_.random)) {
                    yield INACTIVE;
                }
                trialspawnerstatedata.tryDetectPlayers(p_311974_, p_312221_, p_311912_);
                if (trialspawnerstatedata.detectedPlayers.isEmpty()) {
                    yield this;
                }
                yield ACTIVE;
            }
            case 2 -> {
                if (!p_311912_.canSpawnInLevel(p_311974_)) {
                    trialspawnerstatedata.resetStatistics();
                    yield WAITING_FOR_PLAYERS;
                }
                if (!trialspawnerstatedata.hasMobToSpawn(p_311912_, p_311974_.random)) {
                    yield INACTIVE;
                }
                int i = trialspawnerstatedata.countAdditionalPlayers(p_312221_);
                trialspawnerstatedata.tryDetectPlayers(p_311974_, p_312221_, p_311912_);
                if (p_311912_.isOminous()) {
                    this.spawnOminousOminousItemSpawner(p_311974_, p_312221_, p_311912_);
                }
                if (trialspawnerstatedata.hasFinishedSpawningAllMobs(trialspawnerconfig, i)) {
                    if (trialspawnerstatedata.haveAllCurrentMobsDied()) {
                        trialspawnerstatedata.cooldownEndsAt = p_311974_.getGameTime() + (long)p_311912_.getTargetCooldownLength();
                        trialspawnerstatedata.totalMobsSpawned = 0;
                        trialspawnerstatedata.nextMobSpawnsAt = 0L;
                        yield WAITING_FOR_REWARD_EJECTION;
                    }
                } else if (trialspawnerstatedata.isReadyToSpawnNextMob(p_311974_, trialspawnerconfig, i)) {
                    p_311912_.spawnMob(p_311974_, p_312221_).ifPresent(p_428185_ -> {
                        trialspawnerstatedata.currentMobs.add((UUID)p_428185_);
                        ++trialspawnerstatedata.totalMobsSpawned;
                        trialspawnerstatedata.nextMobSpawnsAt = p_311974_.getGameTime() + (long)trialspawnerconfig.ticksBetweenSpawn();
                        trialspawnerconfig.spawnPotentialsDefinition().getRandom(p_311974_.getRandom()).ifPresent(p_421425_ -> {
                            trialspawnerstatedata.nextSpawnData = Optional.of(p_421425_);
                            p_311912_.markUpdated();
                        });
                    });
                }
                yield this;
            }
            case 3 -> {
                if (trialspawnerstatedata.isReadyToOpenShutter(p_311974_, 40.0f, p_311912_.getTargetCooldownLength())) {
                    p_311974_.playSound(null, p_312221_, SoundEvents.TRIAL_SPAWNER_OPEN_SHUTTER, SoundSource.BLOCKS);
                    yield EJECTING_REWARD;
                }
                yield this;
            }
            case 4 -> {
                if (!trialspawnerstatedata.isReadyToEjectItems(p_311974_, TIME_BETWEEN_EACH_EJECTION, p_311912_.getTargetCooldownLength())) {
                    yield this;
                }
                if (trialspawnerstatedata.detectedPlayers.isEmpty()) {
                    p_311974_.playSound(null, p_312221_, SoundEvents.TRIAL_SPAWNER_CLOSE_SHUTTER, SoundSource.BLOCKS);
                    trialspawnerstatedata.ejectingLootTable = Optional.empty();
                    yield COOLDOWN;
                }
                if (trialspawnerstatedata.ejectingLootTable.isEmpty()) {
                    trialspawnerstatedata.ejectingLootTable = trialspawnerconfig.lootTablesToEject().getRandom(p_311974_.getRandom());
                }
                trialspawnerstatedata.ejectingLootTable.ifPresent(p_335304_ -> p_311912_.ejectReward(p_311974_, p_312221_, (ResourceKey<LootTable>)p_335304_));
                trialspawnerstatedata.detectedPlayers.remove(trialspawnerstatedata.detectedPlayers.iterator().next());
                yield this;
            }
            case 5 -> {
                trialspawnerstatedata.tryDetectPlayers(p_311974_, p_312221_, p_311912_);
                if (!trialspawnerstatedata.detectedPlayers.isEmpty()) {
                    trialspawnerstatedata.totalMobsSpawned = 0;
                    trialspawnerstatedata.nextMobSpawnsAt = 0L;
                    yield ACTIVE;
                }
                if (trialspawnerstatedata.isCooldownFinished(p_311974_)) {
                    p_311912_.removeOminous(p_311974_, p_312221_);
                    trialspawnerstatedata.reset();
                    yield WAITING_FOR_PLAYERS;
                }
                yield this;
            }
        };
    }

    private void spawnOminousOminousItemSpawner(ServerLevel p_338483_, BlockPos p_338824_, TrialSpawner p_338767_) {
        TrialSpawnerConfig trialspawnerconfig;
        TrialSpawnerStateData trialspawnerstatedata = p_338767_.getStateData();
        ItemStack itemstack = trialspawnerstatedata.getDispensingItems(p_338483_, trialspawnerconfig = p_338767_.activeConfig(), p_338824_).getRandom(p_338483_.random).orElse(ItemStack.EMPTY);
        if (!itemstack.isEmpty() && this.timeToSpawnItemSpawner(p_338483_, trialspawnerstatedata)) {
            TrialSpawnerState.calculatePositionToSpawnSpawner(p_338483_, p_338824_, p_338767_, trialspawnerstatedata).ifPresent(p_338064_ -> {
                OminousItemSpawner ominousitemspawner = OminousItemSpawner.create(p_338483_, itemstack);
                ominousitemspawner.snapTo((Vec3)p_338064_);
                p_338483_.addFreshEntity(ominousitemspawner);
                float f = (p_338483_.getRandom().nextFloat() - p_338483_.getRandom().nextFloat()) * 0.2f + 1.0f;
                p_338483_.playSound(null, BlockPos.containing(p_338064_), SoundEvents.TRIAL_SPAWNER_SPAWN_ITEM_BEGIN, SoundSource.BLOCKS, 1.0f, f);
                trialspawnerstatedata.cooldownEndsAt = p_338483_.getGameTime() + p_338767_.ominousConfig().ticksBetweenItemSpawners();
            });
        }
    }

    private static Optional<Vec3> calculatePositionToSpawnSpawner(ServerLevel p_338436_, BlockPos p_338583_, TrialSpawner p_338226_, TrialSpawnerStateData p_422600_) {
        List<Player> list = p_422600_.detectedPlayers.stream().map(p_338436_::getPlayerByUUID).filter(Objects::nonNull).filter(p_427215_ -> !p_427215_.isCreative() && !p_427215_.isSpectator() && p_427215_.isAlive() && p_427215_.distanceToSqr(p_338583_.getCenter()) <= (double)Mth.square(p_338226_.getRequiredPlayerRange())).toList();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        Entity entity = TrialSpawnerState.selectEntityToSpawnItemAbove(list, p_422600_.currentMobs, p_338226_, p_338583_, p_338436_);
        return entity == null ? Optional.empty() : TrialSpawnerState.calculatePositionAbove(entity, p_338436_);
    }

    private static Optional<Vec3> calculatePositionAbove(Entity p_338791_, ServerLevel p_338807_) {
        Vec3 vec31;
        Vec3 vec3 = p_338791_.position();
        BlockHitResult blockhitresult = p_338807_.clip(new ClipContext(vec3, vec31 = vec3.relative(Direction.UP, p_338791_.getBbHeight() + 2.0f + (float)p_338807_.random.nextInt(4)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        Vec3 vec32 = blockhitresult.getBlockPos().getCenter().relative(Direction.DOWN, 1.0);
        BlockPos blockpos = BlockPos.containing(vec32);
        return !p_338807_.getBlockState(blockpos).getCollisionShape(p_338807_, blockpos).isEmpty() ? Optional.empty() : Optional.of(vec32);
    }

    @Nullable
    private static Entity selectEntityToSpawnItemAbove(List<Player> p_338467_, Set<UUID> p_338224_, TrialSpawner p_338687_, BlockPos p_338268_, ServerLevel p_338524_) {
        List<Entity> list;
        Stream<Entity> stream = p_338224_.stream().map(p_338524_::getEntity).filter(Objects::nonNull).filter(p_338051_ -> p_338051_.isAlive() && p_338051_.distanceToSqr(p_338268_.getCenter()) <= (double)Mth.square(p_338687_.getRequiredPlayerRange()));
        List<Entity> list2 = list = p_338524_.random.nextBoolean() ? stream.toList() : p_338467_;
        if (list.isEmpty()) {
            return null;
        }
        return list.size() == 1 ? list.getFirst() : Util.getRandom(list, p_338524_.random);
    }

    private boolean timeToSpawnItemSpawner(ServerLevel p_338741_, TrialSpawnerStateData p_421817_) {
        return p_338741_.getGameTime() >= p_421817_.cooldownEndsAt;
    }

    public int lightLevel() {
        return this.lightLevel;
    }

    public double spinningMobSpeed() {
        return this.spinningMobSpeed;
    }

    public boolean hasSpinningMob() {
        return this.spinningMobSpeed >= 0.0;
    }

    public boolean isCapableOfSpawning() {
        return this.isCapableOfSpawning;
    }

    public void emitParticles(Level p_312507_, BlockPos p_312610_, boolean p_338615_) {
        this.particleEmission.emit(p_312507_, p_312507_.getRandom(), p_312610_, p_338615_);
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    static {
        TIME_BETWEEN_EACH_EJECTION = Mth.floor(30.0f);
    }

    static interface ParticleEmission {
        public static final ParticleEmission NONE = (p_311998_, p_311983_, p_312351_, p_338371_) -> {};
        public static final ParticleEmission SMALL_FLAMES = (p_338069_, p_338070_, p_338071_, p_338072_) -> {
            if (p_338070_.nextInt(2) == 0) {
                Vec3 vec3 = p_338071_.getCenter().offsetRandom(p_338070_, 0.9f);
                ParticleEmission.addParticle(p_338072_ ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.SMALL_FLAME, vec3, p_338069_);
            }
        };
        public static final ParticleEmission FLAMES_AND_SMOKE = (p_338065_, p_338066_, p_338067_, p_338068_) -> {
            Vec3 vec3 = p_338067_.getCenter().offsetRandom(p_338066_, 1.0f);
            ParticleEmission.addParticle(ParticleTypes.SMOKE, vec3, p_338065_);
            ParticleEmission.addParticle(p_338068_ ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME, vec3, p_338065_);
        };
        public static final ParticleEmission SMOKE_INSIDE_AND_TOP_FACE = (p_311899_, p_311762_, p_312096_, p_338301_) -> {
            Vec3 vec3 = p_312096_.getCenter().offsetRandom(p_311762_, 0.9f);
            if (p_311762_.nextInt(3) == 0) {
                ParticleEmission.addParticle(ParticleTypes.SMOKE, vec3, p_311899_);
            }
            if (p_311899_.getGameTime() % 20L == 0L) {
                Vec3 vec31 = p_312096_.getCenter().add(0.0, 0.5, 0.0);
                int i = p_311899_.getRandom().nextInt(4) + 20;
                for (int j = 0; j < i; ++j) {
                    ParticleEmission.addParticle(ParticleTypes.SMOKE, vec31, p_311899_);
                }
            }
        };

        private static void addParticle(SimpleParticleType p_312519_, Vec3 p_312023_, Level p_311937_) {
            p_311937_.addParticle(p_312519_, p_312023_.x(), p_312023_.y(), p_312023_.z(), 0.0, 0.0, 0.0);
        }

        public void emit(Level var1, RandomSource var2, BlockPos var3, boolean var4);
    }

    static class SpinningMob {
        private static final double NONE = -1.0;
        private static final double SLOW = 200.0;
        private static final double FAST = 1000.0;

        private SpinningMob() {
        }
    }

    static class LightLevel {
        private static final int UNLIT = 0;
        private static final int HALF_LIT = 4;
        private static final int LIT = 8;

        private LightLevel() {
        }
    }
}

