/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class TrialSpawner
implements IOwnedSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final TrialSpawnerStateData data = new TrialSpawnerStateData();
    private FullConfig config;
    private final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    private boolean isOminous;

    public TrialSpawner(FullConfig p_422371_, StateAccessor p_312198_, PlayerDetector p_312690_, PlayerDetector.EntitySelector p_323834_) {
        this.config = p_422371_;
        this.stateAccessor = p_312198_;
        this.playerDetector = p_312690_;
        this.entitySelector = p_323834_;
    }

    public TrialSpawnerConfig activeConfig() {
        return this.isOminous ? this.config.ominous().value() : this.config.normal.value();
    }

    public TrialSpawnerConfig normalConfig() {
        return this.config.normal.value();
    }

    public TrialSpawnerConfig ominousConfig() {
        return this.config.ominous.value();
    }

    public void load(ValueInput p_421696_) {
        p_421696_.read(TrialSpawnerStateData.Packed.MAP_CODEC).ifPresent(this.data::apply);
        this.config = p_421696_.read(FullConfig.MAP_CODEC).orElse(FullConfig.DEFAULT);
    }

    public void store(ValueOutput p_422109_) {
        p_422109_.store(TrialSpawnerStateData.Packed.MAP_CODEC, this.data.pack());
        p_422109_.store(FullConfig.MAP_CODEC, this.config);
    }

    public void applyOminous(ServerLevel p_338315_, BlockPos p_338416_) {
        p_338315_.setBlock(p_338416_, (BlockState)p_338315_.getBlockState(p_338416_).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        p_338315_.levelEvent(3020, p_338416_, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, p_338315_);
    }

    public void removeOminous(ServerLevel p_338672_, BlockPos p_338318_) {
        p_338672_.setBlock(p_338318_, (BlockState)p_338672_.getBlockState(p_338318_).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public int getTargetCooldownLength() {
        return this.config.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.config.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public TrialSpawnerStateData getStateData() {
        return this.data;
    }

    public void setState(Level p_312688_, TrialSpawnerState p_312718_) {
        this.stateAccessor.setState(p_312688_, p_312718_);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(ServerLevel p_376465_) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        return p_376465_.getDifficulty() == Difficulty.PEACEFUL ? false : p_376465_.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
    }

    public Optional<UUID> spawnMob(ServerLevel p_312582_, BlockPos p_312518_) {
        Optional<UUID> optional1;
        RandomSource randomsource = p_312582_.getRandom();
        SpawnData spawndata = this.data.getOrCreateNextSpawnData(this, p_312582_.getRandom());
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(() -> "spawner@" + String.valueOf(p_312518_), LOGGER);){
            Object mob;
            SpawnData.CustomSpawnRules spawndata$customspawnrules;
            ValueInput valueinput = TagValueInput.create((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)p_312582_.registryAccess(), spawndata.entityToSpawn());
            Optional<EntityType<?>> optional = EntityType.by(valueinput);
            if (optional.isEmpty()) {
                Optional<UUID> optional2 = Optional.empty();
                return optional2;
            }
            Vec3 vec3 = valueinput.read("Pos", Vec3.CODEC).orElseGet(() -> {
                TrialSpawnerConfig trialspawnerconfig = this.activeConfig();
                return new Vec3((double)p_312518_.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)trialspawnerconfig.spawnRange() + 0.5, p_312518_.getY() + randomsource.nextInt(3) - 1, (double)p_312518_.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)trialspawnerconfig.spawnRange() + 0.5);
            });
            if (!p_312582_.noCollision(optional.get().getSpawnAABB(vec3.x, vec3.y, vec3.z))) {
                Optional<UUID> optional3 = Optional.empty();
                return optional3;
            }
            if (!TrialSpawner.inLineOfSight(p_312582_, p_312518_.getCenter(), vec3)) {
                Optional<UUID> optional4 = Optional.empty();
                return optional4;
            }
            BlockPos blockpos = BlockPos.containing(vec3);
            if (!SpawnPlacements.checkSpawnRules(optional.get(), p_312582_, EntitySpawnReason.TRIAL_SPAWNER, blockpos, p_312582_.getRandom())) {
                Optional<UUID> optional5 = Optional.empty();
                return optional5;
            }
            if (spawndata.getCustomSpawnRules().isPresent() && !(spawndata$customspawnrules = spawndata.getCustomSpawnRules().get()).isValidPosition(blockpos, p_312582_)) {
                Optional<UUID> optional6 = Optional.empty();
                return optional6;
            }
            Entity entity = EntityType.loadEntityRecursive(valueinput, (Level)p_312582_, EntitySpawnReason.TRIAL_SPAWNER, p_404588_ -> {
                p_404588_.snapTo(vec3.x, vec3.y, vec3.z, randomsource.nextFloat() * 360.0f, 0.0f);
                return p_404588_;
            });
            if (entity == null) {
                Optional<UUID> optional7 = Optional.empty();
                return optional7;
            }
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                if (!((Mob)mob).checkSpawnObstruction(p_312582_)) {
                    Optional<UUID> optional8 = Optional.empty();
                    return optional8;
                }
                boolean flag = spawndata.getEntityToSpawn().size() == 1 && spawndata.getEntityToSpawn().getString("id").isPresent();
                EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)p_312582_, (DifficultyInstance)p_312582_.getCurrentDifficultyAt(((Entity)mob).blockPosition()), (EntitySpawnReason)EntitySpawnReason.TRIAL_SPAWNER, null, (IOwnedSpawner)this, (boolean)flag);
                ((Mob)mob).setPersistenceRequired();
                spawndata.getEquipment().ifPresent(((Mob)mob)::equip);
            }
            if (!p_312582_.tryAddFreshEntityWithPassengers(entity)) {
                mob = Optional.empty();
                return mob;
            }
            FlameParticle trialspawner$flameparticle = this.isOminous ? FlameParticle.OMINOUS : FlameParticle.NORMAL;
            p_312582_.levelEvent(3011, p_312518_, trialspawner$flameparticle.encode());
            p_312582_.levelEvent(3012, blockpos, trialspawner$flameparticle.encode());
            p_312582_.gameEvent(entity, GameEvent.ENTITY_PLACE, blockpos);
            optional1 = Optional.of(entity.getUUID());
        }
        return optional1;
    }

    public void ejectReward(ServerLevel p_312892_, BlockPos p_312668_, ResourceKey<LootTable> p_335942_) {
        LootParams lootparams;
        LootTable loottable = p_312892_.getServer().reloadableRegistries().getLootTable(p_335942_);
        ObjectArrayList<ItemStack> objectarraylist = loottable.getRandomItems(lootparams = new LootParams.Builder(p_312892_).create(LootContextParamSets.EMPTY));
        if (!objectarraylist.isEmpty()) {
            for (ItemStack itemstack : objectarraylist) {
                DefaultDispenseItemBehavior.spawnItem(p_312892_, itemstack, 2, Direction.UP, Vec3.atBottomCenterOf(p_312668_).relative(Direction.UP, 1.2));
            }
            p_312892_.levelEvent(3014, p_312668_, 0);
        }
    }

    public void tickClient(Level p_312771_, BlockPos p_312484_, boolean p_338382_) {
        RandomSource randomsource;
        TrialSpawnerState trialspawnerstate = this.getState();
        trialspawnerstate.emitParticles(p_312771_, p_312484_, p_338382_);
        if (trialspawnerstate.hasSpinningMob()) {
            double d0 = Math.max(0L, this.data.nextMobSpawnsAt - p_312771_.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + trialspawnerstate.spinningMobSpeed() / (d0 + 200.0)) % 360.0;
        }
        if (trialspawnerstate.isCapableOfSpawning() && (randomsource = p_312771_.getRandom()).nextFloat() <= 0.02f) {
            SoundEvent soundevent = p_338382_ ? SoundEvents.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEvents.TRIAL_SPAWNER_AMBIENT;
            p_312771_.playLocalSound(p_312484_, soundevent, SoundSource.BLOCKS, randomsource.nextFloat() * 0.25f + 0.75f, randomsource.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(ServerLevel p_312132_, BlockPos p_312062_, boolean p_338207_) {
        TrialSpawnerState trialspawnerstate1;
        this.isOminous = p_338207_;
        TrialSpawnerState trialspawnerstate = this.getState();
        if (this.data.currentMobs.removeIf(p_312870_ -> TrialSpawner.shouldMobBeUntracked(p_312132_, p_312062_, p_312870_))) {
            this.data.nextMobSpawnsAt = p_312132_.getGameTime() + (long)this.activeConfig().ticksBetweenSpawn();
        }
        if ((trialspawnerstate1 = trialspawnerstate.tickAndGetNext(p_312062_, this, p_312132_)) != trialspawnerstate) {
            this.setState(p_312132_, trialspawnerstate1);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel p_312908_, BlockPos p_312807_, UUID p_311952_) {
        Entity entity = p_312908_.getEntity(p_311952_);
        return entity == null || !entity.isAlive() || !entity.level().dimension().equals(p_312908_.dimension()) || entity.blockPosition().distSqr(p_312807_) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level p_312623_, Vec3 p_312390_, Vec3 p_312652_) {
        BlockHitResult blockhitresult = p_312623_.clip(new ClipContext(p_312652_, p_312390_, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return blockhitresult.getBlockPos().equals(BlockPos.containing(p_312390_)) || blockhitresult.getType() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(Level p_312303_, BlockPos p_312392_, RandomSource p_312825_, SimpleParticleType p_338426_) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)p_312392_.getX() + 0.5 + (p_312825_.nextDouble() - 0.5) * 2.0;
            double d1 = (double)p_312392_.getY() + 0.5 + (p_312825_.nextDouble() - 0.5) * 2.0;
            double d2 = (double)p_312392_.getZ() + 0.5 + (p_312825_.nextDouble() - 0.5) * 2.0;
            p_312303_.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            p_312303_.addParticle(p_338426_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(Level p_338657_, BlockPos p_338406_, RandomSource p_338527_) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)p_338406_.getX() + 0.5 + (p_338527_.nextDouble() - 0.5) * 2.0;
            double d1 = (double)p_338406_.getY() + 0.5 + (p_338527_.nextDouble() - 0.5) * 2.0;
            double d2 = (double)p_338406_.getZ() + 0.5 + (p_338527_.nextDouble() - 0.5) * 2.0;
            double d3 = p_338527_.nextGaussian() * 0.02;
            double d4 = p_338527_.nextGaussian() * 0.02;
            double d5 = p_338527_.nextGaussian() * 0.02;
            p_338657_.addParticle(ParticleTypes.TRIAL_OMEN, d0, d1, d2, d3, d4, d5);
            p_338657_.addParticle(ParticleTypes.SOUL_FIRE_FLAME, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void addDetectPlayerParticles(Level p_312225_, BlockPos p_311759_, RandomSource p_312553_, int p_312188_, ParticleOptions p_338522_) {
        for (int i = 0; i < 30 + Math.min(p_312188_, 10) * 5; ++i) {
            double d0 = (double)(2.0f * p_312553_.nextFloat() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * p_312553_.nextFloat() - 1.0f) * 0.65;
            double d2 = (double)p_311759_.getX() + 0.5 + d0;
            double d3 = (double)p_311759_.getY() + 0.1 + (double)p_312553_.nextFloat() * 0.8;
            double d4 = (double)p_311759_.getZ() + 0.5 + d1;
            p_312225_.addParticle(p_338522_, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(Level p_312009_, BlockPos p_312583_, RandomSource p_312715_) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)p_312583_.getX() + 0.4 + p_312715_.nextDouble() * 0.2;
            double d1 = (double)p_312583_.getY() + 0.4 + p_312715_.nextDouble() * 0.2;
            double d2 = (double)p_312583_.getZ() + 0.4 + p_312715_.nextDouble() * 0.2;
            double d3 = p_312715_.nextGaussian() * 0.02;
            double d4 = p_312715_.nextGaussian() * 0.02;
            double d5 = p_312715_.nextGaussian() * 0.02;
            p_312009_.addParticle(ParticleTypes.SMALL_FLAME, d0, d1, d2, d3, d4, d5 * 0.25);
            p_312009_.addParticle(ParticleTypes.SMOKE, d0, d1, d2, d3, d4, d5);
        }
    }

    public void overrideEntityToSpawn(EntityType<?> p_387174_, Level p_386596_) {
        this.data.reset();
        this.config = this.config.overrideEntity(p_387174_);
        this.setState(p_386596_, TrialSpawnerState.INACTIVE);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector p_312510_) {
        this.playerDetector = p_312510_;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    @Nullable
    public Either<BlockEntity, Entity> getOwner() {
        StateAccessor stateAccessor = this.stateAccessor;
        if (stateAccessor instanceof TrialSpawnerBlockEntity) {
            TrialSpawnerBlockEntity be = (TrialSpawnerBlockEntity)stateAccessor;
            return Either.left((Object)be);
        }
        return null;
    }

    public record FullConfig(Holder<TrialSpawnerConfig> normal, Holder<TrialSpawnerConfig> ominous, int targetCooldownLength, int requiredPlayerRange) {
        public static final MapCodec<FullConfig> MAP_CODEC = RecordCodecBuilder.mapCodec(p_422015_ -> p_422015_.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf("normal_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(FullConfig::normal), (App)TrialSpawnerConfig.CODEC.optionalFieldOf("ominous_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(FullConfig::ominous), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(FullConfig::targetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(FullConfig::requiredPlayerRange)).apply((Applicative)p_422015_, FullConfig::new));
        public static final FullConfig DEFAULT = new FullConfig(Holder.direct(TrialSpawnerConfig.DEFAULT), Holder.direct(TrialSpawnerConfig.DEFAULT), 36000, 14);

        public FullConfig overrideEntity(EntityType<?> p_422573_) {
            return new FullConfig(Holder.direct(this.normal.value().withSpawning(p_422573_)), Holder.direct(this.ominous.value().withSpawning(p_422573_)), this.targetCooldownLength, this.requiredPlayerRange);
        }
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static enum FlameParticle {
        NORMAL(ParticleTypes.FLAME),
        OMINOUS(ParticleTypes.SOUL_FIRE_FLAME);

        public final SimpleParticleType particleType;

        private FlameParticle(SimpleParticleType p_338374_) {
            this.particleType = p_338374_;
        }

        public static FlameParticle decode(int p_338695_) {
            FlameParticle[] atrialspawner$flameparticle = FlameParticle.values();
            return p_338695_ <= atrialspawner$flameparticle.length && p_338695_ >= 0 ? atrialspawner$flameparticle[p_338695_] : NORMAL;
        }

        public int encode() {
            return this.ordinal();
        }
    }
}

