/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestCommand;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class TestInstanceBlockEntity
extends BlockEntity
implements BeaconBeamOwner,
BoundingBoxRenderable {
    private static final Component INVALID_TEST_NAME = Component.translatable("test_instance_block.invalid_test");
    private static final List<BeaconBeamOwner.Section> BEAM_CLEARED = List.of();
    private static final List<BeaconBeamOwner.Section> BEAM_RUNNING = List.of(new BeaconBeamOwner.Section(ARGB.color(128, 128, 128)));
    private static final List<BeaconBeamOwner.Section> BEAM_SUCCESS = List.of(new BeaconBeamOwner.Section(ARGB.color(0, 255, 0)));
    private static final List<BeaconBeamOwner.Section> BEAM_REQUIRED_FAILED = List.of(new BeaconBeamOwner.Section(ARGB.color(255, 0, 0)));
    private static final List<BeaconBeamOwner.Section> BEAM_OPTIONAL_FAILED = List.of(new BeaconBeamOwner.Section(ARGB.color(255, 128, 0)));
    private static final Vec3i STRUCTURE_OFFSET = new Vec3i(0, 1, 1);
    private Data data = new Data(Optional.empty(), Vec3i.ZERO, Rotation.NONE, false, Status.CLEARED, Optional.empty());

    public TestInstanceBlockEntity(BlockPos p_398018_, BlockState p_397894_) {
        super(BlockEntityType.TEST_INSTANCE_BLOCK, p_398018_, p_397894_);
    }

    public void set(Data p_397682_) {
        this.data = p_397682_;
        this.setChanged();
    }

    public static Optional<Vec3i> getStructureSize(ServerLevel p_397895_, ResourceKey<GameTestInstance> p_397299_) {
        return TestInstanceBlockEntity.getStructureTemplate(p_397895_, p_397299_).map(StructureTemplate::getSize);
    }

    public BoundingBox getStructureBoundingBox() {
        BlockPos blockpos = this.getStructurePos();
        BlockPos blockpos1 = blockpos.offset(this.getTransformedSize()).offset(-1, -1, -1);
        return BoundingBox.fromCorners(blockpos, blockpos1);
    }

    public AABB getStructureBounds() {
        return AABB.of(this.getStructureBoundingBox());
    }

    private static Optional<StructureTemplate> getStructureTemplate(ServerLevel p_397539_, ResourceKey<GameTestInstance> p_397417_) {
        return p_397539_.registryAccess().get(p_397417_).map(p_397340_ -> ((GameTestInstance)p_397340_.value()).structure()).flatMap(p_396996_ -> p_397539_.getStructureManager().get((ResourceLocation)p_396996_));
    }

    public Optional<ResourceKey<GameTestInstance>> test() {
        return this.data.test();
    }

    public Component getTestName() {
        return this.test().map(p_397722_ -> Component.literal(p_397722_.location().toString())).orElse(INVALID_TEST_NAME);
    }

    private Optional<Holder.Reference<GameTestInstance>> getTestHolder() {
        return this.test().flatMap(this.level.registryAccess()::get);
    }

    public boolean ignoreEntities() {
        return this.data.ignoreEntities();
    }

    public Vec3i getSize() {
        return this.data.size();
    }

    public Rotation getRotation() {
        return this.getTestHolder().map(Holder::value).map(GameTestInstance::rotation).orElse(Rotation.NONE).getRotated(this.data.rotation());
    }

    public Optional<Component> errorMessage() {
        return this.data.errorMessage();
    }

    public void setErrorMessage(Component p_397179_) {
        this.set(this.data.withError(p_397179_));
    }

    public void setSuccess() {
        this.set(this.data.withStatus(Status.FINISHED));
        this.removeBarriers();
    }

    public void setRunning() {
        this.set(this.data.withStatus(Status.RUNNING));
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level instanceof ServerLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_397498_) {
        return this.saveCustomOnly(p_397498_);
    }

    @Override
    protected void loadAdditional(ValueInput p_421695_) {
        p_421695_.read("data", Data.CODEC).ifPresent(this::set);
    }

    @Override
    protected void saveAdditional(ValueOutput p_421621_) {
        p_421621_.store("data", Data.CODEC, this.data);
    }

    @Override
    public BoundingBoxRenderable.Mode renderMode() {
        return BoundingBoxRenderable.Mode.BOX;
    }

    public BlockPos getStructurePos() {
        return TestInstanceBlockEntity.getStructurePos(this.getBlockPos());
    }

    public static BlockPos getStructurePos(BlockPos p_397863_) {
        return p_397863_.offset(STRUCTURE_OFFSET);
    }

    @Override
    public BoundingBoxRenderable.RenderableBox getRenderableBox() {
        return new BoundingBoxRenderable.RenderableBox(new BlockPos(STRUCTURE_OFFSET), this.getTransformedSize());
    }

    @Override
    public List<BeaconBeamOwner.Section> getBeamSections() {
        return switch (this.data.status().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BEAM_CLEARED;
            case 1 -> BEAM_RUNNING;
            case 2 -> this.errorMessage().isEmpty() ? BEAM_SUCCESS : (this.getTestHolder().map(Holder::value).map(GameTestInstance::required).orElse(true) != false ? BEAM_REQUIRED_FAILED : BEAM_OPTIONAL_FAILED);
        };
    }

    private Vec3i getTransformedSize() {
        Vec3i vec3i = this.getSize();
        Rotation rotation = this.getRotation();
        boolean flag = rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90;
        int i = flag ? vec3i.getZ() : vec3i.getX();
        int j = flag ? vec3i.getX() : vec3i.getZ();
        return new Vec3i(i, vec3i.getY(), j);
    }

    public void resetTest(Consumer<Component> p_397939_) {
        this.removeBarriers();
        boolean flag = this.placeStructure();
        if (flag) {
            p_397939_.accept(Component.translatable("test_instance_block.reset_success", this.getTestName()).withStyle(ChatFormatting.GREEN));
        }
        this.set(this.data.withStatus(Status.CLEARED));
    }

    public Optional<ResourceLocation> saveTest(Consumer<Component> p_398041_) {
        Optional<Holder.Reference<GameTestInstance>> optional = this.getTestHolder();
        Optional<ResourceLocation> optional1 = optional.isPresent() ? Optional.of(optional.get().value().structure()) : this.test().map(ResourceKey::location);
        if (optional1.isEmpty()) {
            BlockPos blockpos = this.getBlockPos();
            p_398041_.accept(Component.translatable("test_instance_block.error.unable_to_save", blockpos.getX(), blockpos.getY(), blockpos.getZ()).withStyle(ChatFormatting.RED));
            return optional1;
        }
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            StructureBlockEntity.saveStructure(serverlevel, optional1.get(), this.getStructurePos(), this.getSize(), this.ignoreEntities(), "", true, List.of(Blocks.AIR));
        }
        return optional1;
    }

    public boolean exportTest(Consumer<Component> p_396997_) {
        boolean bl;
        Level level;
        Optional<ResourceLocation> optional = this.saveTest(p_396997_);
        if (!optional.isEmpty() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            bl = TestInstanceBlockEntity.export(serverlevel, optional.get(), p_396997_);
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean export(ServerLevel p_397725_, ResourceLocation p_397333_, Consumer<Component> p_397846_) {
        Path path = StructureUtils.testStructuresDir;
        Path path1 = p_397725_.getStructureManager().createAndValidatePathToGeneratedStructure(p_397333_, ".nbt");
        Path path2 = NbtToSnbt.convertStructure(CachedOutput.NO_CACHE, path1, p_397333_.getPath(), path.resolve(p_397333_.getNamespace()).resolve("structure"));
        if (path2 == null) {
            p_397846_.accept(Component.literal("Failed to export " + String.valueOf(path1)).withStyle(ChatFormatting.RED));
            return true;
        }
        try {
            FileUtil.createDirectoriesSafe(path2.getParent());
        }
        catch (IOException ioexception) {
            p_397846_.accept(Component.literal("Could not create folder " + String.valueOf(path2.getParent())).withStyle(ChatFormatting.RED));
            return true;
        }
        p_397846_.accept(Component.literal("Exported " + String.valueOf(p_397333_) + " to " + String.valueOf(path2.toAbsolutePath())));
        return false;
    }

    public void runTest(Consumer<Component> p_397726_) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Optional<Holder.Reference<GameTestInstance>> optional = this.getTestHolder();
            BlockPos $$4 = this.getBlockPos();
            if (optional.isEmpty()) {
                p_397726_.accept(Component.translatable("test_instance_block.error.no_test", $$4.getX(), $$4.getY(), $$4.getZ()).withStyle(ChatFormatting.RED));
            } else if (!this.placeStructure()) {
                p_397726_.accept(Component.translatable("test_instance_block.error.no_test_structure", $$4.getX(), $$4.getY(), $$4.getZ()).withStyle(ChatFormatting.RED));
            } else {
                GameTestRunner.clearMarkers(serverlevel);
                GameTestTicker.SINGLETON.clear();
                FailedTestTracker.forgetFailedTests();
                p_397726_.accept(Component.translatable("test_instance_block.starting", optional.get().getRegisteredName()));
                GameTestInfo gametestinfo = new GameTestInfo(optional.get(), this.data.rotation(), serverlevel, RetryOptions.noRetries());
                gametestinfo.setTestBlockPos($$4);
                GameTestRunner gametestrunner = GameTestRunner.Builder.fromInfo(List.of(gametestinfo), serverlevel).build();
                TestCommand.trackAndStartRunner(serverlevel.getServer().createCommandSourceStack(), gametestrunner);
            }
        }
    }

    public boolean placeStructure() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Optional optional = this.data.test().flatMap(p_397292_ -> TestInstanceBlockEntity.getStructureTemplate(serverlevel, p_397292_));
            if (optional.isPresent()) {
                this.placeStructure(serverlevel, (StructureTemplate)optional.get());
                return true;
            }
        }
        return false;
    }

    private void placeStructure(ServerLevel p_397984_, StructureTemplate p_397168_) {
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().setRotation(this.getRotation()).setIgnoreEntities(this.data.ignoreEntities()).setKnownShape(true);
        BlockPos blockpos = this.getStartCorner();
        this.forceLoadChunks();
        this.removeEntities();
        p_397168_.placeInWorld(p_397984_, blockpos, blockpos, structureplacesettings, p_397984_.getRandom(), 818);
    }

    private void removeEntities() {
        this.level.getEntities(null, this.getStructureBounds()).stream().filter(p_399456_ -> !(p_399456_ instanceof Player)).forEach(Entity::discard);
    }

    private void forceLoadChunks() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.getStructureBoundingBox().intersectingChunks().forEach(p_397470_ -> serverlevel.setChunkForced(p_397470_.x, p_397470_.z, true));
        }
    }

    public BlockPos getStartCorner() {
        Vec3i vec3i = this.getSize();
        Rotation rotation = this.getRotation();
        BlockPos blockpos = this.getStructurePos();
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> blockpos;
            case Rotation.CLOCKWISE_90 -> blockpos.offset(vec3i.getZ() - 1, 0, 0);
            case Rotation.CLOCKWISE_180 -> blockpos.offset(vec3i.getX() - 1, 0, vec3i.getZ() - 1);
            case Rotation.COUNTERCLOCKWISE_90 -> blockpos.offset(0, 0, vec3i.getX() - 1);
        };
    }

    public void encaseStructure() {
        this.processStructureBoundary(p_397469_ -> {
            if (!this.level.getBlockState((BlockPos)p_397469_).is(Blocks.TEST_INSTANCE_BLOCK)) {
                this.level.setBlockAndUpdate((BlockPos)p_397469_, Blocks.BARRIER.defaultBlockState());
            }
        });
    }

    public void removeBarriers() {
        this.processStructureBoundary(p_398011_ -> {
            if (this.level.getBlockState((BlockPos)p_398011_).is(Blocks.BARRIER)) {
                this.level.setBlockAndUpdate((BlockPos)p_398011_, Blocks.AIR.defaultBlockState());
            }
        });
    }

    public void processStructureBoundary(Consumer<BlockPos> p_397268_) {
        AABB aabb = this.getStructureBounds();
        boolean flag = this.getTestHolder().map(p_397339_ -> ((GameTestInstance)p_397339_.value()).skyAccess()).orElse(false) == false;
        BlockPos blockpos = BlockPos.containing(aabb.minX, aabb.minY, aabb.minZ).offset(-1, -1, -1);
        BlockPos blockpos1 = BlockPos.containing(aabb.maxX, aabb.maxY, aabb.maxZ);
        BlockPos.betweenClosedStream(blockpos, blockpos1).forEach(p_397351_ -> {
            boolean flag2;
            boolean flag1 = p_397351_.getX() == blockpos.getX() || p_397351_.getX() == blockpos1.getX() || p_397351_.getZ() == blockpos.getZ() || p_397351_.getZ() == blockpos1.getZ() || p_397351_.getY() == blockpos.getY();
            boolean bl = flag2 = p_397351_.getY() == blockpos1.getY();
            if (flag1 || flag2 && flag) {
                p_397268_.accept((BlockPos)p_397351_);
            }
        });
    }

    public record Data(Optional<ResourceKey<GameTestInstance>> test, Vec3i size, Rotation rotation, boolean ignoreEntities, Status status, Optional<Component> errorMessage) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(p_397596_ -> p_397596_.group((App)ResourceKey.codec(Registries.TEST_INSTANCE).optionalFieldOf("test").forGetter(Data::test), (App)Vec3i.CODEC.fieldOf("size").forGetter(Data::size), (App)Rotation.CODEC.fieldOf("rotation").forGetter(Data::rotation), (App)Codec.BOOL.fieldOf("ignore_entities").forGetter(Data::ignoreEntities), (App)Status.CODEC.fieldOf("status").forGetter(Data::status), (App)ComponentSerialization.CODEC.optionalFieldOf("error_message").forGetter(Data::errorMessage)).apply((Applicative)p_397596_, Data::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ResourceKey.streamCodec(Registries.TEST_INSTANCE)), Data::test, Vec3i.STREAM_CODEC, Data::size, Rotation.STREAM_CODEC, Data::rotation, ByteBufCodecs.BOOL, Data::ignoreEntities, Status.STREAM_CODEC, Data::status, ByteBufCodecs.optional(ComponentSerialization.STREAM_CODEC), Data::errorMessage, Data::new);

        public Data withSize(Vec3i p_397709_) {
            return new Data(this.test, p_397709_, this.rotation, this.ignoreEntities, this.status, this.errorMessage);
        }

        public Data withStatus(Status p_398013_) {
            return new Data(this.test, this.size, this.rotation, this.ignoreEntities, p_398013_, Optional.empty());
        }

        public Data withError(Component p_397453_) {
            return new Data(this.test, this.size, this.rotation, this.ignoreEntities, Status.FINISHED, Optional.of(p_397453_));
        }
    }

    public static enum Status implements StringRepresentable
    {
        CLEARED("cleared", 0),
        RUNNING("running", 1),
        FINISHED("finished", 2);

        private static final IntFunction<Status> ID_MAP;
        public static final Codec<Status> CODEC;
        public static final StreamCodec<ByteBuf, Status> STREAM_CODEC;
        private final String id;
        private final int index;

        private Status(String p_397410_, int p_397632_) {
            this.id = p_397410_;
            this.index = p_397632_;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        public static Status byIndex(int p_397227_) {
            return ID_MAP.apply(p_397227_);
        }

        static {
            ID_MAP = ByIdMap.continuous(p_397441_ -> p_397441_.index, Status.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Status::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(Status::byIndex, p_397803_ -> p_397803_.index);
        }
    }
}

