/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class StructureBlockEntity
extends BlockEntity
implements BoundingBoxRenderable {
    private static final int SCAN_CORNER_BLOCKS_RANGE = 5;
    public static final int MAX_OFFSET_PER_AXIS = 48;
    public static final int MAX_SIZE_PER_AXIS = 48;
    public static final String AUTHOR_TAG = "author";
    private static final String DEFAULT_AUTHOR = "";
    private static final String DEFAULT_METADATA = "";
    private static final BlockPos DEFAULT_POS = new BlockPos(0, 1, 0);
    private static final Vec3i DEFAULT_SIZE = Vec3i.ZERO;
    private static final Rotation DEFAULT_ROTATION = Rotation.NONE;
    private static final Mirror DEFAULT_MIRROR = Mirror.NONE;
    private static final boolean DEFAULT_IGNORE_ENTITIES = true;
    private static final boolean DEFAULT_STRICT = false;
    private static final boolean DEFAULT_POWERED = false;
    private static final boolean DEFAULT_SHOW_AIR = false;
    private static final boolean DEFAULT_SHOW_BOUNDING_BOX = true;
    private static final float DEFAULT_INTEGRITY = 1.0f;
    private static final long DEFAULT_SEED = 0L;
    @Nullable
    private ResourceLocation structureName;
    private String author = "";
    private String metaData = "";
    private BlockPos structurePos = DEFAULT_POS;
    private Vec3i structureSize = DEFAULT_SIZE;
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private StructureMode mode;
    private boolean ignoreEntities = true;
    private boolean strict = false;
    private boolean powered = false;
    private boolean showAir = false;
    private boolean showBoundingBox = true;
    private float integrity = 1.0f;
    private long seed = 0L;

    public StructureBlockEntity(BlockPos p_155779_, BlockState p_155780_) {
        super(BlockEntityType.STRUCTURE_BLOCK, p_155779_, p_155780_);
        this.mode = p_155780_.getValue(StructureBlock.MODE);
    }

    @Override
    protected void saveAdditional(ValueOutput p_422197_) {
        super.saveAdditional(p_422197_);
        p_422197_.putString("name", this.getStructureName());
        p_422197_.putString(AUTHOR_TAG, this.author);
        p_422197_.putString("metadata", this.metaData);
        p_422197_.putInt("posX", this.structurePos.getX());
        p_422197_.putInt("posY", this.structurePos.getY());
        p_422197_.putInt("posZ", this.structurePos.getZ());
        p_422197_.putInt("sizeX", this.structureSize.getX());
        p_422197_.putInt("sizeY", this.structureSize.getY());
        p_422197_.putInt("sizeZ", this.structureSize.getZ());
        p_422197_.store("rotation", Rotation.LEGACY_CODEC, this.rotation);
        p_422197_.store("mirror", Mirror.LEGACY_CODEC, this.mirror);
        p_422197_.store("mode", StructureMode.LEGACY_CODEC, this.mode);
        p_422197_.putBoolean("ignoreEntities", this.ignoreEntities);
        p_422197_.putBoolean("strict", this.strict);
        p_422197_.putBoolean("powered", this.powered);
        p_422197_.putBoolean("showair", this.showAir);
        p_422197_.putBoolean("showboundingbox", this.showBoundingBox);
        p_422197_.putFloat("integrity", this.integrity);
        p_422197_.putLong("seed", this.seed);
    }

    @Override
    protected void loadAdditional(ValueInput p_422679_) {
        super.loadAdditional(p_422679_);
        this.setStructureName(p_422679_.getStringOr("name", ""));
        this.author = p_422679_.getStringOr(AUTHOR_TAG, "");
        this.metaData = p_422679_.getStringOr("metadata", "");
        int i = Mth.clamp(p_422679_.getIntOr("posX", DEFAULT_POS.getX()), -48, 48);
        int j = Mth.clamp(p_422679_.getIntOr("posY", DEFAULT_POS.getY()), -48, 48);
        int k = Mth.clamp(p_422679_.getIntOr("posZ", DEFAULT_POS.getZ()), -48, 48);
        this.structurePos = new BlockPos(i, j, k);
        int l = Mth.clamp(p_422679_.getIntOr("sizeX", DEFAULT_SIZE.getX()), 0, 48);
        int i1 = Mth.clamp(p_422679_.getIntOr("sizeY", DEFAULT_SIZE.getY()), 0, 48);
        int j1 = Mth.clamp(p_422679_.getIntOr("sizeZ", DEFAULT_SIZE.getZ()), 0, 48);
        this.structureSize = new Vec3i(l, i1, j1);
        this.rotation = p_422679_.read("rotation", Rotation.LEGACY_CODEC).orElse(DEFAULT_ROTATION);
        this.mirror = p_422679_.read("mirror", Mirror.LEGACY_CODEC).orElse(DEFAULT_MIRROR);
        this.mode = p_422679_.read("mode", StructureMode.LEGACY_CODEC).orElse(StructureMode.DATA);
        this.ignoreEntities = p_422679_.getBooleanOr("ignoreEntities", true);
        this.strict = p_422679_.getBooleanOr("strict", false);
        this.powered = p_422679_.getBooleanOr("powered", false);
        this.showAir = p_422679_.getBooleanOr("showair", false);
        this.showBoundingBox = p_422679_.getBooleanOr("showboundingbox", true);
        this.integrity = p_422679_.getFloatOr("integrity", 1.0f);
        this.seed = p_422679_.getLongOr("seed", 0L);
        this.updateBlockState();
    }

    private void updateBlockState() {
        BlockPos blockpos;
        BlockState blockstate;
        if (this.level != null && (blockstate = this.level.getBlockState(blockpos = this.getBlockPos())).is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock(blockpos, (BlockState)blockstate.setValue(StructureBlock.MODE, this.mode), 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_324257_) {
        return this.saveCustomOnly(p_324257_);
    }

    public boolean usedBy(Player p_59854_) {
        if (!p_59854_.canUseGameMasterBlocks()) {
            return false;
        }
        if (p_59854_.level().isClientSide) {
            p_59854_.openStructureBlock(this);
        }
        return true;
    }

    public String getStructureName() {
        return this.structureName == null ? "" : this.structureName.toString();
    }

    public boolean hasStructureName() {
        return this.structureName != null;
    }

    public void setStructureName(@Nullable String p_59869_) {
        this.setStructureName(StringUtil.isNullOrEmpty(p_59869_) ? null : ResourceLocation.tryParse(p_59869_));
    }

    public void setStructureName(@Nullable ResourceLocation p_59875_) {
        this.structureName = p_59875_;
    }

    public void createdBy(LivingEntity p_59852_) {
        this.author = p_59852_.getName().getString();
    }

    public BlockPos getStructurePos() {
        return this.structurePos;
    }

    public void setStructurePos(BlockPos p_59886_) {
        this.structurePos = p_59886_;
    }

    public Vec3i getStructureSize() {
        return this.structureSize;
    }

    public void setStructureSize(Vec3i p_155798_) {
        this.structureSize = p_155798_;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public void setMirror(Mirror p_59882_) {
        this.mirror = p_59882_;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(Rotation p_59884_) {
        this.rotation = p_59884_;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String p_59888_) {
        this.metaData = p_59888_;
    }

    public StructureMode getMode() {
        return this.mode;
    }

    public void setMode(StructureMode p_59861_) {
        this.mode = p_59861_;
        BlockState blockstate = this.level.getBlockState(this.getBlockPos());
        if (blockstate.is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)blockstate.setValue(StructureBlock.MODE, p_59861_), 2);
        }
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setIgnoreEntities(boolean p_59877_) {
        this.ignoreEntities = p_59877_;
    }

    public void setStrict(boolean p_393555_) {
        this.strict = p_393555_;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(float p_59839_) {
        this.integrity = p_59839_;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long p_59841_) {
        this.seed = p_59841_;
    }

    public boolean detectSize() {
        if (this.mode != StructureMode.SAVE) {
            return false;
        }
        BlockPos blockpos = this.getBlockPos();
        int i = 80;
        BlockPos blockpos1 = new BlockPos(blockpos.getX() - 80, this.level.getMinY(), blockpos.getZ() - 80);
        BlockPos blockpos2 = new BlockPos(blockpos.getX() + 80, this.level.getMaxY(), blockpos.getZ() + 80);
        Stream<BlockPos> stream = this.getRelatedCorners(blockpos1, blockpos2);
        return StructureBlockEntity.calculateEnclosingBoundingBox(blockpos, stream).filter(p_155790_ -> {
            int j = p_155790_.maxX() - p_155790_.minX();
            int k = p_155790_.maxY() - p_155790_.minY();
            int l = p_155790_.maxZ() - p_155790_.minZ();
            if (j > 1 && k > 1 && l > 1) {
                this.structurePos = new BlockPos(p_155790_.minX() - blockpos.getX() + 1, p_155790_.minY() - blockpos.getY() + 1, p_155790_.minZ() - blockpos.getZ() + 1);
                this.structureSize = new Vec3i(j - 1, k - 1, l - 1);
                this.setChanged();
                BlockState blockstate = this.level.getBlockState(blockpos);
                this.level.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
                return true;
            }
            return false;
        }).isPresent();
    }

    private Stream<BlockPos> getRelatedCorners(BlockPos p_155792_, BlockPos p_155793_) {
        return BlockPos.betweenClosedStream(p_155792_, p_155793_).filter(p_272561_ -> this.level.getBlockState((BlockPos)p_272561_).is(Blocks.STRUCTURE_BLOCK)).map(this.level::getBlockEntity).filter(p_155802_ -> p_155802_ instanceof StructureBlockEntity).map(p_155785_ -> (StructureBlockEntity)p_155785_).filter(p_155787_ -> p_155787_.mode == StructureMode.CORNER && Objects.equals(this.structureName, p_155787_.structureName)).map(BlockEntity::getBlockPos);
    }

    private static Optional<BoundingBox> calculateEnclosingBoundingBox(BlockPos p_155795_, Stream<BlockPos> p_155796_) {
        Iterator iterator = p_155796_.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        BlockPos blockpos = (BlockPos)iterator.next();
        BoundingBox boundingbox = new BoundingBox(blockpos);
        if (iterator.hasNext()) {
            iterator.forEachRemaining(boundingbox::encapsulate);
        } else {
            boundingbox.encapsulate(p_155795_);
        }
        return Optional.of(boundingbox);
    }

    public boolean saveStructure() {
        return this.mode != StructureMode.SAVE ? false : this.saveStructure(true);
    }

    public boolean saveStructure(boolean p_59890_) {
        Level level;
        if (this.structureName != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            BlockPos blockpos = this.getBlockPos().offset(this.structurePos);
            return StructureBlockEntity.saveStructure(serverlevel, this.structureName, blockpos, this.structureSize, this.ignoreEntities, this.author, p_59890_, List.of());
        }
        return false;
    }

    public static boolean saveStructure(ServerLevel p_396983_, ResourceLocation p_397437_, BlockPos p_397750_, Vec3i p_397557_, boolean p_397306_, String p_397604_, boolean p_397822_, List<Block> p_428567_) {
        StructureTemplate structuretemplate;
        StructureTemplateManager structuretemplatemanager = p_396983_.getStructureManager();
        try {
            structuretemplate = structuretemplatemanager.getOrCreate(p_397437_);
        }
        catch (ResourceLocationException resourcelocationexception1) {
            return false;
        }
        structuretemplate.fillFromWorld(p_396983_, p_397750_, p_397557_, !p_397306_, Stream.concat(p_428567_.stream(), Stream.of(Blocks.STRUCTURE_VOID)).toList());
        structuretemplate.setAuthor(p_397604_);
        if (p_397822_) {
            try {
                return structuretemplatemanager.save(p_397437_);
            }
            catch (ResourceLocationException resourcelocationexception) {
                return false;
            }
        }
        return true;
    }

    public static RandomSource createRandom(long p_222889_) {
        return p_222889_ == 0L ? RandomSource.create(Util.getMillis()) : RandomSource.create(p_222889_);
    }

    public boolean placeStructureIfSameSize(ServerLevel p_309647_) {
        if (this.mode == StructureMode.LOAD && this.structureName != null) {
            StructureTemplate structuretemplate = p_309647_.getStructureManager().get(this.structureName).orElse(null);
            if (structuretemplate == null) {
                return false;
            }
            if (structuretemplate.getSize().equals(this.structureSize)) {
                this.placeStructure(p_309647_, structuretemplate);
                return true;
            }
            this.loadStructureInfo(structuretemplate);
            return false;
        }
        return false;
    }

    public boolean loadStructureInfo(ServerLevel p_309683_) {
        StructureTemplate structuretemplate = this.getStructureTemplate(p_309683_);
        if (structuretemplate == null) {
            return false;
        }
        this.loadStructureInfo(structuretemplate);
        return true;
    }

    private void loadStructureInfo(StructureTemplate p_309715_) {
        this.author = !StringUtil.isNullOrEmpty(p_309715_.getAuthor()) ? p_309715_.getAuthor() : "";
        this.structureSize = p_309715_.getSize();
        this.setChanged();
    }

    public void placeStructure(ServerLevel p_309543_) {
        StructureTemplate structuretemplate = this.getStructureTemplate(p_309543_);
        if (structuretemplate != null) {
            this.placeStructure(p_309543_, structuretemplate);
        }
    }

    @Nullable
    private StructureTemplate getStructureTemplate(ServerLevel p_309601_) {
        return this.structureName == null ? null : (StructureTemplate)p_309601_.getStructureManager().get(this.structureName).orElse(null);
    }

    private void placeStructure(ServerLevel p_309691_, StructureTemplate p_309550_) {
        this.loadStructureInfo(p_309550_);
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().setMirror(this.mirror).setRotation(this.rotation).setIgnoreEntities(this.ignoreEntities).setKnownShape(this.strict);
        if (this.integrity < 1.0f) {
            structureplacesettings.clearProcessors().addProcessor(new BlockRotProcessor(Mth.clamp(this.integrity, 0.0f, 1.0f))).setRandom(StructureBlockEntity.createRandom(this.seed));
        }
        BlockPos blockpos = this.getBlockPos().offset(this.structurePos);
        p_309550_.placeInWorld(p_309691_, blockpos, blockpos, structureplacesettings, StructureBlockEntity.createRandom(this.seed), 2 | (this.strict ? 816 : 0));
    }

    public void unloadStructure() {
        if (this.structureName != null) {
            ServerLevel serverlevel = (ServerLevel)this.level;
            StructureTemplateManager structuretemplatemanager = serverlevel.getStructureManager();
            structuretemplatemanager.remove(this.structureName);
        }
    }

    public boolean isStructureLoadable() {
        if (this.mode == StructureMode.LOAD && !this.level.isClientSide && this.structureName != null) {
            ServerLevel serverlevel = (ServerLevel)this.level;
            StructureTemplateManager structuretemplatemanager = serverlevel.getStructureManager();
            try {
                return structuretemplatemanager.get(this.structureName).isPresent();
            }
            catch (ResourceLocationException resourcelocationexception) {
                return false;
            }
        }
        return false;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean p_59894_) {
        this.powered = p_59894_;
    }

    public boolean getShowAir() {
        return this.showAir;
    }

    public void setShowAir(boolean p_59897_) {
        this.showAir = p_59897_;
    }

    public boolean getShowBoundingBox() {
        return this.showBoundingBox;
    }

    public void setShowBoundingBox(boolean p_59899_) {
        this.showBoundingBox = p_59899_;
    }

    @Override
    public BoundingBoxRenderable.Mode renderMode() {
        if (this.mode != StructureMode.SAVE && this.mode != StructureMode.LOAD) {
            return BoundingBoxRenderable.Mode.NONE;
        }
        if (this.mode == StructureMode.SAVE && this.showAir) {
            return BoundingBoxRenderable.Mode.BOX_AND_INVISIBLE_BLOCKS;
        }
        return this.mode != StructureMode.SAVE && !this.showBoundingBox ? BoundingBoxRenderable.Mode.NONE : BoundingBoxRenderable.Mode.BOX;
    }

    @Override
    public BoundingBoxRenderable.RenderableBox getRenderableBox() {
        int l1;
        int k1;
        int i1;
        int k;
        BlockPos blockpos = this.getStructurePos();
        Vec3i vec3i = this.getStructureSize();
        int i = blockpos.getX();
        int j = blockpos.getZ();
        int j1 = blockpos.getY();
        int i2 = j1 + vec3i.getY();
        return BoundingBoxRenderable.RenderableBox.fromCorners(i1, j1, k1, l1, i2, switch (this.rotation) {
            case Rotation.CLOCKWISE_90 -> {
                i1 = (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        k = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        k = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        k = vec3i.getX();
                        yield vec3i.getZ();
                    }
                }) < 0 ? i : i + 1;
                k1 = k < 0 ? j + 1 : j;
                l1 = i1 - (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        k = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        k = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        k = vec3i.getX();
                        yield vec3i.getZ();
                    }
                });
                yield k1 + k;
            }
            case Rotation.CLOCKWISE_180 -> {
                i1 = k < 0 ? i : i + 1;
                k1 = (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        k = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        k = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        k = vec3i.getX();
                        yield vec3i.getZ();
                    }
                }) < 0 ? j : j + 1;
                l1 = i1 - k;
                yield k1 - (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        k = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        k = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        k = vec3i.getX();
                        yield vec3i.getZ();
                    }
                });
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                i1 = (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        k = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        k = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        k = vec3i.getX();
                        yield vec3i.getZ();
                    }
                }) < 0 ? i + 1 : i;
                k1 = k < 0 ? j : j + 1;
                l1 = i1 + (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        k = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        k = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        k = vec3i.getX();
                        yield vec3i.getZ();
                    }
                });
                yield k1 - k;
            }
            default -> {
                i1 = k < 0 ? i + 1 : i;
                k1 = (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        k = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        k = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        k = vec3i.getX();
                        yield vec3i.getZ();
                    }
                }) < 0 ? j + 1 : j;
                l1 = i1 + k;
                yield k1 + (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        k = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        k = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        k = vec3i.getX();
                        yield vec3i.getZ();
                    }
                });
            }
        });
    }

    public static enum UpdateType {
        UPDATE_DATA,
        SAVE_AREA,
        LOAD_AREA,
        SCAN_AREA;

    }
}

