/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ConduitBlockEntity
extends BlockEntity {
    private static final int BLOCK_REFRESH_RATE = 2;
    private static final int EFFECT_DURATION = 13;
    private static final float ROTATION_SPEED = -0.0375f;
    private static final int MIN_ACTIVE_SIZE = 16;
    private static final int MIN_KILL_SIZE = 42;
    private static final int KILL_RANGE = 8;
    private static final Block[] VALID_BLOCKS = new Block[]{Blocks.PRISMARINE, Blocks.PRISMARINE_BRICKS, Blocks.SEA_LANTERN, Blocks.DARK_PRISMARINE};
    public int tickCount;
    private float activeRotation;
    private boolean isActive;
    private boolean isHunting;
    private final List<BlockPos> effectBlocks = Lists.newArrayList();
    @Nullable
    private EntityReference<LivingEntity> destroyTarget;
    private long nextAmbientSoundActivation;

    public ConduitBlockEntity(BlockPos p_155397_, BlockState p_155398_) {
        super(BlockEntityType.CONDUIT, p_155397_, p_155398_);
    }

    @Override
    protected void loadAdditional(ValueInput p_422459_) {
        super.loadAdditional(p_422459_);
        this.destroyTarget = EntityReference.read(p_422459_, "Target");
    }

    @Override
    protected void saveAdditional(ValueOutput p_422645_) {
        super.saveAdditional(p_422645_);
        EntityReference.store(this.destroyTarget, p_422645_, "Target");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_324390_) {
        return this.saveCustomOnly(p_324390_);
    }

    public static void clientTick(Level p_155404_, BlockPos p_155405_, BlockState p_155406_, ConduitBlockEntity p_155407_) {
        ++p_155407_.tickCount;
        long i = p_155404_.getGameTime();
        List<BlockPos> list = p_155407_.effectBlocks;
        if (i % 40L == 0L) {
            p_155407_.isActive = ConduitBlockEntity.updateShape(p_155404_, p_155405_, list);
            ConduitBlockEntity.updateHunting(p_155407_, list);
        }
        LivingEntity livingentity = EntityReference.get(p_155407_.destroyTarget, p_155404_, LivingEntity.class);
        ConduitBlockEntity.animationTick(p_155404_, p_155405_, list, livingentity, p_155407_.tickCount);
        if (p_155407_.isActive()) {
            p_155407_.activeRotation += 1.0f;
        }
    }

    public static void serverTick(Level p_155439_, BlockPos p_155440_, BlockState p_155441_, ConduitBlockEntity p_155442_) {
        ++p_155442_.tickCount;
        long i = p_155439_.getGameTime();
        List<BlockPos> list = p_155442_.effectBlocks;
        if (i % 40L == 0L) {
            boolean flag = ConduitBlockEntity.updateShape(p_155439_, p_155440_, list);
            if (flag != p_155442_.isActive) {
                SoundEvent soundevent = flag ? SoundEvents.CONDUIT_ACTIVATE : SoundEvents.CONDUIT_DEACTIVATE;
                p_155439_.playSound(null, p_155440_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            p_155442_.isActive = flag;
            ConduitBlockEntity.updateHunting(p_155442_, list);
            if (flag) {
                ConduitBlockEntity.applyEffects(p_155439_, p_155440_, list);
                ConduitBlockEntity.updateAndAttackTarget((ServerLevel)p_155439_, p_155440_, p_155441_, p_155442_, list.size() >= 42);
            }
        }
        if (p_155442_.isActive()) {
            if (i % 80L == 0L) {
                p_155439_.playSound(null, p_155440_, SoundEvents.CONDUIT_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (i > p_155442_.nextAmbientSoundActivation) {
                p_155442_.nextAmbientSoundActivation = i + 60L + (long)p_155439_.getRandom().nextInt(40);
                p_155439_.playSound(null, p_155440_, SoundEvents.CONDUIT_AMBIENT_SHORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void updateHunting(ConduitBlockEntity p_155429_, List<BlockPos> p_155430_) {
        p_155429_.setHunting(p_155430_.size() >= 42);
    }

    private static boolean updateShape(Level p_155415_, BlockPos p_155416_, List<BlockPos> p_155417_) {
        p_155417_.clear();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos blockpos = p_155416_.offset(i, j, k);
                    if (p_155415_.isWaterAt(blockpos)) continue;
                    return false;
                }
            }
        }
        for (int j1 = -2; j1 <= 2; ++j1) {
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    BlockPos blockpos1;
                    BlockState blockstate;
                    int i2 = Math.abs(j1);
                    int l = Math.abs(k1);
                    int i1 = Math.abs(l1);
                    if (i2 <= 1 && l <= 1 && i1 <= 1 || (j1 != 0 || l != 2 && i1 != 2) && (k1 != 0 || i2 != 2 && i1 != 2) && (l1 != 0 || i2 != 2 && l != 2) || !(blockstate = p_155415_.getBlockState(blockpos1 = p_155416_.offset(j1, k1, l1))).isConduitFrame(p_155415_, blockpos1, p_155416_)) continue;
                    p_155417_.add(blockpos1);
                }
            }
        }
        return p_155417_.size() >= 16;
    }

    private static void applyEffects(Level p_155444_, BlockPos p_155445_, List<BlockPos> p_155446_) {
        int i1;
        int l;
        int i = p_155446_.size();
        int j = i / 7 * 16;
        int k = p_155445_.getX();
        AABB aabb = new AABB(k, l = p_155445_.getY(), i1 = p_155445_.getZ(), k + 1, l + 1, i1 + 1).inflate(j).expandTowards(0.0, p_155444_.getHeight(), 0.0);
        List list = p_155444_.getEntitiesOfClass(Player.class, aabb);
        if (!list.isEmpty()) {
            for (Player player : list) {
                if (!p_155445_.closerThan(player.blockPosition(), j) || !player.isInWaterOrRain()) continue;
                player.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 0, true, true));
            }
        }
    }

    private static void updateAndAttackTarget(ServerLevel p_423464_, BlockPos p_423617_, BlockState p_423636_, ConduitBlockEntity p_423533_, boolean p_423687_) {
        EntityReference<LivingEntity> entityreference = ConduitBlockEntity.updateDestroyTarget(p_423533_.destroyTarget, p_423464_, p_423617_, p_423687_);
        LivingEntity livingentity = EntityReference.get(entityreference, p_423464_, LivingEntity.class);
        if (livingentity != null) {
            p_423464_.playSound(null, livingentity.getX(), livingentity.getY(), livingentity.getZ(), SoundEvents.CONDUIT_ATTACK_TARGET, SoundSource.BLOCKS, 1.0f, 1.0f);
            livingentity.hurtServer(p_423464_, p_423464_.damageSources().magic(), 4.0f);
        }
        if (!Objects.equals(entityreference, p_423533_.destroyTarget)) {
            p_423533_.destroyTarget = entityreference;
            p_423464_.sendBlockUpdated(p_423617_, p_423636_, p_423636_, 2);
        }
    }

    @Nullable
    private static EntityReference<LivingEntity> updateDestroyTarget(@Nullable EntityReference<LivingEntity> p_423553_, ServerLevel p_423665_, BlockPos p_155410_, boolean p_423478_) {
        if (!p_423478_) {
            return null;
        }
        if (p_423553_ == null) {
            return ConduitBlockEntity.selectNewTarget(p_423665_, p_155410_);
        }
        LivingEntity livingentity = EntityReference.get(p_423553_, p_423665_, LivingEntity.class);
        return livingentity != null && livingentity.isAlive() && p_155410_.closerThan(livingentity.blockPosition(), 8.0) ? p_423553_ : null;
    }

    @Nullable
    private static EntityReference<LivingEntity> selectNewTarget(ServerLevel p_423488_, BlockPos p_423513_) {
        List list = p_423488_.getEntitiesOfClass(LivingEntity.class, ConduitBlockEntity.getDestroyRangeAABB(p_423513_), p_427192_ -> p_427192_ instanceof Enemy && p_427192_.isInWaterOrRain());
        return list.isEmpty() ? null : new EntityReference<LivingEntity>((LivingEntity)Util.getRandom(list, p_423488_.random));
    }

    private static AABB getDestroyRangeAABB(BlockPos p_155432_) {
        return new AABB(p_155432_).inflate(8.0);
    }

    private static void animationTick(Level p_155419_, BlockPos p_155420_, List<BlockPos> p_155421_, @Nullable Entity p_155422_, int p_155423_) {
        RandomSource randomsource = p_155419_.random;
        double d0 = Mth.sin((float)(p_155423_ + 35) * 0.1f) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3 vec3 = new Vec3((double)p_155420_.getX() + 0.5, (double)p_155420_.getY() + 1.5 + d0, (double)p_155420_.getZ() + 0.5);
        for (BlockPos blockpos : p_155421_) {
            if (randomsource.nextInt(50) != 0) continue;
            BlockPos blockpos1 = blockpos.subtract(p_155420_);
            float f = -0.5f + randomsource.nextFloat() + (float)blockpos1.getX();
            float f1 = -2.0f + randomsource.nextFloat() + (float)blockpos1.getY();
            float f2 = -0.5f + randomsource.nextFloat() + (float)blockpos1.getZ();
            p_155419_.addParticle(ParticleTypes.NAUTILUS, vec3.x, vec3.y, vec3.z, f, f1, f2);
        }
        if (p_155422_ != null) {
            Vec3 vec31 = new Vec3(p_155422_.getX(), p_155422_.getEyeY(), p_155422_.getZ());
            float f3 = (-0.5f + randomsource.nextFloat()) * (3.0f + p_155422_.getBbWidth());
            float f4 = -1.0f + randomsource.nextFloat() * p_155422_.getBbHeight();
            float f5 = (-0.5f + randomsource.nextFloat()) * (3.0f + p_155422_.getBbWidth());
            Vec3 vec32 = new Vec3(f3, f4, f5);
            p_155419_.addParticle(ParticleTypes.NAUTILUS, vec31.x, vec31.y, vec31.z, vec32.x, vec32.y, vec32.z);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isHunting() {
        return this.isHunting;
    }

    private void setHunting(boolean p_59215_) {
        this.isHunting = p_59215_;
    }

    public float getActiveRotation(float p_59198_) {
        return (this.activeRotation + p_59198_) * -0.0375f;
    }
}

