/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.TestBlockMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;

public class TestBlock
extends BaseEntityBlock
implements GameMasterBlock {
    public static final MapCodec<TestBlock> CODEC = TestBlock.simpleCodec(TestBlock::new);
    public static final EnumProperty<TestBlockMode> MODE = BlockStateProperties.TEST_BLOCK_MODE;

    public TestBlock(BlockBehaviour.Properties p_397223_) {
        super(p_397223_);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_397356_, BlockState p_397468_) {
        return new TestBlockEntity(p_397356_, p_397468_);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_397700_) {
        TestBlockMode testblockmode;
        BlockItemStateProperties blockitemstateproperties = p_397700_.getItemInHand().get(DataComponents.BLOCK_STATE);
        BlockState blockstate = this.defaultBlockState();
        if (blockitemstateproperties != null && (testblockmode = blockitemstateproperties.get(MODE)) != null) {
            blockstate = (BlockState)blockstate.setValue(MODE, testblockmode);
        }
        return blockstate;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_397099_) {
        p_397099_.add(MODE);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_397020_, Level p_397230_, BlockPos p_397100_, Player p_397362_, BlockHitResult p_397202_) {
        BlockEntity blockEntity = p_397230_.getBlockEntity(p_397100_);
        if (blockEntity instanceof TestBlockEntity) {
            TestBlockEntity testblockentity = (TestBlockEntity)blockEntity;
            if (!p_397362_.canUseGameMasterBlocks()) {
                return InteractionResult.PASS;
            }
            if (p_397230_.isClientSide) {
                p_397362_.openTestBlock(testblockentity);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void tick(BlockState p_397712_, ServerLevel p_397112_, BlockPos p_397466_, RandomSource p_397531_) {
        TestBlockEntity testblockentity = TestBlock.getServerTestBlockEntity(p_397112_, p_397466_);
        if (testblockentity != null) {
            testblockentity.reset();
        }
    }

    @Override
    protected void neighborChanged(BlockState p_397457_, Level p_397572_, BlockPos p_397104_, Block p_397813_, @Nullable Orientation p_397759_, boolean p_397459_) {
        TestBlockEntity testblockentity = TestBlock.getServerTestBlockEntity(p_397572_, p_397104_);
        if (testblockentity != null && testblockentity.getMode() != TestBlockMode.START) {
            boolean flag = p_397572_.hasNeighborSignal(p_397104_);
            boolean flag1 = testblockentity.isPowered();
            if (flag && !flag1) {
                testblockentity.setPowered(true);
                testblockentity.trigger();
            } else if (!flag && flag1) {
                testblockentity.setPowered(false);
            }
        }
    }

    @Nullable
    private static TestBlockEntity getServerTestBlockEntity(Level p_397380_, BlockPos p_397998_) {
        TestBlockEntity testblockentity;
        ServerLevel serverlevel;
        BlockEntity blockEntity;
        return p_397380_ instanceof ServerLevel && (blockEntity = (serverlevel = (ServerLevel)p_397380_).getBlockEntity(p_397998_)) instanceof TestBlockEntity ? (testblockentity = (TestBlockEntity)blockEntity) : null;
    }

    @Override
    public int getSignal(BlockState p_397637_, BlockGetter p_397297_, BlockPos p_397948_, Direction p_397493_) {
        if (p_397637_.getValue(MODE) != TestBlockMode.START) {
            return 0;
        }
        BlockEntity blockEntity = p_397297_.getBlockEntity(p_397948_);
        if (blockEntity instanceof TestBlockEntity) {
            TestBlockEntity testblockentity = (TestBlockEntity)blockEntity;
            return testblockentity.isPowered() ? 15 : 0;
        }
        return 0;
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader p_397697_, BlockPos p_397696_, BlockState p_397513_, boolean p_398035_) {
        ItemStack itemstack = super.getCloneItemStack(p_397697_, p_397696_, p_397513_, p_398035_);
        return TestBlock.setModeOnStack(itemstack, p_397513_.getValue(MODE));
    }

    public static ItemStack setModeOnStack(ItemStack p_396991_, TestBlockMode p_397281_) {
        p_396991_.set(DataComponents.BLOCK_STATE, p_396991_.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY).with(MODE, p_397281_));
        return p_396991_;
    }

    protected MapCodec<TestBlock> codec() {
        return CODEC;
    }
}

