/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.ItemLike;

public interface SuspiciousEffectHolder {
    public SuspiciousStewEffects getSuspiciousEffects();

    public static List<SuspiciousEffectHolder> getAllEffectHolders() {
        return BuiltInRegistries.ITEM.stream().map(SuspiciousEffectHolder::tryGet).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static SuspiciousEffectHolder tryGet(ItemLike p_259322_) {
        SuspiciousEffectHolder suspiciouseffectholder;
        BlockItem blockitem;
        FeatureElement featureElement = p_259322_.asItem();
        if (featureElement instanceof BlockItem && (featureElement = (blockitem = (BlockItem)featureElement).getBlock()) instanceof SuspiciousEffectHolder) {
            SuspiciousEffectHolder suspiciouseffectholder1 = (SuspiciousEffectHolder)((Object)featureElement);
            return suspiciouseffectholder1;
        }
        Item item = p_259322_.asItem();
        return item instanceof SuspiciousEffectHolder ? (suspiciouseffectholder = (SuspiciousEffectHolder)((Object)item)) : null;
    }
}

