/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SignBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.column(8.0, 0.0, 16.0);
    private final WoodType type;

    public SignBlock(WoodType p_56274_, BlockBehaviour.Properties p_56273_) {
        super(p_56273_);
        this.type = p_56274_;
    }

    protected abstract MapCodec<? extends SignBlock> codec();

    @Override
    protected BlockState updateShape(BlockState p_56285_, LevelReader p_374509_, ScheduledTickAccess p_374520_, BlockPos p_56289_, Direction p_56286_, BlockPos p_56290_, BlockState p_56287_, RandomSource p_374213_) {
        if (p_56285_.getValue(WATERLOGGED).booleanValue()) {
            p_374520_.scheduleTick(p_56289_, Fluids.WATER, Fluids.WATER.getTickDelay(p_374509_));
        }
        return super.updateShape(p_56285_, p_374509_, p_374520_, p_56289_, p_56286_, p_56290_, p_56287_, p_374213_);
    }

    @Override
    protected VoxelShape getShape(BlockState p_56293_, BlockGetter p_56294_, BlockPos p_56295_, CollisionContext p_56296_) {
        return SHAPE;
    }

    @Override
    public boolean isPossibleToRespawnInThis(BlockState p_279137_) {
        return true;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_154556_, BlockState p_154557_) {
        return new SignBlockEntity(p_154556_, p_154557_);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack p_316116_, BlockState p_316899_, Level p_316692_, BlockPos p_316578_, Player p_316244_, InteractionHand p_316196_, BlockHitResult p_316744_) {
        BlockEntity blockEntity = p_316692_.getBlockEntity(p_316578_);
        if (blockEntity instanceof SignBlockEntity) {
            boolean flag1;
            SignApplicator signapplicator;
            SignBlockEntity signblockentity = (SignBlockEntity)blockEntity;
            Item item = p_316116_.getItem();
            SignApplicator signapplicator1 = item instanceof SignApplicator ? (signapplicator = (SignApplicator)((Object)item)) : null;
            boolean bl = flag1 = signapplicator1 != null && p_316244_.mayBuild();
            if (p_316692_ instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)p_316692_;
                if (flag1 && !signblockentity.isWaxed() && !this.otherPlayerIsEditingSign(p_316244_, signblockentity)) {
                    boolean flag = signblockentity.isFacingFrontText(p_316244_);
                    if (signapplicator1.canApplyToSign(signblockentity.getText(flag), p_316244_) && signapplicator1.tryApplyToSign(serverlevel, signblockentity, flag, p_316244_)) {
                        signblockentity.executeClickCommandsIfPresent(serverlevel, p_316244_, p_316578_, flag);
                        p_316244_.awardStat(Stats.ITEM_USED.get(p_316116_.getItem()));
                        serverlevel.gameEvent(GameEvent.BLOCK_CHANGE, signblockentity.getBlockPos(), GameEvent.Context.of(p_316244_, signblockentity.getBlockState()));
                        p_316116_.consume(1, p_316244_);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            return !flag1 && !signblockentity.isWaxed() ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_316779_, Level p_316615_, BlockPos p_316127_, Player p_316173_, BlockHitResult p_316850_) {
        BlockEntity blockEntity = p_316615_.getBlockEntity(p_316127_);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity signblockentity = (SignBlockEntity)blockEntity;
            if (p_316615_ instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)p_316615_;
                boolean $$9 = signblockentity.isFacingFrontText(p_316173_);
                boolean $$10 = signblockentity.executeClickCommandsIfPresent(serverlevel, p_316173_, p_316127_, $$9);
                if (signblockentity.isWaxed()) {
                    serverlevel.playSound(null, signblockentity.getBlockPos(), signblockentity.getSignInteractionFailedSoundEvent(), SoundSource.BLOCKS);
                    return InteractionResult.SUCCESS_SERVER;
                }
                if ($$10) {
                    return InteractionResult.SUCCESS_SERVER;
                }
                if (!this.otherPlayerIsEditingSign(p_316173_, signblockentity) && p_316173_.mayBuild() && this.hasEditableText(p_316173_, signblockentity, $$9)) {
                    this.openTextEdit(p_316173_, signblockentity, $$9);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.PASS;
            }
            Util.pauseInIde(new IllegalStateException("Expected to only call this on server"));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private boolean hasEditableText(Player p_279394_, SignBlockEntity p_279187_, boolean p_279225_) {
        SignText signtext = p_279187_.getText(p_279225_);
        return Arrays.stream(signtext.getMessages(p_279394_.isTextFilteringEnabled())).allMatch(p_339537_ -> p_339537_.equals(CommonComponents.EMPTY) || p_339537_.getContents() instanceof PlainTextContents);
    }

    public abstract float getYRotationDegrees(BlockState var1);

    public Vec3 getSignHitboxCenterPosition(BlockState p_278294_) {
        return new Vec3(0.5, 0.5, 0.5);
    }

    @Override
    protected FluidState getFluidState(BlockState p_56299_) {
        return p_56299_.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_56299_);
    }

    public WoodType type() {
        return this.type;
    }

    public static WoodType getWoodType(Block p_251096_) {
        WoodType woodtype = p_251096_ instanceof SignBlock ? ((SignBlock)p_251096_).type() : WoodType.OAK;
        return woodtype;
    }

    public void openTextEdit(Player p_277738_, SignBlockEntity p_277467_, boolean p_277771_) {
        p_277467_.setAllowedPlayerEditor(p_277738_.getUUID());
        p_277738_.openTextEdit(p_277467_, p_277771_);
    }

    private boolean otherPlayerIsEditingSign(Player p_277952_, SignBlockEntity p_277599_) {
        UUID uuid = p_277599_.getPlayerWhoMayEdit();
        return uuid != null && !uuid.equals(p_277952_.getUUID());
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_277367_, BlockState p_277896_, BlockEntityType<T> p_277724_) {
        return SignBlock.createTickerHelper(p_277724_, BlockEntityType.SIGN, SignBlockEntity::tick);
    }
}

