/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SculkSpreader {
    public static final int MAX_GROWTH_RATE_RADIUS = 24;
    public static final int MAX_CHARGE = 1000;
    public static final float MAX_DECAY_FACTOR = 0.5f;
    private static final int MAX_CURSORS = 32;
    public static final int SHRIEKER_PLACEMENT_RATE = 11;
    public static final int MAX_CURSOR_DISTANCE = 1024;
    final boolean isWorldGeneration;
    private final TagKey<Block> replaceableBlocks;
    private final int growthSpawnCost;
    private final int noGrowthRadius;
    private final int chargeDecayRate;
    private final int additionalDecayRate;
    private List<ChargeCursor> cursors = new ArrayList<ChargeCursor>();

    public SculkSpreader(boolean p_222248_, TagKey<Block> p_222249_, int p_222250_, int p_222251_, int p_222252_, int p_222253_) {
        this.isWorldGeneration = p_222248_;
        this.replaceableBlocks = p_222249_;
        this.growthSpawnCost = p_222250_;
        this.noGrowthRadius = p_222251_;
        this.chargeDecayRate = p_222252_;
        this.additionalDecayRate = p_222253_;
    }

    public static SculkSpreader createLevelSpreader() {
        return new SculkSpreader(false, BlockTags.SCULK_REPLACEABLE, 10, 4, 10, 5);
    }

    public static SculkSpreader createWorldGenSpreader() {
        return new SculkSpreader(true, BlockTags.SCULK_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public TagKey<Block> replaceableBlocks() {
        return this.replaceableBlocks;
    }

    public int growthSpawnCost() {
        return this.growthSpawnCost;
    }

    public int noGrowthRadius() {
        return this.noGrowthRadius;
    }

    public int chargeDecayRate() {
        return this.chargeDecayRate;
    }

    public int additionalDecayRate() {
        return this.additionalDecayRate;
    }

    public boolean isWorldGeneration() {
        return this.isWorldGeneration;
    }

    @VisibleForTesting
    public List<ChargeCursor> getCursors() {
        return this.cursors;
    }

    public void clear() {
        this.cursors.clear();
    }

    public void load(ValueInput p_421893_) {
        this.cursors.clear();
        p_421893_.read("cursors", ChargeCursor.CODEC.sizeLimitedListOf(32)).orElse(List.of()).forEach(this::addCursor);
    }

    public void save(ValueOutput p_422716_) {
        p_422716_.store("cursors", ChargeCursor.CODEC.listOf(), this.cursors);
    }

    public void addCursors(BlockPos p_222267_, int p_222268_) {
        while (p_222268_ > 0) {
            int i = Math.min(p_222268_, 1000);
            this.addCursor(new ChargeCursor(p_222267_, i));
            p_222268_ -= i;
        }
    }

    private void addCursor(ChargeCursor p_222261_) {
        if (this.cursors.size() < 32) {
            this.cursors.add(p_222261_);
        }
    }

    public void updateCursors(LevelAccessor p_222256_, BlockPos p_222257_, RandomSource p_222258_, boolean p_222259_) {
        if (!this.cursors.isEmpty()) {
            ArrayList<ChargeCursor> list = new ArrayList<ChargeCursor>();
            HashMap<BlockPos, ChargeCursor> map = new HashMap<BlockPos, ChargeCursor>();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            for (ChargeCursor sculkspreader$chargecursor : this.cursors) {
                if (sculkspreader$chargecursor.isPosUnreasonable(p_222257_)) continue;
                sculkspreader$chargecursor.update(p_222256_, p_222257_, p_222258_, this, p_222259_);
                if (sculkspreader$chargecursor.charge <= 0) {
                    p_222256_.levelEvent(3006, sculkspreader$chargecursor.getPos(), 0);
                    continue;
                }
                BlockPos blockpos = sculkspreader$chargecursor.getPos();
                object2intmap.computeInt((Object)blockpos, (p_222264_, p_222265_) -> (p_222265_ == null ? 0 : p_222265_) + sculkspreader$chargecursor.charge);
                ChargeCursor sculkspreader$chargecursor1 = (ChargeCursor)map.get(blockpos);
                if (sculkspreader$chargecursor1 == null) {
                    map.put(blockpos, sculkspreader$chargecursor);
                    list.add(sculkspreader$chargecursor);
                    continue;
                }
                if (!this.isWorldGeneration() && sculkspreader$chargecursor.charge + sculkspreader$chargecursor1.charge <= 1000) {
                    sculkspreader$chargecursor1.mergeWith(sculkspreader$chargecursor);
                    continue;
                }
                list.add(sculkspreader$chargecursor);
                if (sculkspreader$chargecursor.charge >= sculkspreader$chargecursor1.charge) continue;
                map.put(blockpos, sculkspreader$chargecursor);
            }
            for (Object2IntMap.Entry entry : object2intmap.object2IntEntrySet()) {
                Set<Direction> collection;
                BlockPos blockpos1 = (BlockPos)entry.getKey();
                int k = entry.getIntValue();
                ChargeCursor sculkspreader$chargecursor2 = (ChargeCursor)map.get(blockpos1);
                Set<Direction> set = collection = sculkspreader$chargecursor2 == null ? null : sculkspreader$chargecursor2.getFacingData();
                if (k <= 0 || collection == null) continue;
                int i = (int)(Math.log1p(k) / (double)2.3f) + 1;
                int j = (i << 6) + MultifaceBlock.pack(collection);
                p_222256_.levelEvent(3006, blockpos1, j);
            }
            this.cursors = list;
        }
    }

    public static class ChargeCursor {
        private static final ObjectArrayList<Vec3i> NON_CORNER_NEIGHBOURS = Util.make(new ObjectArrayList(18), p_222338_ -> BlockPos.betweenClosedStream(new BlockPos(-1, -1, -1), new BlockPos(1, 1, 1)).filter(p_222336_ -> (p_222336_.getX() == 0 || p_222336_.getY() == 0 || p_222336_.getZ() == 0) && !p_222336_.equals(BlockPos.ZERO)).map(BlockPos::immutable).forEach(arg_0 -> ((ObjectArrayList)p_222338_).add(arg_0)));
        public static final int MAX_CURSOR_DECAY_DELAY = 1;
        private BlockPos pos;
        int charge;
        private int updateDelay;
        private int decayDelay;
        @Nullable
        private Set<Direction> facings;
        private static final Codec<Set<Direction>> DIRECTION_SET = Direction.CODEC.listOf().xmap(p_222340_ -> Sets.newEnumSet((Iterable)p_222340_, Direction.class), Lists::newArrayList);
        public static final Codec<ChargeCursor> CODEC = RecordCodecBuilder.create(p_222330_ -> p_222330_.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(ChargeCursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(ChargeCursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(ChargeCursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(p_222346_ -> p_222346_.updateDelay), (App)DIRECTION_SET.lenientOptionalFieldOf("facings").forGetter(p_222343_ -> Optional.ofNullable(p_222343_.getFacingData()))).apply((Applicative)p_222330_, ChargeCursor::new));

        private ChargeCursor(BlockPos p_222299_, int p_222300_, int p_222301_, int p_222302_, Optional<Set<Direction>> p_222303_) {
            this.pos = p_222299_;
            this.charge = p_222300_;
            this.decayDelay = p_222301_;
            this.updateDelay = p_222302_;
            this.facings = p_222303_.orElse(null);
        }

        public ChargeCursor(BlockPos p_222296_, int p_222297_) {
            this(p_222296_, p_222297_, 1, 0, Optional.empty());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        boolean isPosUnreasonable(BlockPos p_381739_) {
            return this.pos.distChessboard(p_381739_) > 1024;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        @Nullable
        public Set<Direction> getFacingData() {
            return this.facings;
        }

        private boolean shouldUpdate(LevelAccessor p_222326_, BlockPos p_222327_, boolean p_222328_) {
            boolean bl;
            if (this.charge <= 0) {
                return false;
            }
            if (p_222328_) {
                return true;
            }
            if (p_222326_ instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)p_222326_;
                bl = serverlevel.shouldTickBlocksAt(p_222327_);
            } else {
                bl = false;
            }
            return bl;
        }

        public void update(LevelAccessor p_222312_, BlockPos p_222313_, RandomSource p_222314_, SculkSpreader p_222315_, boolean p_222316_) {
            if (this.shouldUpdate(p_222312_, p_222313_, p_222315_.isWorldGeneration)) {
                if (this.updateDelay > 0) {
                    --this.updateDelay;
                } else {
                    BlockState blockstate = p_222312_.getBlockState(this.pos);
                    SculkBehaviour sculkbehaviour = ChargeCursor.getBlockBehaviour(blockstate);
                    if (p_222316_ && sculkbehaviour.attemptSpreadVein(p_222312_, this.pos, blockstate, this.facings, p_222315_.isWorldGeneration())) {
                        if (sculkbehaviour.canChangeBlockStateOnSpread()) {
                            blockstate = p_222312_.getBlockState(this.pos);
                            sculkbehaviour = ChargeCursor.getBlockBehaviour(blockstate);
                        }
                        p_222312_.playSound(null, this.pos, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    this.charge = sculkbehaviour.attemptUseCharge(this, p_222312_, p_222313_, p_222314_, p_222315_, p_222316_);
                    if (this.charge <= 0) {
                        sculkbehaviour.onDischarged(p_222312_, blockstate, this.pos, p_222314_);
                    } else {
                        BlockPos blockpos = ChargeCursor.getValidMovementPos(p_222312_, this.pos, p_222314_);
                        if (blockpos != null) {
                            sculkbehaviour.onDischarged(p_222312_, blockstate, this.pos, p_222314_);
                            this.pos = blockpos.immutable();
                            if (p_222315_.isWorldGeneration() && !this.pos.closerThan(new Vec3i(p_222313_.getX(), this.pos.getY(), p_222313_.getZ()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            blockstate = p_222312_.getBlockState(blockpos);
                        }
                        if (blockstate.getBlock() instanceof SculkBehaviour) {
                            this.facings = MultifaceBlock.availableFaces(blockstate);
                        }
                        this.decayDelay = sculkbehaviour.updateDecayDelay(this.decayDelay);
                        this.updateDelay = sculkbehaviour.getSculkSpreadDelay();
                    }
                }
            }
        }

        void mergeWith(ChargeCursor p_222332_) {
            this.charge += p_222332_.charge;
            p_222332_.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, p_222332_.updateDelay);
        }

        private static SculkBehaviour getBlockBehaviour(BlockState p_222334_) {
            SculkBehaviour sculkbehaviour;
            Block block = p_222334_.getBlock();
            return block instanceof SculkBehaviour ? (sculkbehaviour = (SculkBehaviour)((Object)block)) : SculkBehaviour.DEFAULT;
        }

        private static List<Vec3i> getRandomizedNonCornerNeighbourOffsets(RandomSource p_222306_) {
            return Util.shuffledCopy(NON_CORNER_NEIGHBOURS, p_222306_);
        }

        @Nullable
        private static BlockPos getValidMovementPos(LevelAccessor p_222308_, BlockPos p_222309_, RandomSource p_222310_) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_222309_.mutable();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = p_222309_.mutable();
            for (Vec3i vec3i : ChargeCursor.getRandomizedNonCornerNeighbourOffsets(p_222310_)) {
                blockpos$mutableblockpos1.setWithOffset((Vec3i)p_222309_, vec3i);
                BlockState blockstate = p_222308_.getBlockState(blockpos$mutableblockpos1);
                if (!(blockstate.getBlock() instanceof SculkBehaviour) || !ChargeCursor.isMovementUnobstructed(p_222308_, p_222309_, blockpos$mutableblockpos1)) continue;
                blockpos$mutableblockpos.set(blockpos$mutableblockpos1);
                if (!SculkVeinBlock.hasSubstrateAccess(p_222308_, blockstate, blockpos$mutableblockpos1)) continue;
                break;
            }
            return blockpos$mutableblockpos.equals(p_222309_) ? null : blockpos$mutableblockpos;
        }

        private static boolean isMovementUnobstructed(LevelAccessor p_222318_, BlockPos p_222319_, BlockPos p_222320_) {
            if (p_222319_.distManhattan(p_222320_) == 1) {
                return true;
            }
            BlockPos blockpos = p_222320_.subtract(p_222319_);
            Direction direction = Direction.fromAxisAndDirection(Direction.Axis.X, blockpos.getX() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
            Direction direction1 = Direction.fromAxisAndDirection(Direction.Axis.Y, blockpos.getY() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
            Direction direction2 = Direction.fromAxisAndDirection(Direction.Axis.Z, blockpos.getZ() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
            if (blockpos.getX() == 0) {
                return ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction1) || ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction2);
            }
            return blockpos.getY() == 0 ? ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction) || ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction2) : ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction) || ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction1);
        }

        private static boolean isUnobstructed(LevelAccessor p_222322_, BlockPos p_222323_, Direction p_222324_) {
            BlockPos blockpos = p_222323_.relative(p_222324_);
            return !p_222322_.getBlockState(blockpos).isFaceSturdy(p_222322_, blockpos, p_222324_.getOpposite());
        }
    }
}

