/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.math.OctahedralGroup;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;

public enum Rotation implements StringRepresentable
{
    NONE(0, "none", OctahedralGroup.IDENTITY),
    CLOCKWISE_90(1, "clockwise_90", OctahedralGroup.ROT_90_Y_NEG),
    CLOCKWISE_180(2, "180", OctahedralGroup.ROT_180_FACE_XZ),
    COUNTERCLOCKWISE_90(3, "counterclockwise_90", OctahedralGroup.ROT_90_Y_POS);

    public static final IntFunction<Rotation> BY_ID;
    public static final Codec<Rotation> CODEC;
    public static final StreamCodec<ByteBuf, Rotation> STREAM_CODEC;
    @Deprecated
    public static final Codec<Rotation> LEGACY_CODEC;
    private final int index;
    private final String id;
    private final OctahedralGroup rotation;

    private Rotation(int p_397622_, String p_221988_, OctahedralGroup p_221989_) {
        this.index = p_397622_;
        this.id = p_221988_;
        this.rotation = p_221989_;
    }

    public Rotation getRotated(Rotation p_55953_) {
        return switch (p_55953_.ordinal()) {
            case 1 -> {
                switch (this.ordinal()) {
                    case 0: {
                        yield CLOCKWISE_90;
                    }
                    case 1: {
                        yield CLOCKWISE_180;
                    }
                    case 2: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 3: {
                        yield NONE;
                    }
                }
                throw new MatchException(null, null);
            }
            case 2 -> {
                switch (this.ordinal()) {
                    case 0: {
                        yield CLOCKWISE_180;
                    }
                    case 1: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 2: {
                        yield NONE;
                    }
                    case 3: {
                        yield CLOCKWISE_90;
                    }
                }
                throw new MatchException(null, null);
            }
            case 3 -> {
                switch (this.ordinal()) {
                    case 0: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 1: {
                        yield NONE;
                    }
                    case 2: {
                        yield CLOCKWISE_90;
                    }
                    case 3: {
                        yield CLOCKWISE_180;
                    }
                }
                throw new MatchException(null, null);
            }
            default -> this;
        };
    }

    public OctahedralGroup rotation() {
        return this.rotation;
    }

    public Direction rotate(Direction p_55955_) {
        if (p_55955_.getAxis() == Direction.Axis.Y) {
            return p_55955_;
        }
        return switch (this.ordinal()) {
            case 1 -> p_55955_.getClockWise();
            case 2 -> p_55955_.getOpposite();
            case 3 -> p_55955_.getCounterClockWise();
            default -> p_55955_;
        };
    }

    public int rotate(int p_55950_, int p_55951_) {
        return switch (this.ordinal()) {
            case 1 -> (p_55950_ + p_55951_ / 4) % p_55951_;
            case 2 -> (p_55950_ + p_55951_ / 2) % p_55951_;
            case 3 -> (p_55950_ + p_55951_ * 3 / 4) % p_55951_;
            default -> p_55950_;
        };
    }

    public static Rotation getRandom(RandomSource p_221991_) {
        return Util.getRandom(Rotation.values(), p_221991_);
    }

    public static List<Rotation> getShuffled(RandomSource p_221993_) {
        return Util.shuffledCopy(Rotation.values(), p_221993_);
    }

    @Override
    public String getSerializedName() {
        return this.id;
    }

    private int getIndex() {
        return this.index;
    }

    static {
        BY_ID = ByIdMap.continuous(Rotation::getIndex, Rotation.values(), ByIdMap.OutOfBoundsStrategy.WRAP);
        CODEC = StringRepresentable.fromEnum(Rotation::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Rotation::getIndex);
        LEGACY_CODEC = ExtraCodecs.legacyEnum(Rotation::valueOf);
    }
}

