/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class MangroveRootsBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<MangroveRootsBlock> CODEC = MangroveRootsBlock.simpleCodec(MangroveRootsBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public MapCodec<MangroveRootsBlock> codec() {
        return CODEC;
    }

    public MangroveRootsBlock(BlockBehaviour.Properties p_221506_) {
        super(p_221506_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(WATERLOGGED, false));
    }

    @Override
    protected boolean skipRendering(BlockState p_221510_, BlockState p_221511_, Direction p_221512_) {
        return p_221511_.is(Blocks.MANGROVE_ROOTS) && p_221512_.getAxis() == Direction.Axis.Y;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_221508_) {
        FluidState fluidstate = p_221508_.getLevel().getFluidState(p_221508_.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(p_221508_).setValue(WATERLOGGED, flag);
    }

    @Override
    protected BlockState updateShape(BlockState p_221514_, LevelReader p_374345_, ScheduledTickAccess p_374139_, BlockPos p_221518_, Direction p_221515_, BlockPos p_221519_, BlockState p_221516_, RandomSource p_374100_) {
        if (p_221514_.getValue(WATERLOGGED).booleanValue()) {
            p_374139_.scheduleTick(p_221518_, Fluids.WATER, Fluids.WATER.getTickDelay(p_374345_));
        }
        return super.updateShape(p_221514_, p_374345_, p_374139_, p_221518_, p_221515_, p_221519_, p_221516_, p_374100_);
    }

    @Override
    protected FluidState getFluidState(BlockState p_221523_) {
        return p_221523_.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_221523_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_221521_) {
        p_221521_.add(WATERLOGGED);
    }
}

