/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LeverBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final MapCodec<LeverBlock> CODEC = LeverBlock.simpleCodec(LeverBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<LeverBlock> codec() {
        return CODEC;
    }

    public LeverBlock(BlockBehaviour.Properties p_54633_) {
        super(p_54633_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(FACE, AttachFace.WALL));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        Map<AttachFace, Map<Direction, VoxelShape>> map = Shapes.rotateAttachFace(Block.boxZ(6.0, 8.0, 10.0, 16.0));
        return this.getShapeForEachState(p_394076_ -> (VoxelShape)((Map)map.get(p_394076_.getValue(FACE))).get(p_394076_.getValue(FACING)), POWERED);
    }

    @Override
    protected VoxelShape getShape(BlockState p_54665_, BlockGetter p_54666_, BlockPos p_54667_, CollisionContext p_54668_) {
        return this.shapes.apply(p_54665_);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_54640_, Level p_54641_, BlockPos p_54642_, Player p_54643_, BlockHitResult p_54645_) {
        if (p_54641_.isClientSide) {
            BlockState blockstate = (BlockState)p_54640_.cycle(POWERED);
            if (blockstate.getValue(POWERED).booleanValue()) {
                LeverBlock.makeParticle(blockstate, p_54641_, p_54642_, 1.0f);
            }
        } else {
            this.pull(p_54640_, p_54641_, p_54642_, null);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(BlockState p_312405_, ServerLevel p_361347_, BlockPos p_311795_, Explosion p_312090_, BiConsumer<ItemStack, BlockPos> p_312313_) {
        if (p_312090_.canTriggerBlocks()) {
            this.pull(p_312405_, p_361347_, p_311795_, null);
        }
        super.onExplosionHit(p_312405_, p_361347_, p_311795_, p_312090_, p_312313_);
    }

    public void pull(BlockState p_54677_, Level p_54678_, BlockPos p_54679_, @Nullable Player p_344918_) {
        p_54677_ = (BlockState)p_54677_.cycle(POWERED);
        p_54678_.setBlock(p_54679_, p_54677_, 3);
        this.updateNeighbours(p_54677_, p_54678_, p_54679_);
        LeverBlock.playSound(p_344918_, p_54678_, p_54679_, p_54677_);
        p_54678_.gameEvent(p_344918_, p_54677_.getValue(POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, p_54679_);
    }

    protected static void playSound(@Nullable Player p_346119_, LevelAccessor p_346020_, BlockPos p_345585_, BlockState p_346002_) {
        float f = p_346002_.getValue(POWERED) != false ? 0.6f : 0.5f;
        p_346020_.playSound(p_346119_, p_345585_, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, f);
    }

    private static void makeParticle(BlockState p_54658_, LevelAccessor p_54659_, BlockPos p_54660_, float p_54661_) {
        Direction direction = ((Direction)p_54658_.getValue(FACING)).getOpposite();
        Direction direction1 = LeverBlock.getConnectedDirection(p_54658_).getOpposite();
        double d0 = (double)p_54660_.getX() + 0.5 + 0.1 * (double)direction.getStepX() + 0.2 * (double)direction1.getStepX();
        double d1 = (double)p_54660_.getY() + 0.5 + 0.1 * (double)direction.getStepY() + 0.2 * (double)direction1.getStepY();
        double d2 = (double)p_54660_.getZ() + 0.5 + 0.1 * (double)direction.getStepZ() + 0.2 * (double)direction1.getStepZ();
        p_54659_.addParticle(new DustParticleOptions(0xFF0000, p_54661_), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    public void animateTick(BlockState p_221395_, Level p_221396_, BlockPos p_221397_, RandomSource p_221398_) {
        if (p_221395_.getValue(POWERED).booleanValue() && p_221398_.nextFloat() < 0.25f) {
            LeverBlock.makeParticle(p_221395_, p_221396_, p_221397_, 0.5f);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState p_394661_, ServerLevel p_394153_, BlockPos p_394342_, boolean p_393487_) {
        if (!p_393487_ && p_394661_.getValue(POWERED).booleanValue()) {
            this.updateNeighbours(p_394661_, p_394153_, p_394342_);
        }
    }

    @Override
    protected int getSignal(BlockState p_54635_, BlockGetter p_54636_, BlockPos p_54637_, Direction p_54638_) {
        return p_54635_.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState p_54670_, BlockGetter p_54671_, BlockPos p_54672_, Direction p_54673_) {
        return p_54670_.getValue(POWERED) != false && LeverBlock.getConnectedDirection(p_54670_) == p_54673_ ? 15 : 0;
    }

    @Override
    protected boolean isSignalSource(BlockState p_54675_) {
        return true;
    }

    private void updateNeighbours(BlockState p_54681_, Level p_54682_, BlockPos p_54683_) {
        Direction direction;
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(p_54682_, direction, (direction = LeverBlock.getConnectedDirection(p_54681_).getOpposite()).getAxis().isHorizontal() ? Direction.UP : (Direction)p_54681_.getValue(FACING));
        p_54682_.updateNeighborsAt(p_54683_, this, orientation);
        p_54682_.updateNeighborsAt(p_54683_.relative(direction), this, orientation);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54663_) {
        p_54663_.add(FACE, FACING, POWERED);
    }
}

