/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class CreakingHeartBlock
extends BaseEntityBlock {
    public static final MapCodec<CreakingHeartBlock> CODEC = CreakingHeartBlock.simpleCodec(CreakingHeartBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<CreakingHeartState> STATE = BlockStateProperties.CREAKING_HEART_STATE;
    public static final BooleanProperty NATURAL = BlockStateProperties.NATURAL;

    public MapCodec<CreakingHeartBlock> codec() {
        return CODEC;
    }

    public CreakingHeartBlock(BlockBehaviour.Properties p_380228_) {
        super(p_380228_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, Direction.Axis.Y)).setValue(STATE, CreakingHeartState.UPROOTED)).setValue(NATURAL, false));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_380178_, BlockState p_380317_) {
        return new CreakingHeartBlockEntity(p_380178_, p_380317_);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_379447_, BlockState p_379641_, BlockEntityType<T> p_380325_) {
        if (p_379447_.isClientSide) {
            return null;
        }
        return p_379641_.getValue(STATE) != CreakingHeartState.UPROOTED ? CreakingHeartBlock.createTickerHelper(p_380325_, BlockEntityType.CREAKING_HEART, CreakingHeartBlockEntity::serverTick) : null;
    }

    public static boolean isNaturalNight(Level p_380307_) {
        return p_380307_.isMoonVisible();
    }

    @Override
    public void animateTick(BlockState p_379556_, Level p_379594_, BlockPos p_379297_, RandomSource p_379301_) {
        if (CreakingHeartBlock.isNaturalNight(p_379594_) && p_379556_.getValue(STATE) != CreakingHeartState.UPROOTED && p_379301_.nextInt(16) == 0 && CreakingHeartBlock.isSurroundedByLogs(p_379594_, p_379297_)) {
            p_379594_.playLocalSound(p_379297_.getX(), p_379297_.getY(), p_379297_.getZ(), SoundEvents.CREAKING_HEART_IDLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected BlockState updateShape(BlockState p_379552_, LevelReader p_379446_, ScheduledTickAccess p_379318_, BlockPos p_379343_, Direction p_380340_, BlockPos p_380150_, BlockState p_379791_, RandomSource p_379888_) {
        p_379318_.scheduleTick(p_379343_, this, 1);
        return super.updateShape(p_379552_, p_379446_, p_379318_, p_379343_, p_380340_, p_380150_, p_379791_, p_379888_);
    }

    @Override
    protected void tick(BlockState p_394029_, ServerLevel p_394479_, BlockPos p_394306_, RandomSource p_393870_) {
        BlockState blockstate = CreakingHeartBlock.updateState(p_394029_, p_394479_, p_394306_);
        if (blockstate != p_394029_) {
            p_394479_.setBlock(p_394306_, blockstate, 3);
        }
    }

    private static BlockState updateState(BlockState p_380049_, Level p_393975_, BlockPos p_379599_) {
        boolean flag1;
        boolean flag = CreakingHeartBlock.hasRequiredLogs(p_380049_, p_393975_, p_379599_);
        boolean bl = flag1 = p_380049_.getValue(STATE) == CreakingHeartState.UPROOTED;
        return flag && flag1 ? (BlockState)p_380049_.setValue(STATE, CreakingHeartBlock.isNaturalNight(p_393975_) ? CreakingHeartState.AWAKE : CreakingHeartState.DORMANT) : p_380049_;
    }

    public static boolean hasRequiredLogs(BlockState p_379990_, LevelReader p_380123_, BlockPos p_380405_) {
        Direction.Axis direction$axis = p_379990_.getValue(AXIS);
        for (Direction direction : direction$axis.getDirections()) {
            BlockState blockstate = p_380123_.getBlockState(p_380405_.relative(direction));
            if (blockstate.is(BlockTags.PALE_OAK_LOGS) && blockstate.getValue(AXIS) == direction$axis) continue;
            return false;
        }
        return true;
    }

    private static boolean isSurroundedByLogs(LevelAccessor p_379444_, BlockPos p_380241_) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = p_380241_.relative(direction);
            BlockState blockstate = p_379444_.getBlockState(blockpos);
            if (blockstate.is(BlockTags.PALE_OAK_LOGS)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_379431_) {
        return CreakingHeartBlock.updateState((BlockState)this.defaultBlockState().setValue(AXIS, p_379431_.getClickedFace().getAxis()), p_379431_.getLevel(), p_379431_.getClickedPos());
    }

    @Override
    protected BlockState rotate(BlockState p_380251_, Rotation p_379529_) {
        return RotatedPillarBlock.rotatePillar(p_380251_, p_379529_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_379898_) {
        p_379898_.add(AXIS, STATE, NATURAL);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState p_393635_, ServerLevel p_394550_, BlockPos p_394080_, boolean p_394343_) {
        Containers.updateNeighboursAfterDestroy(p_393635_, p_394550_, p_394080_);
    }

    @Override
    protected void onExplosionHit(BlockState p_382935_, ServerLevel p_382804_, BlockPos p_383050_, Explosion p_383064_, BiConsumer<ItemStack, BlockPos> p_383124_) {
        BlockEntity blockEntity = p_382804_.getBlockEntity(p_383050_);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingheartblockentity = (CreakingHeartBlockEntity)blockEntity;
            if (p_383064_ instanceof ServerExplosion) {
                ServerExplosion serverexplosion = (ServerExplosion)p_383064_;
                if (p_383064_.getBlockInteraction().shouldAffectBlocklikeEntities()) {
                    creakingheartblockentity.removeProtector(serverexplosion.getDamageSource());
                    LivingEntity livingEntity = p_383064_.getIndirectSourceEntity();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        if (p_383064_.getBlockInteraction().shouldAffectBlocklikeEntities()) {
                            this.tryAwardExperience(player, p_382935_, p_382804_, p_383050_);
                        }
                    }
                }
            }
        }
        super.onExplosionHit(p_382935_, p_382804_, p_383050_, p_383064_, p_383124_);
    }

    @Override
    public BlockState playerWillDestroy(Level p_380319_, BlockPos p_379939_, BlockState p_379928_, Player p_380097_) {
        BlockEntity blockEntity = p_380319_.getBlockEntity(p_379939_);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingheartblockentity = (CreakingHeartBlockEntity)blockEntity;
            creakingheartblockentity.removeProtector(p_380097_.damageSources().playerAttack(p_380097_));
            this.tryAwardExperience(p_380097_, p_379928_, p_380319_, p_379939_);
        }
        return super.playerWillDestroy(p_380319_, p_379939_, p_379928_, p_380097_);
    }

    private void tryAwardExperience(Player p_386796_, BlockState p_382970_, Level p_383065_, BlockPos p_382941_) {
        if (!p_386796_.preventsBlockDrops() && !p_386796_.isSpectator() && p_382970_.getValue(NATURAL).booleanValue() && p_383065_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_383065_;
            this.popExperience(serverlevel, p_382941_, p_383065_.random.nextIntBetweenInclusive(20, 24));
        }
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState p_380993_) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState p_381152_, Level p_381142_, BlockPos p_381148_) {
        int n;
        if (p_381152_.getValue(STATE) == CreakingHeartState.UPROOTED) {
            return 0;
        }
        BlockEntity blockEntity = p_381142_.getBlockEntity(p_381148_);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingheartblockentity = (CreakingHeartBlockEntity)blockEntity;
            n = creakingheartblockentity.getAnalogOutputSignal();
        } else {
            n = 0;
        }
        return n;
    }
}

