/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class ChiseledBookShelfBlock
extends BaseEntityBlock {
    public static final MapCodec<ChiseledBookShelfBlock> CODEC = ChiseledBookShelfBlock.simpleCodec(ChiseledBookShelfBlock::new);
    private static final int MAX_BOOKS_IN_STORAGE = 6;
    public static final int BOOKS_PER_ROW = 3;
    public static final List<BooleanProperty> SLOT_OCCUPIED_PROPERTIES = List.of(BlockStateProperties.CHISELED_BOOKSHELF_SLOT_0_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_1_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_2_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_3_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_4_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_5_OCCUPIED);

    public MapCodec<ChiseledBookShelfBlock> codec() {
        return CODEC;
    }

    public ChiseledBookShelfBlock(BlockBehaviour.Properties p_249989_) {
        super(p_249989_);
        BlockState blockstate = (BlockState)((BlockState)this.stateDefinition.any()).setValue(HorizontalDirectionalBlock.FACING, Direction.NORTH);
        for (BooleanProperty booleanproperty : SLOT_OCCUPIED_PROPERTIES) {
            blockstate = (BlockState)blockstate.setValue(booleanproperty, false);
        }
        this.registerDefaultState(blockstate);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack p_316457_, BlockState p_316201_, Level p_316747_, BlockPos p_316462_, Player p_316228_, InteractionHand p_316721_, BlockHitResult p_316464_) {
        BlockEntity blockEntity = p_316747_.getBlockEntity(p_316462_);
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledbookshelfblockentity = (ChiseledBookShelfBlockEntity)blockEntity;
            if (!p_316457_.is(ItemTags.BOOKSHELF_BOOKS)) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            OptionalInt optionalint = this.getHitSlot(p_316464_, p_316201_);
            if (optionalint.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (((Boolean)p_316201_.getValue(SLOT_OCCUPIED_PROPERTIES.get(optionalint.getAsInt()))).booleanValue()) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            ChiseledBookShelfBlock.addBook(p_316747_, p_316462_, p_316228_, chiseledbookshelfblockentity, p_316457_, optionalint.getAsInt());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_316403_, Level p_316842_, BlockPos p_316539_, Player p_316349_, BlockHitResult p_316278_) {
        BlockEntity blockEntity = p_316842_.getBlockEntity(p_316539_);
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledbookshelfblockentity = (ChiseledBookShelfBlockEntity)blockEntity;
            OptionalInt optionalint = this.getHitSlot(p_316278_, p_316403_);
            if (optionalint.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (!((Boolean)p_316403_.getValue(SLOT_OCCUPIED_PROPERTIES.get(optionalint.getAsInt()))).booleanValue()) {
                return InteractionResult.CONSUME;
            }
            ChiseledBookShelfBlock.removeBook(p_316842_, p_316539_, p_316349_, chiseledbookshelfblockentity, optionalint.getAsInt());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private OptionalInt getHitSlot(BlockHitResult p_316156_, BlockState p_316148_) {
        return ChiseledBookShelfBlock.getRelativeHitCoordinatesForBlockFace(p_316156_, p_316148_.getValue(HorizontalDirectionalBlock.FACING)).map(p_316073_ -> {
            int i = p_316073_.y >= 0.5f ? 0 : 1;
            int j = ChiseledBookShelfBlock.getSection(p_316073_.x);
            return OptionalInt.of(j + i * 3);
        }).orElseGet(OptionalInt::empty);
    }

    private static Optional<Vec2> getRelativeHitCoordinatesForBlockFace(BlockHitResult p_261714_, Direction p_262116_) {
        Direction direction = p_261714_.getDirection();
        if (p_262116_ != direction) {
            return Optional.empty();
        }
        BlockPos blockpos = p_261714_.getBlockPos().relative(direction);
        Vec3 vec3 = p_261714_.getLocation().subtract(blockpos.getX(), blockpos.getY(), blockpos.getZ());
        double d0 = vec3.x();
        double d1 = vec3.y();
        double d2 = vec3.z();
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - d0), (float)d1));
            case Direction.SOUTH -> Optional.of(new Vec2((float)d0, (float)d1));
            case Direction.WEST -> Optional.of(new Vec2((float)d2, (float)d1));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - d2), (float)d1));
            case Direction.DOWN, Direction.UP -> Optional.empty();
        };
    }

    private static int getSection(float p_261599_) {
        float f = 0.0625f;
        float f1 = 0.375f;
        if (p_261599_ < 0.375f) {
            return 0;
        }
        float f2 = 0.6875f;
        return p_261599_ < 0.6875f ? 1 : 2;
    }

    private static void addBook(Level p_262592_, BlockPos p_262669_, Player p_262572_, ChiseledBookShelfBlockEntity p_262606_, ItemStack p_262587_, int p_262692_) {
        if (!p_262592_.isClientSide) {
            p_262572_.awardStat(Stats.ITEM_USED.get(p_262587_.getItem()));
            SoundEvent soundevent = p_262587_.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_INSERT_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_INSERT;
            p_262606_.setItem(p_262692_, p_262587_.consumeAndReturn(1, p_262572_));
            p_262592_.playSound(null, p_262669_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void removeBook(Level p_262654_, BlockPos p_262601_, Player p_262636_, ChiseledBookShelfBlockEntity p_262605_, int p_262673_) {
        if (!p_262654_.isClientSide) {
            ItemStack itemstack = p_262605_.removeItem(p_262673_, 1);
            SoundEvent soundevent = itemstack.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_PICKUP_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_PICKUP;
            p_262654_.playSound(null, p_262601_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!p_262636_.getInventory().add(itemstack)) {
                p_262636_.drop(itemstack, false);
            }
            p_262654_.gameEvent(p_262636_, GameEvent.BLOCK_CHANGE, p_262601_);
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_250440_, BlockState p_248729_) {
        return new ChiseledBookShelfBlockEntity(p_250440_, p_248729_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_250973_) {
        p_250973_.add(HorizontalDirectionalBlock.FACING);
        SLOT_OCCUPIED_PROPERTIES.forEach(p_261456_ -> p_250973_.add((Property<?>)p_261456_));
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState p_394006_, ServerLevel p_394108_, BlockPos p_394432_, boolean p_393697_) {
        Containers.updateNeighboursAfterDestroy(p_394006_, p_394108_, p_394432_);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_251318_) {
        return (BlockState)this.defaultBlockState().setValue(HorizontalDirectionalBlock.FACING, p_251318_.getHorizontalDirection().getOpposite());
    }

    @Override
    public BlockState rotate(BlockState p_288975_, Rotation p_288993_) {
        return (BlockState)p_288975_.setValue(HorizontalDirectionalBlock.FACING, p_288993_.rotate(p_288975_.getValue(HorizontalDirectionalBlock.FACING)));
    }

    @Override
    public BlockState mirror(BlockState p_289000_, Mirror p_288962_) {
        return p_289000_.rotate(p_288962_.getRotation(p_289000_.getValue(HorizontalDirectionalBlock.FACING)));
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState p_249302_) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState p_249192_, Level p_252207_, BlockPos p_248999_) {
        int n;
        if (p_252207_.isClientSide()) {
            return 0;
        }
        BlockEntity blockEntity = p_252207_.getBlockEntity(p_248999_);
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledbookshelfblockentity = (ChiseledBookShelfBlockEntity)blockEntity;
            n = chiseledbookshelfblockentity.getLastInteractedSlot() + 1;
        } else {
            n = 0;
        }
        return n;
    }
}

