/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.Graph;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public class FeatureSorter {
    public static <T> List<StepFeatureData> buildFeaturesPerStep(List<T> p_220604_, Function<T, List<HolderSet<PlacedFeature>>> p_220605_, boolean p_220606_) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        MutableInt mutableint = new MutableInt(0);
        record FeatureData(int featureIndex, int step, PlacedFeature feature) {
        }
        Comparator<FeatureData> comparator = Comparator.comparingInt(FeatureData::step).thenComparingInt(FeatureData::featureIndex);
        TreeMap<FeatureData, Set> map = new TreeMap<FeatureData, Set>(comparator);
        int i = 0;
        for (T t : p_220604_) {
            ArrayList list = Lists.newArrayList();
            List<HolderSet<PlacedFeature>> list1 = p_220605_.apply(t);
            i = Math.max(i, list1.size());
            for (int j = 0; j < list1.size(); ++j) {
                for (Holder holder : (HolderSet)list1.get(j)) {
                    PlacedFeature placedfeature = (PlacedFeature)holder.value();
                    list.add(new FeatureData(object2intmap.computeIfAbsent((Object)placedfeature, p_220609_ -> mutableint.getAndIncrement()), j, placedfeature));
                }
            }
            for (int k = 0; k < list.size(); ++k) {
                Set set2 = map.computeIfAbsent((FeatureData)list.get(k), p_220602_ -> new TreeSet(comparator));
                if (k >= list.size() - 1) continue;
                set2.add((FeatureData)list.get(k + 1));
            }
        }
        TreeSet<FeatureData> set = new TreeSet<FeatureData>(comparator);
        TreeSet<FeatureData> set1 = new TreeSet<FeatureData>(comparator);
        ArrayList list2 = Lists.newArrayList();
        for (FeatureData featuresorter$1featuredata : map.keySet()) {
            int j1;
            if (!set1.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if (set.contains(featuresorter$1featuredata)) continue;
            if (!Graph.depthFirstSearch(map, set, set1, list2::add, featuresorter$1featuredata)) continue;
            if (!p_220606_) {
                throw new IllegalStateException("Feature order cycle found");
            }
            ArrayList<T> list3 = new ArrayList<T>(p_220604_);
            do {
                j1 = list3.size();
                ListIterator listiterator = list3.listIterator();
                while (listiterator.hasNext()) {
                    Object t1 = listiterator.next();
                    listiterator.remove();
                    try {
                        FeatureSorter.buildFeaturesPerStep(list3, p_220605_, false);
                    }
                    catch (IllegalStateException illegalstateexception) {
                        continue;
                    }
                    listiterator.add(t1);
                }
            } while (j1 != list3.size());
            throw new IllegalStateException("Feature order cycle found, involved sources: " + String.valueOf(list3));
        }
        Collections.reverse(list2);
        ImmutableList.Builder builder = ImmutableList.builder();
        int l = 0;
        while (l < i) {
            int i1 = l++;
            List<PlacedFeature> list4 = list2.stream().filter(p_220599_ -> p_220599_.step() == i1).map(FeatureData::feature).collect(Collectors.toList());
            builder.add((Object)new StepFeatureData(list4));
        }
        return builder.build();
    }

    public record StepFeatureData(List<PlacedFeature> features, ToIntFunction<PlacedFeature> indexMapping) {
        StepFeatureData(List<PlacedFeature> p_220627_) {
            this(p_220627_, Util.createIndexIdentityLookup(p_220627_));
        }
    }
}

