/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public class Climate {
    private static final boolean DEBUG_SLOW_BIOME_SEARCH = false;
    private static final float QUANTIZATION_FACTOR = 10000.0f;
    @VisibleForTesting
    protected static final int PARAMETER_COUNT = 7;

    public static TargetPoint target(float p_186782_, float p_186783_, float p_186784_, float p_186785_, float p_186786_, float p_186787_) {
        return new TargetPoint(Climate.quantizeCoord(p_186782_), Climate.quantizeCoord(p_186783_), Climate.quantizeCoord(p_186784_), Climate.quantizeCoord(p_186785_), Climate.quantizeCoord(p_186786_), Climate.quantizeCoord(p_186787_));
    }

    public static ParameterPoint parameters(float p_186789_, float p_186790_, float p_186791_, float p_186792_, float p_186793_, float p_186794_, float p_186795_) {
        return new ParameterPoint(Parameter.point(p_186789_), Parameter.point(p_186790_), Parameter.point(p_186791_), Parameter.point(p_186792_), Parameter.point(p_186793_), Parameter.point(p_186794_), Climate.quantizeCoord(p_186795_));
    }

    public static ParameterPoint parameters(Parameter p_186799_, Parameter p_186800_, Parameter p_186801_, Parameter p_186802_, Parameter p_186803_, Parameter p_186804_, float p_186805_) {
        return new ParameterPoint(p_186799_, p_186800_, p_186801_, p_186802_, p_186803_, p_186804_, Climate.quantizeCoord(p_186805_));
    }

    public static long quantizeCoord(float p_186780_) {
        return (long)(p_186780_ * 10000.0f);
    }

    public static float unquantizeCoord(long p_186797_) {
        return (float)p_186797_ / 10000.0f;
    }

    public static Sampler empty() {
        DensityFunction densityfunction = DensityFunctions.zero();
        return new Sampler(densityfunction, densityfunction, densityfunction, densityfunction, densityfunction, densityfunction, List.of());
    }

    public static BlockPos findSpawnPosition(List<ParameterPoint> p_207843_, Sampler p_207844_) {
        return new SpawnFinder(p_207843_, (Sampler)p_207844_).result.location();
    }

    public record TargetPoint(long temperature, long humidity, long continentalness, long erosion, long depth, long weirdness) {
        @VisibleForTesting
        protected long[] toParameterArray() {
            return new long[]{this.temperature, this.humidity, this.continentalness, this.erosion, this.depth, this.weirdness, 0L};
        }
    }

    public record ParameterPoint(Parameter temperature, Parameter humidity, Parameter continentalness, Parameter erosion, Parameter depth, Parameter weirdness, long offset) {
        public static final Codec<ParameterPoint> CODEC = RecordCodecBuilder.create(p_186885_ -> p_186885_.group((App)Parameter.CODEC.fieldOf("temperature").forGetter(p_186905_ -> p_186905_.temperature), (App)Parameter.CODEC.fieldOf("humidity").forGetter(p_186902_ -> p_186902_.humidity), (App)Parameter.CODEC.fieldOf("continentalness").forGetter(p_186897_ -> p_186897_.continentalness), (App)Parameter.CODEC.fieldOf("erosion").forGetter(p_186894_ -> p_186894_.erosion), (App)Parameter.CODEC.fieldOf("depth").forGetter(p_186891_ -> p_186891_.depth), (App)Parameter.CODEC.fieldOf("weirdness").forGetter(p_186888_ -> p_186888_.weirdness), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").xmap(Climate::quantizeCoord, Climate::unquantizeCoord).forGetter(p_186881_ -> p_186881_.offset)).apply((Applicative)p_186885_, ParameterPoint::new));

        long fitness(TargetPoint p_186883_) {
            return Mth.square(this.temperature.distance(p_186883_.temperature)) + Mth.square(this.humidity.distance(p_186883_.humidity)) + Mth.square(this.continentalness.distance(p_186883_.continentalness)) + Mth.square(this.erosion.distance(p_186883_.erosion)) + Mth.square(this.depth.distance(p_186883_.depth)) + Mth.square(this.weirdness.distance(p_186883_.weirdness)) + Mth.square(this.offset);
        }

        protected List<Parameter> parameterSpace() {
            return ImmutableList.of((Object)this.temperature, (Object)this.humidity, (Object)this.continentalness, (Object)this.erosion, (Object)this.depth, (Object)this.weirdness, (Object)new Parameter(this.offset, this.offset));
        }
    }

    public record Parameter(long min, long max) {
        public static final Codec<Parameter> CODEC = ExtraCodecs.intervalCodec(Codec.floatRange((float)-2.0f, (float)2.0f), "min", "max", (p_275164_, p_275165_) -> p_275164_.compareTo((Float)p_275165_) > 0 ? DataResult.error(() -> "Cannon construct interval, min > max (" + p_275164_ + " > " + p_275165_ + ")") : DataResult.success((Object)new Parameter(Climate.quantizeCoord(p_275164_.floatValue()), Climate.quantizeCoord(p_275165_.floatValue()))), p_186841_ -> Float.valueOf(Climate.unquantizeCoord(p_186841_.min())), p_186839_ -> Float.valueOf(Climate.unquantizeCoord(p_186839_.max())));

        public static Parameter point(float p_186821_) {
            return Parameter.span(p_186821_, p_186821_);
        }

        public static Parameter span(float p_186823_, float p_186824_) {
            if (p_186823_ > p_186824_) {
                throw new IllegalArgumentException("min > max: " + p_186823_ + " " + p_186824_);
            }
            return new Parameter(Climate.quantizeCoord(p_186823_), Climate.quantizeCoord(p_186824_));
        }

        public static Parameter span(Parameter p_186830_, Parameter p_186831_) {
            if (p_186830_.min() > p_186831_.max()) {
                throw new IllegalArgumentException("min > max: " + String.valueOf(p_186830_) + " " + String.valueOf(p_186831_));
            }
            return new Parameter(p_186830_.min(), p_186831_.max());
        }

        @Override
        public String toString() {
            return this.min == this.max ? String.format(Locale.ROOT, "%d", this.min) : String.format(Locale.ROOT, "[%d-%d]", this.min, this.max);
        }

        public long distance(long p_186826_) {
            long i = p_186826_ - this.max;
            long j = this.min - p_186826_;
            return i > 0L ? i : Math.max(j, 0L);
        }

        public long distance(Parameter p_186828_) {
            long i = p_186828_.min() - this.max;
            long j = this.min - p_186828_.max();
            return i > 0L ? i : Math.max(j, 0L);
        }

        public Parameter span(@Nullable Parameter p_186837_) {
            return p_186837_ == null ? this : new Parameter(Math.min(this.min, p_186837_.min()), Math.max(this.max, p_186837_.max()));
        }
    }

    public record Sampler(DensityFunction temperature, DensityFunction humidity, DensityFunction continentalness, DensityFunction erosion, DensityFunction depth, DensityFunction weirdness, List<ParameterPoint> spawnTarget) {
        public TargetPoint sample(int p_186975_, int p_186976_, int p_186977_) {
            int i = QuartPos.toBlock(p_186975_);
            int j = QuartPos.toBlock(p_186976_);
            int k = QuartPos.toBlock(p_186977_);
            DensityFunction.SinglePointContext densityfunction$singlepointcontext = new DensityFunction.SinglePointContext(i, j, k);
            return Climate.target((float)this.temperature.compute(densityfunction$singlepointcontext), (float)this.humidity.compute(densityfunction$singlepointcontext), (float)this.continentalness.compute(densityfunction$singlepointcontext), (float)this.erosion.compute(densityfunction$singlepointcontext), (float)this.depth.compute(densityfunction$singlepointcontext), (float)this.weirdness.compute(densityfunction$singlepointcontext));
        }

        public BlockPos findSpawnPosition() {
            return this.spawnTarget.isEmpty() ? BlockPos.ZERO : Climate.findSpawnPosition(this.spawnTarget, this);
        }
    }

    static class SpawnFinder {
        private static final long MAX_RADIUS = 2048L;
        Result result;

        SpawnFinder(List<ParameterPoint> p_207872_, Sampler p_207873_) {
            this.result = SpawnFinder.getSpawnPositionAndFitness(p_207872_, p_207873_, 0, 0);
            this.radialSearch(p_207872_, p_207873_, 2048.0f, 512.0f);
            this.radialSearch(p_207872_, p_207873_, 512.0f, 32.0f);
        }

        private void radialSearch(List<ParameterPoint> p_207875_, Sampler p_207876_, float p_207877_, float p_207878_) {
            float f = 0.0f;
            float f1 = p_207878_;
            BlockPos blockpos = this.result.location();
            while (f1 <= p_207877_) {
                int j;
                int i = blockpos.getX() + (int)(Math.sin(f) * (double)f1);
                Result climate$spawnfinder$result = SpawnFinder.getSpawnPositionAndFitness(p_207875_, p_207876_, i, j = blockpos.getZ() + (int)(Math.cos(f) * (double)f1));
                if (climate$spawnfinder$result.fitness() < this.result.fitness()) {
                    this.result = climate$spawnfinder$result;
                }
                if (!((double)(f += p_207878_ / f1) > Math.PI * 2)) continue;
                f = 0.0f;
                f1 += p_207878_;
            }
        }

        private static Result getSpawnPositionAndFitness(List<ParameterPoint> p_207880_, Sampler p_207881_, int p_207882_, int p_207883_) {
            TargetPoint climate$targetpoint = p_207881_.sample(QuartPos.fromBlock(p_207882_), 0, QuartPos.fromBlock(p_207883_));
            TargetPoint climate$targetpoint1 = new TargetPoint(climate$targetpoint.temperature(), climate$targetpoint.humidity(), climate$targetpoint.continentalness(), climate$targetpoint.erosion(), 0L, climate$targetpoint.weirdness());
            long i = Long.MAX_VALUE;
            for (ParameterPoint climate$parameterpoint : p_207880_) {
                i = Math.min(i, climate$parameterpoint.fitness(climate$targetpoint1));
            }
            long k = Mth.square((long)p_207882_) + Mth.square((long)p_207883_);
            long j = i * Mth.square(2048L) + k;
            return new Result(new BlockPos(p_207882_, 0, p_207883_), j);
        }

        record Result(BlockPos location, long fitness) {
        }
    }

    protected static final class RTree<T> {
        private static final int CHILDREN_PER_NODE = 6;
        private final Node<T> root;
        private final ThreadLocal<Leaf<T>> lastResult = new ThreadLocal();

        private RTree(Node<T> p_186913_) {
            this.root = p_186913_;
        }

        public static <T> RTree<T> create(List<Pair<ParameterPoint, T>> p_186936_) {
            if (p_186936_.isEmpty()) {
                throw new IllegalArgumentException("Need at least one value to build the search tree.");
            }
            int i = ((ParameterPoint)p_186936_.get(0).getFirst()).parameterSpace().size();
            if (i != 7) {
                throw new IllegalStateException("Expecting parameter space to be 7, got " + i);
            }
            List list = p_186936_.stream().map(p_186934_ -> new Leaf<Object>((ParameterPoint)p_186934_.getFirst(), p_186934_.getSecond())).collect(Collectors.toCollection(ArrayList::new));
            return new RTree<T>(RTree.build(i, list));
        }

        private static <T> Node<T> build(int p_186921_, List<? extends Node<T>> p_186922_) {
            if (p_186922_.isEmpty()) {
                throw new IllegalStateException("Need at least one child to build a node");
            }
            if (p_186922_.size() == 1) {
                return p_186922_.get(0);
            }
            if (p_186922_.size() <= 6) {
                p_186922_.sort(Comparator.comparingLong(p_186916_ -> {
                    long i1 = 0L;
                    for (int j1 = 0; j1 < p_186921_; ++j1) {
                        Parameter climate$parameter = p_186916_.parameterSpace[j1];
                        i1 += Math.abs((climate$parameter.min() + climate$parameter.max()) / 2L);
                    }
                    return i1;
                }));
                return new SubTree(p_186922_);
            }
            long i = Long.MAX_VALUE;
            int j = -1;
            List<SubTree<T>> list = null;
            for (int k = 0; k < p_186921_; ++k) {
                RTree.sort(p_186922_, p_186921_, k, false);
                List<SubTree<T>> list1 = RTree.bucketize(p_186922_);
                long l = 0L;
                for (SubTree<T> subtree : list1) {
                    l += RTree.cost(subtree.parameterSpace);
                }
                if (i <= l) continue;
                i = l;
                j = k;
                list = list1;
            }
            RTree.sort(list, p_186921_, j, true);
            return new SubTree(list.stream().map(p_186919_ -> RTree.build(p_186921_, Arrays.asList(p_186919_.children))).collect(Collectors.toList()));
        }

        private static <T> void sort(List<? extends Node<T>> p_186938_, int p_186939_, int p_186940_, boolean p_186941_) {
            Comparator<Node<Node<T>>> comparator = RTree.comparator(p_186940_, p_186941_);
            for (int i = 1; i < p_186939_; ++i) {
                comparator = comparator.thenComparing(RTree.comparator((p_186940_ + i) % p_186939_, p_186941_));
            }
            p_186938_.sort(comparator);
        }

        private static <T> Comparator<Node<T>> comparator(int p_186924_, boolean p_186925_) {
            return Comparator.comparingLong(p_186929_ -> {
                Parameter climate$parameter = p_186929_.parameterSpace[p_186924_];
                long i = (climate$parameter.min() + climate$parameter.max()) / 2L;
                return p_186925_ ? Math.abs(i) : i;
            });
        }

        private static <T> List<SubTree<T>> bucketize(List<? extends Node<T>> p_186945_) {
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            int i = (int)Math.pow(6.0, Math.floor(Math.log((double)p_186945_.size() - 0.01) / Math.log(6.0)));
            for (Node<T> node : p_186945_) {
                list1.add(node);
                if (list1.size() < i) continue;
                list.add(new SubTree(list1));
                list1 = Lists.newArrayList();
            }
            if (!list1.isEmpty()) {
                list.add(new SubTree(list1));
            }
            return list;
        }

        private static long cost(Parameter[] p_186943_) {
            long i = 0L;
            for (Parameter climate$parameter : p_186943_) {
                i += Math.abs(climate$parameter.max() - climate$parameter.min());
            }
            return i;
        }

        static <T> List<Parameter> buildParameterSpace(List<? extends Node<T>> p_186947_) {
            if (p_186947_.isEmpty()) {
                throw new IllegalArgumentException("SubTree needs at least one child");
            }
            int i = 7;
            ArrayList list = Lists.newArrayList();
            for (int j = 0; j < 7; ++j) {
                list.add(null);
            }
            for (Node<T> node : p_186947_) {
                for (int k = 0; k < 7; ++k) {
                    list.set(k, node.parameterSpace[k].span((Parameter)list.get(k)));
                }
            }
            return list;
        }

        public T search(TargetPoint p_186931_, DistanceMetric<T> p_186932_) {
            long[] along = p_186931_.toParameterArray();
            Leaf<T> leaf = this.root.search(along, this.lastResult.get(), p_186932_);
            this.lastResult.set(leaf);
            return leaf.value;
        }

        static abstract class Node<T> {
            protected final Parameter[] parameterSpace;

            protected Node(List<Parameter> p_186958_) {
                this.parameterSpace = p_186958_.toArray(new Parameter[0]);
            }

            protected abstract Leaf<T> search(long[] var1, @Nullable Leaf<T> var2, DistanceMetric<T> var3);

            protected long distance(long[] p_186960_) {
                long i = 0L;
                for (int j = 0; j < 7; ++j) {
                    i += Mth.square(this.parameterSpace[j].distance(p_186960_[j]));
                }
                return i;
            }

            public String toString() {
                return Arrays.toString(this.parameterSpace);
            }
        }

        static final class SubTree<T>
        extends Node<T> {
            final Node<T>[] children;

            protected SubTree(List<? extends Node<T>> p_186967_) {
                this(RTree.buildParameterSpace(p_186967_), p_186967_);
            }

            protected SubTree(List<Parameter> p_186969_, List<? extends Node<T>> p_186970_) {
                super(p_186969_);
                this.children = p_186970_.toArray(new Node[0]);
            }

            @Override
            protected Leaf<T> search(long[] p_186972_, @Nullable Leaf<T> p_186973_, DistanceMetric<T> p_186974_) {
                long i = p_186973_ == null ? Long.MAX_VALUE : p_186974_.distance(p_186973_, p_186972_);
                Leaf<T> leaf = p_186973_;
                for (Node<T> node : this.children) {
                    long k;
                    long j = p_186974_.distance(node, p_186972_);
                    if (i <= j) continue;
                    Leaf<T> leaf1 = node.search(p_186972_, leaf, p_186974_);
                    long l = k = node == leaf1 ? j : p_186974_.distance(leaf1, p_186972_);
                    if (i <= k) continue;
                    i = k;
                    leaf = leaf1;
                }
                return leaf;
            }
        }

        static final class Leaf<T>
        extends Node<T> {
            final T value;

            Leaf(ParameterPoint p_186950_, T p_186951_) {
                super(p_186950_.parameterSpace());
                this.value = p_186951_;
            }

            @Override
            protected Leaf<T> search(long[] p_186953_, @Nullable Leaf<T> p_186954_, DistanceMetric<T> p_186955_) {
                return this;
            }
        }
    }

    public static class ParameterList<T> {
        private final List<Pair<ParameterPoint, T>> values;
        private final RTree<T> index;

        public static <T> Codec<ParameterList<T>> codec(MapCodec<T> p_275523_) {
            return ExtraCodecs.nonEmptyList(RecordCodecBuilder.create(p_275233_ -> p_275233_.group((App)ParameterPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)p_275523_.forGetter(Pair::getSecond)).apply((Applicative)p_275233_, Pair::of)).listOf()).xmap(ParameterList::new, ParameterList::values);
        }

        public ParameterList(List<Pair<ParameterPoint, T>> p_186849_) {
            this.values = p_186849_;
            this.index = RTree.create(p_186849_);
        }

        public List<Pair<ParameterPoint, T>> values() {
            return this.values;
        }

        public T findValue(TargetPoint p_204253_) {
            return this.findValueIndex(p_204253_);
        }

        @VisibleForTesting
        public T findValueBruteForce(TargetPoint p_204255_) {
            Iterator<Pair<ParameterPoint, T>> iterator = this.values().iterator();
            Pair<ParameterPoint, T> pair = iterator.next();
            long i = ((ParameterPoint)pair.getFirst()).fitness(p_204255_);
            Object t = pair.getSecond();
            while (iterator.hasNext()) {
                Pair<ParameterPoint, T> pair1 = iterator.next();
                long j = ((ParameterPoint)pair1.getFirst()).fitness(p_204255_);
                if (j >= i) continue;
                i = j;
                t = pair1.getSecond();
            }
            return (T)t;
        }

        public T findValueIndex(TargetPoint p_186852_) {
            return this.findValueIndex(p_186852_, RTree.Node::distance);
        }

        protected T findValueIndex(TargetPoint p_186854_, DistanceMetric<T> p_186855_) {
            return this.index.search(p_186854_, p_186855_);
        }
    }

    static interface DistanceMetric<T> {
        public long distance(RTree.Node<T> var1, long[] var2);
    }
}

