/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.level.LightLayer;

public record SpawnData(CompoundTag entityToSpawn, Optional<CustomSpawnRules> customSpawnRules, Optional<EquipmentTable> equipment) {
    public static final String ENTITY_TAG = "entity";
    public static final Codec<SpawnData> CODEC = RecordCodecBuilder.create(p_340790_ -> p_340790_.group((App)CompoundTag.CODEC.fieldOf(ENTITY_TAG).forGetter(p_186576_ -> p_186576_.entityToSpawn), (App)CustomSpawnRules.CODEC.optionalFieldOf("custom_spawn_rules").forGetter(p_186569_ -> p_186569_.customSpawnRules), (App)EquipmentTable.CODEC.optionalFieldOf("equipment").forGetter(p_340789_ -> p_340789_.equipment)).apply((Applicative)p_340790_, SpawnData::new));
    public static final Codec<WeightedList<SpawnData>> LIST_CODEC = WeightedList.codec(CODEC);

    public SpawnData() {
        this(new CompoundTag(), Optional.empty(), Optional.empty());
    }

    public SpawnData {
        Optional<ResourceLocation> optional = entityToSpawn.read("id", ResourceLocation.CODEC);
        if (optional.isPresent()) {
            entityToSpawn.store("id", ResourceLocation.CODEC, optional.get());
        } else {
            entityToSpawn.remove("id");
        }
    }

    public CompoundTag getEntityToSpawn() {
        return this.entityToSpawn;
    }

    public Optional<CustomSpawnRules> getCustomSpawnRules() {
        return this.customSpawnRules;
    }

    public Optional<EquipmentTable> getEquipment() {
        return this.equipment;
    }

    public record CustomSpawnRules(InclusiveRange<Integer> blockLightLimit, InclusiveRange<Integer> skyLightLimit) {
        private static final InclusiveRange<Integer> LIGHT_RANGE = new InclusiveRange<Integer>(0, 15);
        public static final Codec<CustomSpawnRules> CODEC = RecordCodecBuilder.create(p_286217_ -> p_286217_.group((App)CustomSpawnRules.lightLimit("block_light_limit").forGetter(p_186600_ -> p_186600_.blockLightLimit), (App)CustomSpawnRules.lightLimit("sky_light_limit").forGetter(p_186595_ -> p_186595_.skyLightLimit)).apply((Applicative)p_286217_, CustomSpawnRules::new));

        private static DataResult<InclusiveRange<Integer>> checkLightBoundaries(InclusiveRange<Integer> p_186593_) {
            return !LIGHT_RANGE.contains(p_186593_) ? DataResult.error(() -> "Light values must be withing range " + String.valueOf(LIGHT_RANGE)) : DataResult.success(p_186593_);
        }

        private static MapCodec<InclusiveRange<Integer>> lightLimit(String p_286409_) {
            return InclusiveRange.INT.lenientOptionalFieldOf(p_286409_, LIGHT_RANGE).validate(CustomSpawnRules::checkLightBoundaries);
        }

        public boolean isValidPosition(BlockPos p_321770_, ServerLevel p_321818_) {
            return this.blockLightLimit.isValueInRange(p_321818_.getBrightness(LightLayer.BLOCK, p_321770_)) && this.skyLightLimit.isValueInRange(p_321818_.getBrightness(LightLayer.SKY, p_321770_));
        }
    }
}

