/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class SimpleExplosionDamageCalculator
extends ExplosionDamageCalculator {
    private final boolean explodesBlocks;
    private final boolean damagesEntities;
    private final Optional<Float> knockbackMultiplier;
    private final Optional<HolderSet<Block>> immuneBlocks;

    public SimpleExplosionDamageCalculator(boolean p_345621_, boolean p_345535_, Optional<Float> p_344810_, Optional<HolderSet<Block>> p_346110_) {
        this.explodesBlocks = p_345621_;
        this.damagesEntities = p_345535_;
        this.knockbackMultiplier = p_344810_;
        this.immuneBlocks = p_346110_;
    }

    @Override
    public Optional<Float> getBlockExplosionResistance(Explosion p_346109_, BlockGetter p_345381_, BlockPos p_344921_, BlockState p_346239_, FluidState p_345105_) {
        if (this.immuneBlocks.isPresent()) {
            return p_346239_.is(this.immuneBlocks.get()) ? Optional.of(Float.valueOf(3600000.0f)) : Optional.empty();
        }
        return super.getBlockExplosionResistance(p_346109_, p_345381_, p_344921_, p_346239_, p_345105_);
    }

    @Override
    public boolean shouldBlockExplode(Explosion p_345994_, BlockGetter p_345042_, BlockPos p_345057_, BlockState p_345932_, float p_345776_) {
        return this.explodesBlocks;
    }

    @Override
    public boolean shouldDamageEntity(Explosion p_346248_, Entity p_344983_) {
        return this.damagesEntities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float getKnockbackMultiplier(Entity p_345651_) {
        boolean flag;
        if (p_345651_ instanceof Player) {
            Player player = (Player)p_345651_;
            if (player.getAbilities().flying) {
                return 0.0f;
            }
        }
        boolean bl = flag = false;
        if (flag) {
            return 0.0f;
        }
        float f = this.knockbackMultiplier.orElseGet(() -> Float.valueOf(super.getKnockbackMultiplier(p_345651_))).floatValue();
        return f;
    }
}

