/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;

public interface LevelHeightAccessor {
    public int getHeight();

    public int getMinY();

    default public int getMaxY() {
        return this.getMinY() + this.getHeight() - 1;
    }

    default public int getSectionsCount() {
        return this.getMaxSectionY() - this.getMinSectionY() + 1;
    }

    default public int getMinSectionY() {
        return SectionPos.blockToSectionCoord(this.getMinY());
    }

    default public int getMaxSectionY() {
        return SectionPos.blockToSectionCoord(this.getMaxY());
    }

    default public boolean isInsideBuildHeight(int p_366576_) {
        return p_366576_ >= this.getMinY() && p_366576_ <= this.getMaxY();
    }

    default public boolean isOutsideBuildHeight(BlockPos p_151571_) {
        return this.isOutsideBuildHeight(p_151571_.getY());
    }

    default public boolean isOutsideBuildHeight(int p_151563_) {
        return p_151563_ < this.getMinY() || p_151563_ > this.getMaxY();
    }

    default public int getSectionIndex(int p_151565_) {
        return this.getSectionIndexFromSectionY(SectionPos.blockToSectionCoord(p_151565_));
    }

    default public int getSectionIndexFromSectionY(int p_151567_) {
        return p_151567_ - this.getMinSectionY();
    }

    default public int getSectionYFromSectionIndex(int p_151569_) {
        return p_151569_ + this.getMinSectionY();
    }

    public static LevelHeightAccessor create(final int p_186488_, final int p_186489_) {
        return new LevelHeightAccessor(){

            @Override
            public int getHeight() {
                return p_186489_;
            }

            @Override
            public int getMinY() {
                return p_186488_;
            }
        };
    }
}

