/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public interface LevelAccessor
extends CommonLevelAccessor,
LevelTimeAccess,
ScheduledTickAccess {
    @Override
    default public long dayTime() {
        return this.getLevelData().getDayTime();
    }

    public long nextSubTickCount();

    @Override
    default public <T> ScheduledTick<T> createTick(BlockPos p_186483_, T p_186484_, int p_186485_, TickPriority p_186486_) {
        return new ScheduledTick<T>(p_186484_, p_186483_, this.getLevelData().getGameTime() + (long)p_186485_, p_186486_, this.nextSubTickCount());
    }

    @Override
    default public <T> ScheduledTick<T> createTick(BlockPos p_186479_, T p_186480_, int p_186481_) {
        return new ScheduledTick<T>(p_186480_, p_186479_, this.getLevelData().getGameTime() + (long)p_186481_, this.nextSubTickCount());
    }

    public LevelData getLevelData();

    public DifficultyInstance getCurrentDifficultyAt(BlockPos var1);

    @Nullable
    public MinecraftServer getServer();

    default public Difficulty getDifficulty() {
        return this.getLevelData().getDifficulty();
    }

    public ChunkSource getChunkSource();

    @Override
    default public boolean hasChunk(int p_46794_, int p_46795_) {
        return this.getChunkSource().hasChunk(p_46794_, p_46795_);
    }

    public RandomSource getRandom();

    default public void updateNeighborsAt(BlockPos p_46781_, Block p_46782_) {
    }

    default public void neighborShapeChanged(Direction p_220411_, BlockPos p_220413_, BlockPos p_220414_, BlockState p_220412_, int p_220415_, int p_220416_) {
        NeighborUpdater.executeShapeUpdate(this, p_220411_, p_220413_, p_220414_, p_220412_, p_220415_, p_220416_ - 1);
    }

    default public void playSound(@Nullable Entity p_393651_, BlockPos p_250192_, SoundEvent p_249887_, SoundSource p_250593_) {
        this.playSound(p_393651_, p_250192_, p_249887_, p_250593_, 1.0f, 1.0f);
    }

    public void playSound(@Nullable Entity var1, BlockPos var2, SoundEvent var3, SoundSource var4, float var5, float var6);

    public void addParticle(ParticleOptions var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void levelEvent(@Nullable Entity var1, int var2, BlockPos var3, int var4);

    default public void levelEvent(int p_46797_, BlockPos p_46798_, int p_46799_) {
        this.levelEvent(null, p_46797_, p_46798_, p_46799_);
    }

    public void gameEvent(Holder<GameEvent> var1, Vec3 var2, GameEvent.Context var3);

    default public void gameEvent(@Nullable Entity p_151549_, Holder<GameEvent> p_316314_, Vec3 p_316613_) {
        this.gameEvent(p_316314_, p_316613_, new GameEvent.Context(p_151549_, null));
    }

    default public void gameEvent(@Nullable Entity p_316772_, Holder<GameEvent> p_316248_, BlockPos p_316282_) {
        this.gameEvent(p_316248_, p_316282_, new GameEvent.Context(p_316772_, null));
    }

    default public void gameEvent(Holder<GameEvent> p_316320_, BlockPos p_220409_, GameEvent.Context p_220410_) {
        this.gameEvent(p_316320_, Vec3.atCenterOf(p_220409_), p_220410_);
    }

    default public void gameEvent(ResourceKey<GameEvent> p_316780_, BlockPos p_316509_, GameEvent.Context p_316524_) {
        this.gameEvent((Holder<GameEvent>)this.registryAccess().lookupOrThrow(Registries.GAME_EVENT).getOrThrow(p_316780_), p_316509_, p_316524_);
    }
}

