/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.common.config.NeoForgeServerConfig;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.server.timings.TimeTracker;
import org.jetbrains.annotations.ApiStatus;

public abstract class Level
extends AttachmentHolder
implements LevelAccessor,
UUIDLookup<Entity>,
AutoCloseable,
ILevelExtension {
    public static final Codec<ResourceKey<Level>> RESOURCE_KEY_CODEC = ResourceKey.codec(Registries.DIMENSION);
    public static final ResourceKey<Level> OVERWORLD = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("overworld"));
    public static final ResourceKey<Level> NETHER = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("the_nether"));
    public static final ResourceKey<Level> END = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("the_end"));
    public static final int MAX_LEVEL_SIZE = 30000000;
    public static final int LONG_PARTICLE_CLIP_RANGE = 512;
    public static final int SHORT_PARTICLE_CLIP_RANGE = 32;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int TICKS_PER_DAY = 24000;
    public static final int MAX_ENTITY_SPAWN_Y = 20000000;
    public static final int MIN_ENTITY_SPAWN_Y = -20000000;
    protected final List<TickingBlockEntity> blockEntityTickers = Lists.newArrayList();
    protected final NeighborUpdater neighborUpdater;
    private final List<TickingBlockEntity> pendingBlockEntityTickers = Lists.newArrayList();
    private boolean tickingBlockEntities;
    private final Thread thread;
    private final boolean isDebug;
    private int skyDarken;
    protected int randValue = RandomSource.create().nextInt();
    protected final int addend = 1013904223;
    public float oRainLevel;
    public float rainLevel;
    public float oThunderLevel;
    public float thunderLevel;
    public final RandomSource random = RandomSource.create();
    @Deprecated
    private final RandomSource threadSafeRandom = RandomSource.createThreadSafe();
    private final Holder<DimensionType> dimensionTypeRegistration;
    protected final WritableLevelData levelData;
    public final boolean isClientSide;
    private final WorldBorder worldBorder;
    private final BiomeManager biomeManager;
    private final ResourceKey<Level> dimension;
    private final RegistryAccess registryAccess;
    private final DamageSources damageSources;
    private long subTickCount;
    public boolean restoringBlockSnapshots = false;
    public boolean captureBlockSnapshots = false;
    public ArrayList<BlockSnapshot> capturedBlockSnapshots = new ArrayList();
    private final ArrayList<BlockEntity> freshBlockEntities = new ArrayList();
    private final ArrayList<BlockEntity> pendingFreshBlockEntities = new ArrayList();
    private static final Direction[] NEIGHBOR_UPDATE_LIST = (Direction[])Stream.concat(Direction.Plane.HORIZONTAL.stream(), Direction.Plane.VERTICAL.stream()).toArray(Direction[]::new);
    private double maxEntityRadius = 2.0;

    protected Level(WritableLevelData p_270739_, ResourceKey<Level> p_270683_, RegistryAccess p_270200_, Holder<DimensionType> p_270240_, boolean p_270904_, boolean p_270470_, long p_270248_, int p_270466_) {
        this.levelData = p_270739_;
        this.dimensionTypeRegistration = p_270240_;
        final DimensionType dimensiontype = p_270240_.value();
        this.dimension = p_270683_;
        this.isClientSide = p_270904_;
        this.worldBorder = dimensiontype.coordinateScale() != 1.0 ? new WorldBorder(this){

            @Override
            public double getCenterX() {
                return super.getCenterX() / dimensiontype.coordinateScale();
            }

            @Override
            public double getCenterZ() {
                return super.getCenterZ() / dimensiontype.coordinateScale();
            }
        } : new WorldBorder();
        this.thread = Thread.currentThread();
        this.biomeManager = new BiomeManager(this, p_270248_);
        this.isDebug = p_270470_;
        this.neighborUpdater = new CollectingNeighborUpdater(this, p_270466_);
        this.registryAccess = p_270200_;
        this.damageSources = new DamageSources(p_270200_);
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public boolean isInWorldBounds(BlockPos p_46740_) {
        return !this.isOutsideBuildHeight(p_46740_) && Level.isInWorldBoundsHorizontal(p_46740_);
    }

    public static boolean isInSpawnableBounds(BlockPos p_46742_) {
        return !Level.isOutsideSpawnableHeight(p_46742_.getY()) && Level.isInWorldBoundsHorizontal(p_46742_);
    }

    private static boolean isInWorldBoundsHorizontal(BlockPos p_46458_) {
        return p_46458_.getX() >= -30000000 && p_46458_.getZ() >= -30000000 && p_46458_.getX() < 30000000 && p_46458_.getZ() < 30000000;
    }

    private static boolean isOutsideSpawnableHeight(int p_46725_) {
        return p_46725_ < -20000000 || p_46725_ >= 20000000;
    }

    public LevelChunk getChunkAt(BlockPos p_46746_) {
        return this.getChunk(SectionPos.blockToSectionCoord(p_46746_.getX()), SectionPos.blockToSectionCoord(p_46746_.getZ()));
    }

    @Override
    public LevelChunk getChunk(int p_46727_, int p_46728_) {
        return (LevelChunk)this.getChunk(p_46727_, p_46728_, ChunkStatus.FULL);
    }

    @Override
    @Nullable
    public ChunkAccess getChunk(int p_46502_, int p_46503_, ChunkStatus p_331611_, boolean p_46505_) {
        ChunkAccess chunkaccess = this.getChunkSource().getChunk(p_46502_, p_46503_, p_331611_, p_46505_);
        if (chunkaccess == null && p_46505_) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return chunkaccess;
    }

    @Override
    public boolean setBlock(BlockPos p_46601_, BlockState p_46602_, int p_46603_) {
        return this.setBlock(p_46601_, p_46602_, p_46603_, 512);
    }

    @Override
    public boolean setBlock(BlockPos p_46605_, BlockState p_46606_, int p_46607_, int p_46608_) {
        BlockState blockstate;
        if (this.isOutsideBuildHeight(p_46605_)) {
            return false;
        }
        if (!this.isClientSide && this.isDebug()) {
            return false;
        }
        LevelChunk levelchunk = this.getChunkAt(p_46605_);
        Block block = p_46606_.getBlock();
        p_46605_ = p_46605_.immutable();
        BlockSnapshot blockSnapshot = null;
        if (this.captureBlockSnapshots && !this.isClientSide) {
            blockSnapshot = BlockSnapshot.create(this.dimension, (LevelAccessor)this, (BlockPos)p_46605_, (int)p_46607_);
            this.capturedBlockSnapshots.add(blockSnapshot);
        }
        if ((blockstate = levelchunk.setBlockState(p_46605_, p_46606_, p_46607_)) == null) {
            if (blockSnapshot != null) {
                this.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        BlockState blockstate1 = this.getBlockState(p_46605_);
        if (blockSnapshot == null) {
            this.markAndNotifyBlock(p_46605_, levelchunk, blockstate, p_46606_, p_46607_, p_46608_);
        }
        return true;
    }

    public void markAndNotifyBlock(BlockPos p_46605_, @Nullable LevelChunk levelchunk, BlockState blockstate, BlockState p_46606_, int p_46607_, int p_46608_) {
        Block block = p_46606_.getBlock();
        BlockState blockstate1 = this.getBlockState(p_46605_);
        if (blockstate1 == p_46606_) {
            if (blockstate != blockstate1) {
                this.setBlocksDirty(p_46605_, blockstate, blockstate1);
            }
            if ((p_46607_ & 2) != 0 && (!this.isClientSide || (p_46607_ & 4) == 0) && (this.isClientSide || levelchunk.getFullStatus() != null && levelchunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING))) {
                this.sendBlockUpdated(p_46605_, blockstate, p_46606_, p_46607_);
            }
            if ((p_46607_ & 1) != 0) {
                this.updateNeighborsAt(p_46605_, blockstate.getBlock());
                if (!this.isClientSide && p_46606_.hasAnalogOutputSignal()) {
                    this.updateNeighbourForOutputSignal(p_46605_, block);
                }
            }
            if ((p_46607_ & 0x10) == 0 && p_46608_ > 0) {
                int i = p_46607_ & 0xFFFFFFDE;
                blockstate.updateIndirectNeighbourShapes(this, p_46605_, i, p_46608_ - 1);
                p_46606_.updateNeighbourShapes(this, p_46605_, i, p_46608_ - 1);
                p_46606_.updateIndirectNeighbourShapes(this, p_46605_, i, p_46608_ - 1);
            }
            this.updatePOIOnBlockStateChange(p_46605_, blockstate, blockstate1);
            p_46606_.onBlockStateChange(this, p_46605_, blockstate);
        }
    }

    public void updatePOIOnBlockStateChange(BlockPos p_394475_, BlockState p_393580_, BlockState p_393789_) {
    }

    @Override
    public boolean removeBlock(BlockPos p_46623_, boolean p_46624_) {
        FluidState fluidstate = this.getFluidState(p_46623_);
        return this.setBlock(p_46623_, fluidstate.createLegacyBlock(), 3 | (p_46624_ ? 64 : 0));
    }

    @Override
    public boolean destroyBlock(BlockPos p_46626_, boolean p_46627_, @Nullable Entity p_46628_, int p_46629_) {
        boolean flag;
        BlockState blockstate = this.getBlockState(p_46626_);
        if (blockstate.isAir()) {
            return false;
        }
        FluidState fluidstate = this.getFluidState(p_46626_);
        if (!(blockstate.getBlock() instanceof BaseFireBlock)) {
            this.levelEvent(2001, p_46626_, Block.getId(blockstate));
        }
        if (p_46627_) {
            BlockEntity blockentity = blockstate.hasBlockEntity() ? this.getBlockEntity(p_46626_) : null;
            Block.dropResources(blockstate, this, p_46626_, blockentity, p_46628_, ItemStack.EMPTY);
        }
        if (flag = this.setBlock(p_46626_, fluidstate.createLegacyBlock(), 3, p_46629_)) {
            this.gameEvent(GameEvent.BLOCK_DESTROY, p_46626_, GameEvent.Context.of(p_46628_, blockstate));
        }
        return flag;
    }

    public void addDestroyBlockEffect(BlockPos p_151531_, BlockState p_151532_) {
    }

    public boolean setBlockAndUpdate(BlockPos p_46598_, BlockState p_46599_) {
        return this.setBlock(p_46598_, p_46599_, 3);
    }

    public abstract void sendBlockUpdated(BlockPos var1, BlockState var2, BlockState var3, int var4);

    public void setBlocksDirty(BlockPos p_46678_, BlockState p_46679_, BlockState p_46680_) {
    }

    public void updateNeighborsAt(BlockPos p_365514_, Block p_364886_, @Nullable Orientation p_363337_) {
        EventHooks.onNeighborNotify((Level)this, (BlockPos)p_365514_, (BlockState)this.getBlockState(p_365514_), EnumSet.allOf(Direction.class), (boolean)false).isCanceled();
    }

    public void updateNeighborsAtExceptFromFacing(BlockPos p_46591_, Block p_46592_, Direction p_46593_, @Nullable Orientation p_362952_) {
    }

    public void neighborChanged(BlockPos p_220380_, Block p_220381_, @Nullable Orientation p_361509_) {
    }

    public void neighborChanged(BlockState p_361138_, BlockPos p_46587_, Block p_46588_, @Nullable Orientation p_362276_, boolean p_361335_) {
    }

    @Override
    public void neighborShapeChanged(Direction p_220385_, BlockPos p_220387_, BlockPos p_220388_, BlockState p_220386_, int p_220389_, int p_220390_) {
        this.neighborUpdater.shapeUpdate(p_220385_, p_220386_, p_220387_, p_220388_, p_220389_, p_220390_);
    }

    @Override
    public int getHeight(Heightmap.Types p_46571_, int p_46572_, int p_46573_) {
        int i = p_46572_ >= -30000000 && p_46573_ >= -30000000 && p_46572_ < 30000000 && p_46573_ < 30000000 ? (this.hasChunk(SectionPos.blockToSectionCoord(p_46572_), SectionPos.blockToSectionCoord(p_46573_)) ? this.getChunk(SectionPos.blockToSectionCoord(p_46572_), SectionPos.blockToSectionCoord(p_46573_)).getHeight(p_46571_, p_46572_ & 0xF, p_46573_ & 0xF) + 1 : this.getMinY()) : this.getSeaLevel() + 1;
        return i;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.getChunkSource().getLightEngine();
    }

    @Override
    public BlockState getBlockState(BlockPos p_46732_) {
        if (this.isOutsideBuildHeight(p_46732_)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        LevelChunk levelchunk = this.getChunk(SectionPos.blockToSectionCoord(p_46732_.getX()), SectionPos.blockToSectionCoord(p_46732_.getZ()));
        return levelchunk.getBlockState(p_46732_);
    }

    @Override
    public FluidState getFluidState(BlockPos p_46671_) {
        if (this.isOutsideBuildHeight(p_46671_)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        LevelChunk levelchunk = this.getChunkAt(p_46671_);
        return levelchunk.getFluidState(p_46671_);
    }

    public boolean isBrightOutside() {
        return !this.dimensionType().hasFixedTime() && this.skyDarken < 4;
    }

    public boolean isDarkOutside() {
        return !this.dimensionType().hasFixedTime() && !this.isBrightOutside();
    }

    public boolean isMoonVisible() {
        if (!this.dimensionType().natural()) {
            return false;
        }
        int i = (int)(this.getDayTime() % 24000L);
        return i >= 12600 && i <= 23400;
    }

    @Override
    public void playSound(@Nullable Entity p_252137_, BlockPos p_251749_, SoundEvent p_248842_, SoundSource p_251104_, float p_249531_, float p_250763_) {
        this.playSound(p_252137_, (double)p_251749_.getX() + 0.5, (double)p_251749_.getY() + 0.5, (double)p_251749_.getZ() + 0.5, p_248842_, p_251104_, p_249531_, p_250763_);
    }

    public abstract void playSeededSound(@Nullable Entity var1, double var2, double var4, double var6, Holder<SoundEvent> var8, SoundSource var9, float var10, float var11, long var12);

    public void playSeededSound(@Nullable Entity p_220373_, double p_393694_, double p_394310_, double p_393691_, SoundEvent p_394542_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
        this.playSeededSound(p_220373_, p_393694_, p_394310_, p_393691_, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(p_394542_), p_220375_, p_220376_, p_220377_, p_220378_);
    }

    public abstract void playSeededSound(@Nullable Entity var1, Entity var2, Holder<SoundEvent> var3, SoundSource var4, float var5, float var6, long var7);

    public void playSound(@Nullable Entity p_393558_, double p_46544_, double p_46545_, double p_46546_, SoundEvent p_46547_, SoundSource p_46548_) {
        this.playSound(p_393558_, p_46544_, p_46545_, p_46546_, p_46547_, p_46548_, 1.0f, 1.0f);
    }

    public void playSound(@Nullable Entity p_394547_, double p_308925_, double p_309072_, double p_308916_, SoundEvent p_308917_, SoundSource p_308902_, float p_394219_, float p_394345_) {
        this.playSeededSound(p_394547_, p_308925_, p_309072_, p_308916_, p_308917_, p_308902_, p_394219_, p_394345_, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Entity p_393791_, double p_394457_, double p_393667_, double p_393838_, Holder<SoundEvent> p_394598_, SoundSource p_46563_, float p_46564_, float p_46565_) {
        this.playSeededSound(p_393791_, p_394457_, p_393667_, p_393838_, p_394598_, p_46563_, p_46564_, p_46565_, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Entity p_394000_, Entity p_393603_, SoundEvent p_393830_, SoundSource p_347522_, float p_347447_, float p_347667_) {
        this.playSeededSound(p_394000_, p_393603_, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(p_393830_), p_347522_, p_347447_, p_347667_, this.threadSafeRandom.nextLong());
    }

    public void playLocalSound(BlockPos p_250938_, SoundEvent p_252209_, SoundSource p_249161_, float p_249980_, float p_250277_, boolean p_250151_) {
        this.playLocalSound((double)p_250938_.getX() + 0.5, (double)p_250938_.getY() + 0.5, (double)p_250938_.getZ() + 0.5, p_252209_, p_249161_, p_249980_, p_250277_, p_250151_);
    }

    public void playLocalSound(Entity p_312189_, SoundEvent p_312080_, SoundSource p_312905_, float p_312914_, float p_312831_) {
    }

    public void playLocalSound(double p_46482_, double p_46483_, double p_46484_, SoundEvent p_46485_, SoundSource p_46486_, float p_46487_, float p_46488_, boolean p_46489_) {
    }

    public void playPlayerSound(SoundEvent p_401325_, SoundSource p_401393_, float p_401219_, float p_401183_) {
    }

    @Override
    public void addParticle(ParticleOptions p_46631_, double p_46632_, double p_46633_, double p_46634_, double p_46635_, double p_46636_, double p_46637_) {
    }

    public void addParticle(ParticleOptions p_46638_, boolean p_46639_, boolean p_382799_, double p_46640_, double p_46641_, double p_46642_, double p_46643_, double p_46644_, double p_46645_) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions p_46684_, double p_46685_, double p_46686_, double p_46687_, double p_46688_, double p_46689_, double p_46690_) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions p_46691_, boolean p_46692_, double p_46693_, double p_46694_, double p_46695_, double p_46696_, double p_46697_, double p_46698_) {
    }

    public float getSunAngle(float p_46491_) {
        float f = this.getTimeOfDay(p_46491_);
        return f * ((float)Math.PI * 2);
    }

    public void addBlockEntityTicker(TickingBlockEntity p_151526_) {
        (this.tickingBlockEntities ? this.pendingBlockEntityTickers : this.blockEntityTickers).add(p_151526_);
    }

    public void addFreshBlockEntities(Collection<BlockEntity> beList) {
        if (this.tickingBlockEntities) {
            this.pendingFreshBlockEntities.addAll(beList);
        } else {
            this.freshBlockEntities.addAll(beList);
        }
    }

    protected void tickBlockEntities() {
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("blockEntities");
        if (!this.pendingFreshBlockEntities.isEmpty()) {
            this.freshBlockEntities.addAll(this.pendingFreshBlockEntities);
            this.pendingFreshBlockEntities.clear();
        }
        this.tickingBlockEntities = true;
        if (!this.freshBlockEntities.isEmpty()) {
            this.freshBlockEntities.forEach(blockEntity -> {
                if (!blockEntity.isRemoved() && blockEntity.hasLevel()) {
                    blockEntity.onLoad();
                }
            });
            this.freshBlockEntities.clear();
        }
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
            this.pendingBlockEntityTickers.clear();
        }
        Iterator<TickingBlockEntity> iterator = this.blockEntityTickers.iterator();
        boolean flag = this.tickRateManager().runsNormally();
        while (iterator.hasNext()) {
            TickingBlockEntity tickingblockentity = iterator.next();
            if (tickingblockentity.isRemoved()) {
                iterator.remove();
                continue;
            }
            if (!flag || !this.shouldTickBlocksAt(tickingblockentity.getPos())) continue;
            tickingblockentity.tick();
        }
        this.tickingBlockEntities = false;
        profilerfiller.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> void guardEntityTick(Consumer<T> p_46654_, T p_46655_) {
        block6: {
            try {
                TimeTracker.ENTITY_UPDATE.trackStart(p_46655_);
                p_46654_.accept(p_46655_);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Ticking entity");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being ticked");
                p_46655_.fillCrashReportCategory(crashreportcategory);
                if (((Boolean)NeoForgeServerConfig.INSTANCE.removeErroringEntities.get()).booleanValue()) {
                    LogUtils.getLogger().error("{}", (Object)crashreport.getFriendlyReport(ReportType.CRASH));
                    p_46655_.discard();
                    break block6;
                }
                throw new ReportedException(crashreport);
            }
            finally {
                TimeTracker.ENTITY_UPDATE.trackEnd(p_46655_);
            }
        }
    }

    public boolean shouldTickDeath(Entity p_186458_) {
        return true;
    }

    public boolean shouldTickBlocksAt(long p_186456_) {
        return true;
    }

    public boolean shouldTickBlocksAt(BlockPos p_220394_) {
        return this.shouldTickBlocksAt(ChunkPos.asLong(p_220394_));
    }

    public void explode(@Nullable Entity p_256145_, double p_256208_, double p_256036_, double p_255746_, float p_256647_, ExplosionInteraction p_256104_) {
        this.explode(p_256145_, Explosion.getDefaultDamageSource(this, p_256145_), null, p_256208_, p_256036_, p_255746_, p_256647_, false, p_256104_, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable Entity p_255682_, double p_255803_, double p_256403_, double p_256538_, float p_255674_, boolean p_256634_, ExplosionInteraction p_256111_) {
        this.explode(p_255682_, Explosion.getDefaultDamageSource(this, p_255682_), null, p_255803_, p_256403_, p_256538_, p_255674_, p_256634_, p_256111_, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable Entity p_256233_, @Nullable DamageSource p_255861_, @Nullable ExplosionDamageCalculator p_255867_, Vec3 p_361166_, float p_256013_, boolean p_256228_, ExplosionInteraction p_255784_) {
        this.explode(p_256233_, p_255861_, p_255867_, p_361166_.x(), p_361166_.y(), p_361166_.z(), p_256013_, p_256228_, p_255784_, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable Entity p_311934_, @Nullable DamageSource p_312790_, @Nullable ExplosionDamageCalculator p_311975_, double p_312493_, double p_312456_, double p_312719_, float p_312292_, boolean p_312144_, ExplosionInteraction p_312265_) {
        this.explode(p_311934_, p_312790_, p_311975_, p_312493_, p_312456_, p_312719_, p_312292_, p_312144_, p_312265_, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public abstract void explode(@Nullable Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, ExplosionInteraction var12, ParticleOptions var13, ParticleOptions var14, Holder<SoundEvent> var15);

    public abstract String gatherChunkSourceStats();

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_46716_) {
        if (this.isOutsideBuildHeight(p_46716_)) {
            return null;
        }
        return !this.isClientSide && Thread.currentThread() != this.thread ? null : this.getChunkAt(p_46716_).getBlockEntity(p_46716_, LevelChunk.EntityCreationType.IMMEDIATE);
    }

    public void setBlockEntity(BlockEntity p_151524_) {
        BlockPos blockpos = p_151524_.getBlockPos();
        if (!this.isOutsideBuildHeight(blockpos)) {
            this.getChunkAt(blockpos).addAndRegisterBlockEntity(p_151524_);
        }
    }

    public void removeBlockEntity(BlockPos p_46748_) {
        if (!this.isOutsideBuildHeight(p_46748_)) {
            this.getChunkAt(p_46748_).removeBlockEntity(p_46748_);
        }
        this.updateNeighbourForOutputSignal(p_46748_, this.getBlockState(p_46748_).getBlock());
    }

    public boolean isLoaded(BlockPos p_46750_) {
        return this.isOutsideBuildHeight(p_46750_) ? false : this.getChunkSource().hasChunk(SectionPos.blockToSectionCoord(p_46750_.getX()), SectionPos.blockToSectionCoord(p_46750_.getZ()));
    }

    public boolean loadedAndEntityCanStandOnFace(BlockPos p_46579_, Entity p_46580_, Direction p_46581_) {
        if (this.isOutsideBuildHeight(p_46579_)) {
            return false;
        }
        ChunkAccess chunkaccess = this.getChunk(SectionPos.blockToSectionCoord(p_46579_.getX()), SectionPos.blockToSectionCoord(p_46579_.getZ()), ChunkStatus.FULL, false);
        return chunkaccess == null ? false : chunkaccess.getBlockState(p_46579_).entityCanStandOnFace(this, p_46579_, p_46580_, p_46581_);
    }

    public boolean loadedAndEntityCanStandOn(BlockPos p_46576_, Entity p_46577_) {
        return this.loadedAndEntityCanStandOnFace(p_46576_, p_46577_, Direction.UP);
    }

    public void updateSkyBrightness() {
        double d0 = 1.0 - (double)(this.getRainLevel(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.getThunderLevel(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * Mth.clamp((double)Mth.cos(this.getTimeOfDay(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.skyDarken = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void setSpawnSettings(boolean p_46704_) {
        this.getChunkSource().setSpawnSettings(p_46704_);
    }

    public BlockPos getSharedSpawnPos() {
        BlockPos blockpos = this.levelData.getSpawnPos();
        if (!this.getWorldBorder().isWithinBounds(blockpos)) {
            blockpos = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, BlockPos.containing(this.getWorldBorder().getCenterX(), 0.0, this.getWorldBorder().getCenterZ()));
        }
        return blockpos;
    }

    public float getSharedSpawnAngle() {
        return this.levelData.getSpawnAngle();
    }

    protected void prepareWeather() {
        if (this.levelData.isRaining()) {
            this.rainLevel = 1.0f;
            if (this.levelData.isThundering()) {
                this.thunderLevel = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getChunkSource().close();
    }

    @Override
    @Nullable
    public BlockGetter getChunkForCollisions(int p_46711_, int p_46712_) {
        return this.getChunk(p_46711_, p_46712_, ChunkStatus.FULL, false);
    }

    @Override
    public List<Entity> getEntities(@Nullable Entity p_46536_, AABB p_46537_, Predicate<? super Entity> p_46538_) {
        Profiler.get().incrementCounter("getEntities");
        ArrayList list = Lists.newArrayList();
        this.getEntities().get(p_46537_, p_382758_ -> {
            if (p_382758_ != p_46536_ && p_46538_.test((Entity)p_382758_)) {
                list.add(p_382758_);
            }
        });
        for (PartEntity<?> enderdragonpart : this.dragonParts()) {
            if (enderdragonpart == p_46536_ || enderdragonpart.getParent() == p_46536_ || !p_46538_.test((Entity)enderdragonpart) || !p_46537_.intersects(enderdragonpart.getBoundingBox())) continue;
            list.add(enderdragonpart);
        }
        return list;
    }

    @Override
    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> p_151528_, AABB p_151529_, Predicate<? super T> p_151530_) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(p_151528_, p_151529_, p_151530_, list);
        return list;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> p_261899_, AABB p_261837_, Predicate<? super T> p_261519_, List<? super T> p_262046_) {
        this.getEntities(p_261899_, p_261837_, p_261519_, p_262046_, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> p_261885_, AABB p_262086_, Predicate<? super T> p_261688_, List<? super T> p_262071_, int p_261858_) {
        Profiler.get().incrementCounter("getEntities");
        this.getEntities().get(p_261885_, p_262086_, p_261454_ -> {
            if (p_261688_.test((Entity)p_261454_)) {
                p_262071_.add(p_261454_);
                if (p_262071_.size() >= p_261858_) {
                    return AbortableIterationConsumer.Continuation.ABORT;
                }
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
        for (PartEntity<?> p : this.dragonParts()) {
            Entity t = (Entity)p_261885_.tryCast((Entity)p);
            if (t == null || !t.getBoundingBox().intersects(p_262086_) || !p_261688_.test(t)) continue;
            p_262071_.add(t);
            if (p_262071_.size() < p_261858_) continue;
            break;
        }
    }

    public List<Entity> getPushableEntities(Entity p_394578_, AABB p_394614_) {
        return this.getEntities(p_394578_, p_394614_, EntitySelector.pushableBy(p_394578_));
    }

    @Nullable
    public abstract Entity getEntity(int var1);

    @Override
    @Nullable
    public Entity getEntity(UUID p_394067_) {
        return this.getEntities().get(p_394067_);
    }

    public abstract Collection<PartEntity<?>> dragonParts();

    public void blockEntityChanged(BlockPos p_151544_) {
        if (this.hasChunkAt(p_151544_)) {
            this.getChunkAt(p_151544_).markUnsaved();
        }
    }

    public void onBlockEntityAdded(BlockEntity p_427392_) {
    }

    public long getGameTime() {
        return this.levelData.getGameTime();
    }

    public long getDayTime() {
        return this.levelData.getDayTime();
    }

    public boolean mayInteract(Entity p_393625_, BlockPos p_46558_) {
        return true;
    }

    public void broadcastEntityEvent(Entity p_46509_, byte p_46510_) {
    }

    public void broadcastDamageEvent(Entity p_270831_, DamageSource p_270361_) {
    }

    public void blockEvent(BlockPos p_46582_, Block p_46583_, int p_46584_, int p_46585_) {
        this.getBlockState(p_46582_).triggerEvent(this, p_46582_, p_46584_, p_46585_);
    }

    @Override
    public LevelData getLevelData() {
        return this.levelData;
    }

    public abstract TickRateManager tickRateManager();

    public float getThunderLevel(float p_46662_) {
        return Mth.lerp(p_46662_, this.oThunderLevel, this.thunderLevel) * this.getRainLevel(p_46662_);
    }

    public void setThunderLevel(float p_46708_) {
        float f;
        this.oThunderLevel = f = Mth.clamp(p_46708_, 0.0f, 1.0f);
        this.thunderLevel = f;
    }

    public float getRainLevel(float p_46723_) {
        return Mth.lerp(p_46723_, this.oRainLevel, this.rainLevel);
    }

    public void setRainLevel(float p_46735_) {
        float f;
        this.oRainLevel = f = Mth.clamp(p_46735_, 0.0f, 1.0f);
        this.rainLevel = f;
    }

    private boolean canHaveWeather() {
        return this.dimensionType().hasSkyLight() && !this.dimensionType().hasCeiling();
    }

    public boolean isThundering() {
        return this.canHaveWeather() && (double)this.getThunderLevel(1.0f) > 0.9;
    }

    public boolean isRaining() {
        return this.canHaveWeather() && (double)this.getRainLevel(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPos p_46759_) {
        return this.precipitationAt(p_46759_) == Biome.Precipitation.RAIN;
    }

    public Biome.Precipitation precipitationAt(BlockPos p_415828_) {
        if (!this.isRaining()) {
            return Biome.Precipitation.NONE;
        }
        if (!this.canSeeSky(p_415828_)) {
            return Biome.Precipitation.NONE;
        }
        if (this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, p_415828_).getY() > p_415828_.getY()) {
            return Biome.Precipitation.NONE;
        }
        Biome biome = (Biome)this.getBiome(p_415828_).value();
        return biome.getPrecipitationAt(p_415828_, this.getSeaLevel());
    }

    @Nullable
    public abstract MapItemSavedData getMapData(MapId var1);

    public void globalLevelEvent(int p_46665_, BlockPos p_46666_, int p_46667_) {
    }

    public CrashReportCategory fillReportDetails(CrashReport p_46656_) {
        CrashReportCategory crashreportcategory = p_46656_.addCategory("Affected level", 1);
        crashreportcategory.setDetail("All players", () -> {
            List list = this.players();
            return list.size() + " total; " + list.stream().map(Player::debugInfo).collect(Collectors.joining(", "));
        });
        crashreportcategory.setDetail("Chunk stats", this.getChunkSource()::gatherStats);
        crashreportcategory.setDetail("Level dimension", () -> this.dimension().location().toString());
        try {
            this.levelData.fillCrashReportCategory(crashreportcategory, this);
        }
        catch (Throwable throwable) {
            crashreportcategory.setDetailError("Level Data Unobtainable", throwable);
        }
        return crashreportcategory;
    }

    public abstract void destroyBlockProgress(int var1, BlockPos var2, int var3);

    public void createFireworks(double p_46475_, double p_46476_, double p_46477_, double p_46478_, double p_46479_, double p_46480_, List<FireworkExplosion> p_332050_) {
    }

    public abstract Scoreboard getScoreboard();

    public void updateNeighbourForOutputSignal(BlockPos p_46718_, Block p_46719_) {
        for (Direction direction : NEIGHBOR_UPDATE_LIST) {
            BlockPos blockpos = p_46718_.relative(direction);
            if (!this.hasChunkAt(blockpos)) continue;
            BlockState blockstate = this.getBlockState(blockpos);
            blockstate.onNeighborChange(this, blockpos, p_46718_);
            if (!blockstate.isRedstoneConductor(this, blockpos) || !(blockstate = this.getBlockState(blockpos = blockpos.relative(direction))).getWeakChanges(this, blockpos) || !direction.getAxis().isHorizontal() && blockstate.is(Blocks.COMPARATOR)) continue;
            this.neighborChanged(blockstate, blockpos, p_46719_, null, false);
        }
    }

    @Override
    public DifficultyInstance getCurrentDifficultyAt(BlockPos p_46730_) {
        long i = 0L;
        float f = 0.0f;
        if (this.hasChunkAt(p_46730_)) {
            f = this.getMoonBrightness();
            i = this.getChunkAt(p_46730_).getInhabitedTime();
        }
        return new DifficultyInstance(this.getDifficulty(), this.getDayTime(), i, f);
    }

    @Override
    public int getSkyDarken() {
        return this.skyDarken;
    }

    public void setSkyFlashTime(int p_46709_) {
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public void sendPacketToServer(Packet<?> p_46657_) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionType dimensionType() {
        return this.dimensionTypeRegistration.value();
    }

    public Holder<DimensionType> dimensionTypeRegistration() {
        return this.dimensionTypeRegistration;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public boolean isStateAtPosition(BlockPos p_46620_, Predicate<BlockState> p_46621_) {
        return p_46621_.test(this.getBlockState(p_46620_));
    }

    @Override
    public boolean isFluidAtPosition(BlockPos p_151541_, Predicate<FluidState> p_151542_) {
        return p_151542_.test(this.getFluidState(p_151541_));
    }

    public abstract RecipeAccess recipeAccess();

    public BlockPos getBlockRandomPos(int p_46497_, int p_46498_, int p_46499_, int p_46500_) {
        this.randValue = this.randValue * 3 + 1013904223;
        int i = this.randValue >> 2;
        return new BlockPos(p_46497_ + (i & 0xF), p_46498_ + (i >> 16 & p_46500_), p_46499_ + (i >> 8 & 0xF));
    }

    public boolean noSave() {
        return false;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public double getMaxEntityRadius() {
        return this.maxEntityRadius;
    }

    public double increaseMaxEntityRadius(double value) {
        if (value > this.maxEntityRadius) {
            this.maxEntityRadius = value;
        }
        return this.maxEntityRadius;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    protected abstract LevelEntityGetter<Entity> getEntities();

    @Override
    public long nextSubTickCount() {
        return this.subTickCount++;
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }

    public DamageSources damageSources() {
        return this.damageSources;
    }

    public abstract PotionBrewing potionBrewing();

    public abstract FuelValues fuelValues();

    public int getClientLeafTintColor(BlockPos p_400079_) {
        return 0;
    }

    @ApiStatus.Internal
    public abstract void setDayTimeFraction(float var1);

    @ApiStatus.Internal
    public abstract float getDayTimeFraction();

    public abstract float getDayTimePerTick();

    public abstract void setDayTimePerTick(float var1);

    @ApiStatus.Internal
    protected long advanceDaytime() {
        if (this.getDayTimePerTick() < 0.0f) {
            return 1L;
        }
        float dayTimeStep = this.getDayTimeFraction() + this.getDayTimePerTick();
        long result = (long)dayTimeStep;
        this.setDayTimeFraction(dayTimeStep - (float)result);
        return result;
    }

    public static enum ExplosionInteraction implements StringRepresentable
    {
        NONE("none"),
        BLOCK("block"),
        MOB("mob"),
        TNT("tnt"),
        TRIGGER("trigger");

        public static final Codec<ExplosionInteraction> CODEC;
        private final String id;

        private ExplosionInteraction(String p_346300_) {
            this.id = p_346300_;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ExplosionInteraction::values);
        }
    }
}

