/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CollisionGetter
extends BlockGetter {
    public WorldBorder getWorldBorder();

    @Nullable
    public BlockGetter getChunkForCollisions(int var1, int var2);

    default public boolean isUnobstructed(@Nullable Entity p_45750_, VoxelShape p_45751_) {
        return true;
    }

    default public boolean isUnobstructed(BlockState p_45753_, BlockPos p_45754_, CollisionContext p_45755_) {
        VoxelShape voxelshape = p_45753_.getCollisionShape(this, p_45754_, p_45755_);
        return voxelshape.isEmpty() || this.isUnobstructed(null, voxelshape.move(p_45754_));
    }

    default public boolean isUnobstructed(Entity p_45785_) {
        return this.isUnobstructed(p_45785_, Shapes.create(p_45785_.getBoundingBox()));
    }

    default public boolean noCollision(AABB p_45773_) {
        return this.noCollision(null, p_45773_);
    }

    default public boolean noCollision(Entity p_45787_) {
        return this.noCollision(p_45787_, p_45787_.getBoundingBox());
    }

    default public boolean noCollision(@Nullable Entity p_45757_, AABB p_45758_) {
        return this.noCollision(p_45757_, p_45758_, false);
    }

    default public boolean noCollision(@Nullable Entity p_364564_, AABB p_364942_, boolean p_362912_) {
        for (VoxelShape voxelshape : p_362912_ ? this.getBlockAndLiquidCollisions(p_364564_, p_364942_) : this.getBlockCollisions(p_364564_, p_364942_)) {
            if (voxelshape.isEmpty()) continue;
            return false;
        }
        if (!this.getEntityCollisions(p_364564_, p_364942_).isEmpty()) {
            return false;
        }
        if (p_364564_ == null) {
            return true;
        }
        VoxelShape voxelshape1 = this.borderCollision(p_364564_, p_364942_);
        return voxelshape1 == null || !Shapes.joinIsNotEmpty(voxelshape1, Shapes.create(p_364942_), BooleanOp.AND);
    }

    default public boolean noBlockCollision(@Nullable Entity p_295728_, AABB p_294209_) {
        for (VoxelShape voxelshape : this.getBlockCollisions(p_295728_, p_294209_)) {
            if (voxelshape.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<VoxelShape> getEntityCollisions(@Nullable Entity var1, AABB var2);

    default public Iterable<VoxelShape> getCollisions(@Nullable Entity p_186432_, AABB p_186433_) {
        List<VoxelShape> list = this.getEntityCollisions(p_186432_, p_186433_);
        Iterable iterable = this.getBlockCollisions(p_186432_, p_186433_);
        return list.isEmpty() ? iterable : Iterables.concat(list, iterable);
    }

    default public Iterable<VoxelShape> getPreMoveCollisions(@Nullable Entity p_421848_, AABB p_422291_, Vec3 p_422022_) {
        List<VoxelShape> list = this.getEntityCollisions(p_421848_, p_422291_);
        Iterable iterable = this.getBlockCollisionsFromContext(CollisionContext.withPosition(p_421848_, p_422022_.y), p_422291_);
        return list.isEmpty() ? iterable : Iterables.concat(list, iterable);
    }

    default public Iterable<VoxelShape> getBlockCollisions(@Nullable Entity p_186435_, AABB p_186436_) {
        return this.getBlockCollisionsFromContext(p_186435_ == null ? CollisionContext.empty() : CollisionContext.of(p_186435_), p_186436_);
    }

    default public Iterable<VoxelShape> getBlockAndLiquidCollisions(@Nullable Entity p_364621_, AABB p_365424_) {
        return this.getBlockCollisionsFromContext(p_364621_ == null ? CollisionContext.empty() : CollisionContext.of(p_364621_, true), p_365424_);
    }

    private Iterable<VoxelShape> getBlockCollisionsFromContext(CollisionContext p_422304_, AABB p_421735_) {
        return () -> new BlockCollisions<VoxelShape>(this, p_422304_, p_421735_, false, (p_286215_, p_286216_) -> p_286216_);
    }

    @Nullable
    private VoxelShape borderCollision(Entity p_186441_, AABB p_186442_) {
        WorldBorder worldborder = this.getWorldBorder();
        return worldborder.isInsideCloseToBorder(p_186441_, p_186442_) ? worldborder.getCollisionShape() : null;
    }

    default public BlockHitResult clipIncludingBorder(ClipContext p_365129_) {
        BlockHitResult blockhitresult = this.clip(p_365129_);
        WorldBorder worldborder = this.getWorldBorder();
        if (worldborder.isWithinBounds(p_365129_.getFrom()) && !worldborder.isWithinBounds(blockhitresult.getLocation())) {
            Vec3 vec3 = blockhitresult.getLocation().subtract(p_365129_.getFrom());
            Direction direction = Direction.getApproximateNearest(vec3.x, vec3.y, vec3.z);
            Vec3 vec31 = worldborder.clampVec3ToBound(blockhitresult.getLocation());
            return new BlockHitResult(vec31, direction, BlockPos.containing(vec31), false, true);
        }
        return blockhitresult;
    }

    default public boolean collidesWithSuffocatingBlock(@Nullable Entity p_186438_, AABB p_186439_) {
        BlockCollisions<VoxelShape> blockcollisions = new BlockCollisions<VoxelShape>(this, p_186438_, p_186439_, true, (p_286211_, p_286212_) -> p_286212_);
        while (blockcollisions.hasNext()) {
            if (((VoxelShape)blockcollisions.next()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    default public Optional<BlockPos> findSupportingBlock(Entity p_286468_, AABB p_286792_) {
        BlockPos blockpos = null;
        double d0 = Double.MAX_VALUE;
        BlockCollisions<BlockPos> blockcollisions = new BlockCollisions<BlockPos>(this, p_286468_, p_286792_, false, (p_286213_, p_286214_) -> p_286213_);
        while (blockcollisions.hasNext()) {
            BlockPos blockpos1 = (BlockPos)blockcollisions.next();
            double d1 = blockpos1.distToCenterSqr(p_286468_.position());
            if (!(d1 < d0) && (d1 != d0 || blockpos != null && blockpos.compareTo(blockpos1) >= 0)) continue;
            blockpos = blockpos1.immutable();
            d0 = d1;
        }
        return Optional.ofNullable(blockpos);
    }

    default public Optional<Vec3> findFreePosition(@Nullable Entity p_151419_, VoxelShape p_151420_, Vec3 p_151421_, double p_151422_, double p_151423_, double p_151424_) {
        if (p_151420_.isEmpty()) {
            return Optional.empty();
        }
        AABB aabb = p_151420_.bounds().inflate(p_151422_, p_151423_, p_151424_);
        VoxelShape voxelshape = StreamSupport.stream(this.getBlockCollisions(p_151419_, aabb).spliterator(), false).filter(p_186430_ -> this.getWorldBorder() == null || this.getWorldBorder().isWithinBounds(p_186430_.bounds())).flatMap(p_186426_ -> p_186426_.toAabbs().stream()).map(p_186424_ -> p_186424_.inflate(p_151422_ / 2.0, p_151423_ / 2.0, p_151424_ / 2.0)).map(Shapes::create).reduce(Shapes.empty(), Shapes::or);
        VoxelShape voxelshape1 = Shapes.join(p_151420_, voxelshape, BooleanOp.ONLY_FIRST);
        return voxelshape1.closestPointTo(p_151421_);
    }
}

