/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment.trim;

import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;

public class TrimMaterials {
    public static final ResourceKey<TrimMaterial> QUARTZ = TrimMaterials.registryKey("quartz");
    public static final ResourceKey<TrimMaterial> IRON = TrimMaterials.registryKey("iron");
    public static final ResourceKey<TrimMaterial> NETHERITE = TrimMaterials.registryKey("netherite");
    public static final ResourceKey<TrimMaterial> REDSTONE = TrimMaterials.registryKey("redstone");
    public static final ResourceKey<TrimMaterial> COPPER = TrimMaterials.registryKey("copper");
    public static final ResourceKey<TrimMaterial> GOLD = TrimMaterials.registryKey("gold");
    public static final ResourceKey<TrimMaterial> EMERALD = TrimMaterials.registryKey("emerald");
    public static final ResourceKey<TrimMaterial> DIAMOND = TrimMaterials.registryKey("diamond");
    public static final ResourceKey<TrimMaterial> LAPIS = TrimMaterials.registryKey("lapis");
    public static final ResourceKey<TrimMaterial> AMETHYST = TrimMaterials.registryKey("amethyst");
    public static final ResourceKey<TrimMaterial> RESIN = TrimMaterials.registryKey("resin");

    public static void bootstrap(BootstrapContext<TrimMaterial> p_371627_) {
        TrimMaterials.register(p_371627_, QUARTZ, Style.EMPTY.withColor(14931140), MaterialAssetGroup.QUARTZ);
        TrimMaterials.register(p_371627_, IRON, Style.EMPTY.withColor(0xECECEC), MaterialAssetGroup.IRON);
        TrimMaterials.register(p_371627_, NETHERITE, Style.EMPTY.withColor(6445145), MaterialAssetGroup.NETHERITE);
        TrimMaterials.register(p_371627_, REDSTONE, Style.EMPTY.withColor(9901575), MaterialAssetGroup.REDSTONE);
        TrimMaterials.register(p_371627_, COPPER, Style.EMPTY.withColor(11823181), MaterialAssetGroup.COPPER);
        TrimMaterials.register(p_371627_, GOLD, Style.EMPTY.withColor(14594349), MaterialAssetGroup.GOLD);
        TrimMaterials.register(p_371627_, EMERALD, Style.EMPTY.withColor(1155126), MaterialAssetGroup.EMERALD);
        TrimMaterials.register(p_371627_, DIAMOND, Style.EMPTY.withColor(7269586), MaterialAssetGroup.DIAMOND);
        TrimMaterials.register(p_371627_, LAPIS, Style.EMPTY.withColor(4288151), MaterialAssetGroup.LAPIS);
        TrimMaterials.register(p_371627_, AMETHYST, Style.EMPTY.withColor(10116294), MaterialAssetGroup.AMETHYST);
        TrimMaterials.register(p_371627_, RESIN, Style.EMPTY.withColor(16545810), MaterialAssetGroup.RESIN);
    }

    public static Optional<Holder<TrimMaterial>> getFromIngredient(HolderLookup.Provider p_371665_, ItemStack p_371700_) {
        ProvidesTrimMaterial providestrimmaterial = p_371700_.get(DataComponents.PROVIDES_TRIM_MATERIAL);
        return providestrimmaterial != null ? providestrimmaterial.unwrap(p_371665_) : Optional.empty();
    }

    private static void register(BootstrapContext<TrimMaterial> p_371763_, ResourceKey<TrimMaterial> p_371867_, Style p_371730_, MaterialAssetGroup p_399962_) {
        MutableComponent component = Component.translatable(Util.makeDescriptionId("trim_material", p_371867_.location())).withStyle(p_371730_);
        p_371763_.register(p_371867_, new TrimMaterial(p_399962_, component));
    }

    private static ResourceKey<TrimMaterial> registryKey(String p_371483_) {
        return ResourceKey.create(Registries.TRIM_MATERIAL, ResourceLocation.withDefaultNamespace(p_371483_));
    }
}

