/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;

public interface LevelBasedValue {
    public static final Codec<LevelBasedValue> DISPATCH_CODEC = BuiltInRegistries.ENCHANTMENT_LEVEL_BASED_VALUE_TYPE.byNameCodec().dispatch(LevelBasedValue::codec, p_346236_ -> p_346236_);
    public static final Codec<LevelBasedValue> CODEC = Codec.either(Constant.CODEC, DISPATCH_CODEC).xmap(p_345066_ -> (LevelBasedValue)p_345066_.map(p_345590_ -> p_345590_, p_346044_ -> p_346044_), p_346307_ -> {
        Either either;
        if (p_346307_ instanceof Constant) {
            Constant levelbasedvalue$constant = (Constant)p_346307_;
            either = Either.left((Object)levelbasedvalue$constant);
        } else {
            either = Either.right((Object)p_346307_);
        }
        return either;
    });

    public static MapCodec<? extends LevelBasedValue> bootstrap(Registry<MapCodec<? extends LevelBasedValue>> p_345955_) {
        Registry.register(p_345955_, "clamped", Clamped.CODEC);
        Registry.register(p_345955_, "fraction", Fraction.CODEC);
        Registry.register(p_345955_, "levels_squared", LevelsSquared.CODEC);
        Registry.register(p_345955_, "linear", Linear.CODEC);
        return Registry.register(p_345955_, "lookup", Lookup.CODEC);
    }

    public static Constant constant(float p_344768_) {
        return new Constant(p_344768_);
    }

    public static Linear perLevel(float p_346188_, float p_346397_) {
        return new Linear(p_346188_, p_346397_);
    }

    public static Linear perLevel(float p_345221_) {
        return LevelBasedValue.perLevel(p_345221_, p_345221_);
    }

    public static Lookup lookup(List<Float> p_352164_, LevelBasedValue p_352467_) {
        return new Lookup(p_352164_, p_352467_);
    }

    public float calculate(int var1);

    public MapCodec<? extends LevelBasedValue> codec();

    public record Clamped(LevelBasedValue value, float min, float max) implements LevelBasedValue
    {
        public static final MapCodec<Clamped> CODEC = RecordCodecBuilder.mapCodec(p_345501_ -> p_345501_.group((App)CODEC.fieldOf("value").forGetter(Clamped::value), (App)Codec.FLOAT.fieldOf("min").forGetter(Clamped::min), (App)Codec.FLOAT.fieldOf("max").forGetter(Clamped::max)).apply((Applicative)p_345501_, Clamped::new)).validate(p_345949_ -> p_345949_.max <= p_345949_.min ? DataResult.error(() -> "Max must be larger than min, min: " + p_345949_.min + ", max: " + p_345949_.max) : DataResult.success((Object)p_345949_));

        @Override
        public float calculate(int p_345820_) {
            return Mth.clamp(this.value.calculate(p_345820_), this.min, this.max);
        }

        public MapCodec<Clamped> codec() {
            return CODEC;
        }
    }

    public record Fraction(LevelBasedValue numerator, LevelBasedValue denominator) implements LevelBasedValue
    {
        public static final MapCodec<Fraction> CODEC = RecordCodecBuilder.mapCodec(p_344815_ -> p_344815_.group((App)CODEC.fieldOf("numerator").forGetter(Fraction::numerator), (App)CODEC.fieldOf("denominator").forGetter(Fraction::denominator)).apply((Applicative)p_344815_, Fraction::new));

        @Override
        public float calculate(int p_345976_) {
            float f = this.denominator.calculate(p_345976_);
            return f == 0.0f ? 0.0f : this.numerator.calculate(p_345976_) / f;
        }

        public MapCodec<Fraction> codec() {
            return CODEC;
        }
    }

    public record LevelsSquared(float added) implements LevelBasedValue
    {
        public static final MapCodec<LevelsSquared> CODEC = RecordCodecBuilder.mapCodec(p_345289_ -> p_345289_.group((App)Codec.FLOAT.fieldOf("added").forGetter(LevelsSquared::added)).apply((Applicative)p_345289_, LevelsSquared::new));

        @Override
        public float calculate(int p_344759_) {
            return (float)Mth.square(p_344759_) + this.added;
        }

        public MapCodec<LevelsSquared> codec() {
            return CODEC;
        }
    }

    public record Linear(float base, float perLevelAboveFirst) implements LevelBasedValue
    {
        public static final MapCodec<Linear> CODEC = RecordCodecBuilder.mapCodec(p_346144_ -> p_346144_.group((App)Codec.FLOAT.fieldOf("base").forGetter(Linear::base), (App)Codec.FLOAT.fieldOf("per_level_above_first").forGetter(Linear::perLevelAboveFirst)).apply((Applicative)p_346144_, Linear::new));

        @Override
        public float calculate(int p_345943_) {
            return this.base + this.perLevelAboveFirst * (float)(p_345943_ - 1);
        }

        public MapCodec<Linear> codec() {
            return CODEC;
        }
    }

    public record Lookup(List<Float> values, LevelBasedValue fallback) implements LevelBasedValue
    {
        public static final MapCodec<Lookup> CODEC = RecordCodecBuilder.mapCodec(p_352084_ -> p_352084_.group((App)Codec.FLOAT.listOf().fieldOf("values").forGetter(Lookup::values), (App)CODEC.fieldOf("fallback").forGetter(Lookup::fallback)).apply((Applicative)p_352084_, Lookup::new));

        @Override
        public float calculate(int p_352377_) {
            return p_352377_ <= this.values.size() ? this.values.get(p_352377_ - 1).floatValue() : this.fallback.calculate(p_352377_);
        }

        public MapCodec<Lookup> codec() {
            return CODEC;
        }
    }

    public record Constant(float value) implements LevelBasedValue
    {
        public static final Codec<Constant> CODEC = Codec.FLOAT.xmap(Constant::new, Constant::value);
        public static final MapCodec<Constant> TYPED_CODEC = RecordCodecBuilder.mapCodec(p_344772_ -> p_344772_.group((App)Codec.FLOAT.fieldOf("value").forGetter(Constant::value)).apply((Applicative)p_344772_, Constant::new));

        @Override
        public float calculate(int p_346274_) {
            return this.value;
        }

        public MapCodec<Constant> codec() {
            return TYPED_CODEC;
        }
    }
}

