/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;

public class ItemEnchantments
implements TooltipProvider {
    public static final ItemEnchantments EMPTY = new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap());
    private static final Codec<Integer> LEVEL_CODEC = Codec.intRange((int)1, (int)255);
    public static final Codec<ItemEnchantments> CODEC = Codec.unboundedMap(Enchantment.CODEC, LEVEL_CODEC).xmap(p_399435_ -> new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap(p_399435_)), p_340785_ -> p_340785_.enchantments);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantments> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.map(Object2IntOpenHashMap::new, Enchantment.STREAM_CODEC, ByteBufCodecs.VAR_INT), p_340784_ -> p_340784_.enchantments, ItemEnchantments::new);
    final Object2IntOpenHashMap<Holder<Enchantment>> enchantments;

    ItemEnchantments(Object2IntOpenHashMap<Holder<Enchantment>> p_341287_) {
        this.enchantments = p_341287_;
        for (Object2IntMap.Entry entry : p_341287_.object2IntEntrySet()) {
            int i = entry.getIntValue();
            if (i >= 0 && i <= 255) continue;
            throw new IllegalArgumentException("Enchantment " + String.valueOf(entry.getKey()) + " has invalid level " + i);
        }
    }

    public int getLevel(Holder<Enchantment> p_345693_) {
        return this.enchantments.getInt(p_345693_);
    }

    @Override
    public void addToTooltip(Item.TooltipContext p_341290_, Consumer<Component> p_331119_, TooltipFlag p_330400_, DataComponentGetter p_400004_) {
        HolderLookup.Provider holderlookup$provider = p_341290_.registries();
        HolderSet<Enchantment> holderset = ItemEnchantments.getTagOrEmpty(holderlookup$provider, Registries.ENCHANTMENT, EnchantmentTags.TOOLTIP_ORDER);
        for (Holder holder : holderset) {
            int i = this.enchantments.getInt((Object)holder);
            if (i <= 0) continue;
            p_331119_.accept(Enchantment.getFullname(holder, i));
        }
        for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
            Holder holder1 = (Holder)entry.getKey();
            if (holderset.contains(holder1)) continue;
            p_331119_.accept(Enchantment.getFullname((Holder)entry.getKey(), entry.getIntValue()));
        }
    }

    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.Provider p_341186_, ResourceKey<Registry<T>> p_341113_, TagKey<T> p_341409_) {
        Optional<HolderSet.Named<T>> optional;
        if (p_341186_ != null && (optional = p_341186_.lookupOrThrow(p_341113_).get(p_341409_)).isPresent()) {
            return optional.get();
        }
        return HolderSet.direct(new Holder[0]);
    }

    public Set<Holder<Enchantment>> keySet() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<Enchantment>>> entrySet() {
        return Collections.unmodifiableSet(this.enchantments.object2IntEntrySet());
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    public boolean equals(Object p_331697_) {
        boolean bl;
        if (this == p_331697_) {
            return true;
        }
        if (p_331697_ instanceof ItemEnchantments) {
            ItemEnchantments itemenchantments = (ItemEnchantments)p_331697_;
            bl = this.enchantments.equals(itemenchantments.enchantments);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.enchantments.hashCode();
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + String.valueOf(this.enchantments) + "}";
    }

    public static class Mutable {
        private final Object2IntOpenHashMap<Holder<Enchantment>> enchantments = new Object2IntOpenHashMap();

        public Mutable(ItemEnchantments p_330722_) {
            this.enchantments.putAll(p_330722_.enchantments);
        }

        public void set(Holder<Enchantment> p_344861_, int p_330832_) {
            if (p_330832_ <= 0) {
                this.enchantments.removeInt(p_344861_);
            } else {
                this.enchantments.put(p_344861_, Math.min(p_330832_, 255));
            }
        }

        public void upgrade(Holder<Enchantment> p_346263_, int p_331153_) {
            if (p_331153_ > 0) {
                this.enchantments.merge(p_346263_, Math.min(p_331153_, 255), Integer::max);
            }
        }

        public void removeIf(Predicate<Holder<Enchantment>> p_332079_) {
            this.enchantments.keySet().removeIf(p_332079_);
        }

        public int getLevel(Holder<Enchantment> p_345430_) {
            return this.enchantments.getOrDefault(p_345430_, 0);
        }

        public Set<Holder<Enchantment>> keySet() {
            return this.enchantments.keySet();
        }

        public ItemEnchantments toImmutable() {
            return new ItemEnchantments(this.enchantments);
        }
    }
}

