/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FireworkStarRecipe
extends CustomRecipe {
    private static final Map<Item, FireworkExplosion.Shape> SHAPE_BY_ITEM = Map.of(Items.FIRE_CHARGE, FireworkExplosion.Shape.LARGE_BALL, Items.FEATHER, FireworkExplosion.Shape.BURST, Items.GOLD_NUGGET, FireworkExplosion.Shape.STAR, Items.SKELETON_SKULL, FireworkExplosion.Shape.CREEPER, Items.WITHER_SKELETON_SKULL, FireworkExplosion.Shape.CREEPER, Items.CREEPER_HEAD, FireworkExplosion.Shape.CREEPER, Items.PLAYER_HEAD, FireworkExplosion.Shape.CREEPER, Items.DRAGON_HEAD, FireworkExplosion.Shape.CREEPER, Items.ZOMBIE_HEAD, FireworkExplosion.Shape.CREEPER, Items.PIGLIN_HEAD, FireworkExplosion.Shape.CREEPER);
    private static final Ingredient TRAIL_INGREDIENT = Ingredient.of((ItemLike)Items.DIAMOND);
    private static final Ingredient TWINKLE_INGREDIENT = Ingredient.of((ItemLike)Items.GLOWSTONE_DUST);
    private static final Ingredient GUNPOWDER_INGREDIENT = Ingredient.of((ItemLike)Items.GUNPOWDER);

    public FireworkStarRecipe(CraftingBookCategory p_251577_) {
        super(p_251577_);
    }

    @Override
    public boolean matches(CraftingInput p_344993_, Level p_43896_) {
        if (p_344993_.ingredientCount() < 2) {
            return false;
        }
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        for (int i = 0; i < p_344993_.size(); ++i) {
            ItemStack itemstack = p_344993_.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (SHAPE_BY_ITEM.containsKey(itemstack.getItem())) {
                if (flag2) {
                    return false;
                }
                flag2 = true;
                continue;
            }
            if (TWINKLE_INGREDIENT.test(itemstack)) {
                if (flag4) {
                    return false;
                }
                flag4 = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test(itemstack)) {
                if (flag3) {
                    return false;
                }
                flag3 = true;
                continue;
            }
            if (GUNPOWDER_INGREDIENT.test(itemstack)) {
                if (flag) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (!(itemstack.getItem() instanceof DyeItem)) {
                return false;
            }
            flag1 = true;
        }
        return flag && flag1;
    }

    @Override
    public ItemStack assemble(CraftingInput p_346206_, HolderLookup.Provider p_335498_) {
        FireworkExplosion.Shape fireworkexplosion$shape = FireworkExplosion.Shape.SMALL_BALL;
        boolean flag = false;
        boolean flag1 = false;
        IntArrayList intlist = new IntArrayList();
        for (int i = 0; i < p_346206_.size(); ++i) {
            ItemStack itemstack = p_346206_.getItem(i);
            if (itemstack.isEmpty()) continue;
            FireworkExplosion.Shape fireworkexplosion$shape1 = SHAPE_BY_ITEM.get(itemstack.getItem());
            if (fireworkexplosion$shape1 != null) {
                fireworkexplosion$shape = fireworkexplosion$shape1;
                continue;
            }
            if (TWINKLE_INGREDIENT.test(itemstack)) {
                flag = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test(itemstack)) {
                flag1 = true;
                continue;
            }
            Item item = itemstack.getItem();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeitem = (DyeItem)item;
            intlist.add(dyeitem.getDyeColor().getFireworkColor());
        }
        ItemStack itemstack1 = new ItemStack(Items.FIREWORK_STAR);
        itemstack1.set(DataComponents.FIREWORK_EXPLOSION, new FireworkExplosion(fireworkexplosion$shape, (IntList)intlist, IntList.of(), flag1, flag));
        return itemstack1;
    }

    @Override
    public RecipeSerializer<FireworkStarRecipe> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR;
    }
}

