/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FireworkStarFadeRecipe
extends CustomRecipe {
    private static final Ingredient STAR_INGREDIENT = Ingredient.of((ItemLike)Items.FIREWORK_STAR);

    public FireworkStarFadeRecipe(CraftingBookCategory p_251846_) {
        super(p_251846_);
    }

    @Override
    public boolean matches(CraftingInput p_346021_, Level p_43874_) {
        if (p_346021_.ingredientCount() < 2) {
            return false;
        }
        boolean flag = false;
        boolean flag1 = false;
        for (int i = 0; i < p_346021_.size(); ++i) {
            ItemStack itemstack = p_346021_.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (itemstack.getItem() instanceof DyeItem) {
                flag = true;
                continue;
            }
            if (!STAR_INGREDIENT.test(itemstack)) {
                return false;
            }
            if (flag1) {
                return false;
            }
            flag1 = true;
        }
        return flag1 && flag;
    }

    @Override
    public ItemStack assemble(CraftingInput p_346017_, HolderLookup.Provider p_335705_) {
        IntArrayList intlist = new IntArrayList();
        ItemStack itemstack = null;
        for (int i = 0; i < p_346017_.size(); ++i) {
            ItemStack itemstack1 = p_346017_.getItem(i);
            Item item = itemstack1.getItem();
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                intlist.add(dyeitem.getDyeColor().getFireworkColor());
                continue;
            }
            if (!STAR_INGREDIENT.test(itemstack1)) continue;
            itemstack = itemstack1.copyWithCount(1);
        }
        if (itemstack != null && !intlist.isEmpty()) {
            itemstack.update(DataComponents.FIREWORK_EXPLOSION, FireworkExplosion.DEFAULT, intlist, FireworkExplosion::withFadeColors);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public RecipeSerializer<FireworkStarFadeRecipe> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR_FADE;
    }
}

