/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FireworkRocketRecipe
extends CustomRecipe {
    private static final Ingredient PAPER_INGREDIENT = Ingredient.of((ItemLike)Items.PAPER);
    private static final Ingredient GUNPOWDER_INGREDIENT = Ingredient.of((ItemLike)Items.GUNPOWDER);
    private static final Ingredient STAR_INGREDIENT = Ingredient.of((ItemLike)Items.FIREWORK_STAR);

    public FireworkRocketRecipe(CraftingBookCategory p_250134_) {
        super(p_250134_);
    }

    @Override
    public boolean matches(CraftingInput p_345559_, Level p_43855_) {
        if (p_345559_.ingredientCount() < 2) {
            return false;
        }
        boolean flag = false;
        int i = 0;
        for (int j = 0; j < p_345559_.size(); ++j) {
            ItemStack itemstack = p_345559_.getItem(j);
            if (itemstack.isEmpty()) continue;
            if (PAPER_INGREDIENT.test(itemstack)) {
                if (flag) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (!(GUNPOWDER_INGREDIENT.test(itemstack) ? ++i > 3 : !STAR_INGREDIENT.test(itemstack))) continue;
            return false;
        }
        return flag && i >= 1;
    }

    @Override
    public ItemStack assemble(CraftingInput p_345921_, HolderLookup.Provider p_335560_) {
        ArrayList<FireworkExplosion> list = new ArrayList<FireworkExplosion>();
        int i = 0;
        for (int j = 0; j < p_345921_.size(); ++j) {
            FireworkExplosion fireworkexplosion;
            ItemStack itemstack = p_345921_.getItem(j);
            if (itemstack.isEmpty()) continue;
            if (GUNPOWDER_INGREDIENT.test(itemstack)) {
                ++i;
                continue;
            }
            if (!STAR_INGREDIENT.test(itemstack) || (fireworkexplosion = itemstack.get(DataComponents.FIREWORK_EXPLOSION)) == null) continue;
            list.add(fireworkexplosion);
        }
        ItemStack itemstack1 = new ItemStack(Items.FIREWORK_ROCKET, 3);
        itemstack1.set(DataComponents.FIREWORKS, new Fireworks(i, list));
        return itemstack1;
    }

    @Override
    public RecipeSerializer<FireworkRocketRecipe> getSerializer() {
        return RecipeSerializer.FIREWORK_ROCKET;
    }
}

