/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public interface CraftingRecipe
extends Recipe<CraftingInput> {
    @Override
    default public RecipeType<CraftingRecipe> getType() {
        return RecipeType.CRAFTING;
    }

    @Override
    public RecipeSerializer<? extends CraftingRecipe> getSerializer();

    public CraftingBookCategory category();

    default public NonNullList<ItemStack> getRemainingItems(CraftingInput p_380110_) {
        return CraftingRecipe.defaultCraftingReminder(p_380110_);
    }

    public static NonNullList<ItemStack> defaultCraftingReminder(CraftingInput p_380223_) {
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(p_380223_.size(), ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = p_380223_.getItem(i);
            nonnulllist.set(i, item.getCraftingRemainder());
        }
        return nonnulllist;
    }

    @Override
    default public RecipeBookCategory recipeBookCategory() {
        return switch (this.category()) {
            default -> throw new MatchException(null, null);
            case CraftingBookCategory.BUILDING -> RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
            case CraftingBookCategory.EQUIPMENT -> RecipeBookCategories.CRAFTING_EQUIPMENT;
            case CraftingBookCategory.REDSTONE -> RecipeBookCategories.CRAFTING_REDSTONE;
            case CraftingBookCategory.MISC -> RecipeBookCategories.CRAFTING_MISC;
        };
    }
}

