/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ArmorDyeRecipe
extends CustomRecipe {
    public ArmorDyeRecipe(CraftingBookCategory p_251949_) {
        super(p_251949_);
    }

    @Override
    public boolean matches(CraftingInput p_344736_, Level p_43770_) {
        if (p_344736_.ingredientCount() < 2) {
            return false;
        }
        boolean flag = false;
        boolean flag1 = false;
        for (int i = 0; i < p_344736_.size(); ++i) {
            ItemStack itemstack = p_344736_.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (itemstack.is(ItemTags.DYEABLE)) {
                if (flag) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (!(itemstack.getItem() instanceof DyeItem)) {
                return false;
            }
            flag1 = true;
        }
        return flag1 && flag;
    }

    @Override
    public ItemStack assemble(CraftingInput p_344909_, HolderLookup.Provider p_335722_) {
        ArrayList<DyeItem> list = new ArrayList<DyeItem>();
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < p_344909_.size(); ++i) {
            ItemStack itemstack1 = p_344909_.getItem(i);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.is(ItemTags.DYEABLE)) {
                if (!itemstack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                itemstack = itemstack1.copy();
                continue;
            }
            Item item = itemstack1.getItem();
            if (!(item instanceof DyeItem)) {
                return ItemStack.EMPTY;
            }
            DyeItem dyeitem = (DyeItem)item;
            list.add(dyeitem);
        }
        return !itemstack.isEmpty() && !list.isEmpty() ? DyedItemColor.applyDyes(itemstack, list) : ItemStack.EMPTY;
    }

    @Override
    public RecipeSerializer<ArmorDyeRecipe> getSerializer() {
        return RecipeSerializer.ARMOR_DYE;
    }
}

