/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public record ResolvableProfile(Optional<String> name, Optional<UUID> id, PropertyMap properties, GameProfile gameProfile) {
    private static final Codec<ResolvableProfile> FULL_CODEC = RecordCodecBuilder.create(p_337950_ -> p_337950_.group((App)ExtraCodecs.PLAYER_NAME.optionalFieldOf("name").forGetter(ResolvableProfile::name), (App)UUIDUtil.CODEC.optionalFieldOf("id").forGetter(ResolvableProfile::id), (App)ExtraCodecs.PROPERTY_MAP.optionalFieldOf("properties", (Object)new PropertyMap()).forGetter(ResolvableProfile::properties)).apply((Applicative)p_337950_, ResolvableProfile::new));
    public static final Codec<ResolvableProfile> CODEC = Codec.withAlternative(FULL_CODEC, ExtraCodecs.PLAYER_NAME, p_332623_ -> new ResolvableProfile(Optional.of(p_332623_), Optional.empty(), new PropertyMap()));
    public static final StreamCodec<ByteBuf, ResolvableProfile> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.stringUtf8(16).apply(ByteBufCodecs::optional), ResolvableProfile::name, UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), ResolvableProfile::id, ByteBufCodecs.GAME_PROFILE_PROPERTIES, ResolvableProfile::properties, ResolvableProfile::new);

    public ResolvableProfile(Optional<String> p_330853_, Optional<UUID> p_332668_, PropertyMap p_331206_) {
        this(p_330853_, p_332668_, p_331206_, ResolvableProfile.createGameProfile(p_332668_, p_330853_, p_331206_));
    }

    public ResolvableProfile(GameProfile p_332009_) {
        this(Optional.of(p_332009_.getName()), Optional.of(p_332009_.getId()), p_332009_.getProperties(), p_332009_);
    }

    @Nullable
    public ResolvableProfile pollResolve() {
        if (this.isResolved()) {
            return this;
        }
        Optional optional = this.id.isPresent() ? (Optional)SkullBlockEntity.fetchGameProfile(this.id.get()).getNow(null) : (Optional)SkullBlockEntity.fetchGameProfile(this.name.orElseThrow()).getNow(null);
        return optional != null ? this.createProfile(optional) : null;
    }

    public CompletableFuture<ResolvableProfile> resolve() {
        if (this.isResolved()) {
            return CompletableFuture.completedFuture(this);
        }
        return this.id.isPresent() ? SkullBlockEntity.fetchGameProfile(this.id.get()).thenApply(this::createProfile) : SkullBlockEntity.fetchGameProfile(this.name.orElseThrow()).thenApply(this::createProfile);
    }

    private ResolvableProfile createProfile(Optional<GameProfile> p_331092_) {
        return new ResolvableProfile(p_331092_.orElseGet(() -> ResolvableProfile.createGameProfile(this.id, this.name)));
    }

    private static GameProfile createGameProfile(Optional<UUID> p_428217_, Optional<String> p_428238_) {
        return new GameProfile(p_428217_.orElse(Util.NIL_UUID), p_428238_.orElse(""));
    }

    private static GameProfile createGameProfile(Optional<UUID> p_428331_, Optional<String> p_428348_, PropertyMap p_428508_) {
        GameProfile gameprofile = ResolvableProfile.createGameProfile(p_428331_, p_428348_);
        gameprofile.getProperties().putAll((Multimap)p_428508_);
        return gameprofile;
    }

    public boolean isResolved() {
        return !this.properties.isEmpty() ? true : this.id.isPresent() == this.name.isPresent();
    }
}

