/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.function.TriConsumer;

public record ItemAttributeModifiers(List<Entry> modifiers) {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(List.of());
    public static final Codec<ItemAttributeModifiers> CODEC = Entry.CODEC.listOf().xmap(ItemAttributeModifiers::new, ItemAttributeModifiers::modifiers);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> STREAM_CODEC = StreamCodec.composite(Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemAttributeModifiers::modifiers, ItemAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = Util.make(new DecimalFormat("#.##"), p_331600_ -> p_331600_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public static Builder builder() {
        return new Builder();
    }

    public ItemAttributeModifiers withModifierAdded(Holder<Attribute> p_330266_, AttributeModifier p_331954_, EquipmentSlotGroup p_332175_) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry itemattributemodifiers$entry : this.modifiers) {
            if (itemattributemodifiers$entry.matches(p_330266_, p_331954_.id())) continue;
            builder.add((Object)itemattributemodifiers$entry);
        }
        builder.add((Object)new Entry(p_330266_, p_331954_, p_332175_));
        return new ItemAttributeModifiers((List<Entry>)builder.build());
    }

    public void forEach(EquipmentSlotGroup p_416672_, TriConsumer<Holder<Attribute>, AttributeModifier, Display> p_416076_) {
        for (Entry itemattributemodifiers$entry : this.modifiers) {
            if (!itemattributemodifiers$entry.slot.equals(p_416672_)) continue;
            p_416076_.accept(itemattributemodifiers$entry.attribute, (Object)itemattributemodifiers$entry.modifier, (Object)itemattributemodifiers$entry.display);
        }
    }

    public void forEach(EquipmentSlotGroup p_348576_, BiConsumer<Holder<Attribute>, AttributeModifier> p_348660_) {
        for (Entry itemattributemodifiers$entry : this.modifiers) {
            if (!itemattributemodifiers$entry.slot.equals(p_348576_)) continue;
            p_348660_.accept(itemattributemodifiers$entry.attribute, itemattributemodifiers$entry.modifier);
        }
    }

    public void forEach(EquipmentSlot p_332158_, BiConsumer<Holder<Attribute>, AttributeModifier> p_331684_) {
        for (Entry itemattributemodifiers$entry : this.modifiers) {
            if (!itemattributemodifiers$entry.slot.test(p_332158_)) continue;
            p_331684_.accept(itemattributemodifiers$entry.attribute, itemattributemodifiers$entry.modifier);
        }
    }

    public double compute(double p_330928_, EquipmentSlot p_330945_) {
        double d0 = p_330928_;
        for (Entry itemattributemodifiers$entry : this.modifiers) {
            if (!itemattributemodifiers$entry.slot.test(p_330945_)) continue;
            double d1 = itemattributemodifiers$entry.modifier.amount();
            d0 += (switch (itemattributemodifiers$entry.modifier.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> d1;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> d1 * p_330928_;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d1 * d0;
            });
        }
        return d0;
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> p_330324_, AttributeModifier p_331766_, EquipmentSlotGroup p_331205_) {
            this.entries.add((Object)new Entry(p_330324_, p_331766_, p_331205_));
            return this;
        }

        public Builder add(Holder<Attribute> p_416496_, AttributeModifier p_416176_, EquipmentSlotGroup p_415827_, Display p_416422_) {
            this.entries.add((Object)new Entry(p_416496_, p_416176_, p_415827_, p_416422_));
            return this;
        }

        public ItemAttributeModifiers build() {
            return new ItemAttributeModifiers((List<Entry>)this.entries.build());
        }
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot, Display display) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(p_419448_ -> p_419448_.group((App)Attribute.CODEC.fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot", (Object)EquipmentSlotGroup.ANY).forGetter(Entry::slot), (App)Display.CODEC.optionalFieldOf("display", (Object)Display.Default.INSTANCE).forGetter(Entry::display)).apply((Applicative)p_419448_, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite(Attribute.STREAM_CODEC, Entry::attribute, AttributeModifier.STREAM_CODEC, Entry::modifier, EquipmentSlotGroup.STREAM_CODEC, Entry::slot, Display.STREAM_CODEC, Entry::display, Entry::new);

        public Entry(Holder<Attribute> p_330366_, AttributeModifier p_332188_, EquipmentSlotGroup p_331685_) {
            this(p_330366_, p_332188_, p_331685_, Display.attributeModifiers());
        }

        public boolean matches(Holder<Attribute> p_350582_, ResourceLocation p_350416_) {
            return p_350582_.equals(this.attribute) && this.modifier.is(p_350416_);
        }
    }

    public static interface Display {
        public static final Codec<Display> CODEC = Type.CODEC.dispatch("type", Display::type, p_416469_ -> p_416469_.codec);
        public static final StreamCodec<RegistryFriendlyByteBuf, Display> STREAM_CODEC = Type.STREAM_CODEC.cast().dispatch(Display::type, Type::streamCodec);

        public static Display attributeModifiers() {
            return Default.INSTANCE;
        }

        public static Display hidden() {
            return Hidden.INSTANCE;
        }

        public static Display override(Component p_415903_) {
            return new OverrideText(p_415903_);
        }

        public Type type();

        public void apply(Consumer<Component> var1, @Nullable Player var2, Holder<Attribute> var3, AttributeModifier var4);

        public record Default() implements Display
        {
            static final Default INSTANCE = new Default();
            static final MapCodec<Default> CODEC = MapCodec.unit((Object)INSTANCE);
            static final StreamCodec<RegistryFriendlyByteBuf, Default> STREAM_CODEC = StreamCodec.unit(INSTANCE);

            @Override
            public Type type() {
                return Type.DEFAULT;
            }

            @Override
            public void apply(Consumer<Component> p_415634_, @Nullable Player p_415547_, Holder<Attribute> p_416596_, AttributeModifier p_415942_) {
                double d0 = p_415942_.amount();
                boolean flag = false;
                if (p_415547_ != null) {
                    if (p_415942_.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                        d0 += p_415547_.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                        flag = true;
                    } else if (p_415942_.is(Item.BASE_ATTACK_SPEED_ID)) {
                        d0 += p_415547_.getAttributeBaseValue(Attributes.ATTACK_SPEED);
                        flag = true;
                    }
                }
                double d1 = p_415942_.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || p_415942_.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? d0 * 100.0 : (p_416596_.is(Attributes.KNOCKBACK_RESISTANCE) ? d0 * 10.0 : d0);
                if (flag) {
                    p_415634_.accept(CommonComponents.space().append(Component.translatable("attribute.modifier.equals." + p_415942_.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable(p_416596_.value().getDescriptionId()))).withStyle(ChatFormatting.DARK_GREEN));
                } else if (d0 > 0.0) {
                    p_415634_.accept(Component.translatable("attribute.modifier.plus." + p_415942_.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable(p_416596_.value().getDescriptionId())).withStyle(p_416596_.value().getStyle(true)));
                } else if (d0 < 0.0) {
                    p_415634_.accept(Component.translatable("attribute.modifier.take." + p_415942_.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(-d1), Component.translatable(p_416596_.value().getDescriptionId())).withStyle(p_416596_.value().getStyle(false)));
                }
            }
        }

        public record Hidden() implements Display
        {
            static final Hidden INSTANCE = new Hidden();
            static final MapCodec<Hidden> CODEC = MapCodec.unit((Object)INSTANCE);
            static final StreamCodec<RegistryFriendlyByteBuf, Hidden> STREAM_CODEC = StreamCodec.unit(INSTANCE);

            @Override
            public Type type() {
                return Type.HIDDEN;
            }

            @Override
            public void apply(Consumer<Component> p_416397_, @Nullable Player p_415921_, Holder<Attribute> p_415720_, AttributeModifier p_416314_) {
            }
        }

        public record OverrideText(Component component) implements Display
        {
            static final MapCodec<OverrideText> CODEC = RecordCodecBuilder.mapCodec(p_416311_ -> p_416311_.group((App)ComponentSerialization.CODEC.fieldOf("value").forGetter(OverrideText::component)).apply((Applicative)p_416311_, OverrideText::new));
            static final StreamCodec<RegistryFriendlyByteBuf, OverrideText> STREAM_CODEC = StreamCodec.composite(ComponentSerialization.STREAM_CODEC, OverrideText::component, OverrideText::new);

            @Override
            public Type type() {
                return Type.OVERRIDE;
            }

            @Override
            public void apply(Consumer<Component> p_416508_, @Nullable Player p_416569_, Holder<Attribute> p_416290_, AttributeModifier p_416417_) {
                p_416508_.accept(this.component);
            }
        }

        public static enum Type implements StringRepresentable
        {
            DEFAULT("default", 0, Default.CODEC, Default.STREAM_CODEC),
            HIDDEN("hidden", 1, Hidden.CODEC, Hidden.STREAM_CODEC),
            OVERRIDE("override", 2, OverrideText.CODEC, OverrideText.STREAM_CODEC);

            static final Codec<Type> CODEC;
            private static final IntFunction<Type> BY_ID;
            static final StreamCodec<ByteBuf, Type> STREAM_CODEC;
            private final String name;
            private final int id;
            final MapCodec<? extends Display> codec;
            private final StreamCodec<RegistryFriendlyByteBuf, ? extends Display> streamCodec;

            private Type(String p_415852_, int p_416049_, MapCodec<? extends Display> p_416438_, StreamCodec<RegistryFriendlyByteBuf, ? extends Display> p_416142_) {
                this.name = p_415852_;
                this.id = p_416049_;
                this.codec = p_416438_;
                this.streamCodec = p_416142_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private int id() {
                return this.id;
            }

            private StreamCodec<RegistryFriendlyByteBuf, ? extends Display> streamCodec() {
                return this.streamCodec;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Type::values);
                BY_ID = ByIdMap.continuous(Type::id, Type.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
                STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Type::id);
            }
        }
    }
}

