/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public final class CustomData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomData EMPTY = new CustomData(new CompoundTag());
    private static final String TYPE_TAG = "id";
    public static final Codec<CustomData> CODEC = Codec.withAlternative(CompoundTag.CODEC, TagParser.FLATTENED_CODEC).xmap(CustomData::new, p_331996_ -> p_331996_.tag);
    public static final Codec<CustomData> CODEC_WITH_ID = CODEC.validate(p_409450_ -> p_409450_.getUnsafe().getString(TYPE_TAG).isPresent() ? DataResult.success((Object)p_409450_) : DataResult.error(() -> "Missing id for entity in: " + String.valueOf(p_409450_)));
    @Deprecated
    public static final StreamCodec<ByteBuf, CustomData> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(CustomData::new, p_331280_ -> p_331280_.tag);
    private final CompoundTag tag;

    private CustomData(CompoundTag p_331863_) {
        this.tag = p_331863_;
    }

    public static CustomData of(CompoundTag p_330724_) {
        return new CustomData(p_330724_.copy());
    }

    public boolean matchedBy(CompoundTag p_330550_) {
        return NbtUtils.compareNbt(p_330550_, this.tag, true);
    }

    public static void update(DataComponentType<CustomData> p_331895_, ItemStack p_332185_, Consumer<CompoundTag> p_331274_) {
        CustomData customdata = p_332185_.getOrDefault(p_331895_, EMPTY).update(p_331274_);
        if (customdata.tag.isEmpty()) {
            p_332185_.remove(p_331895_);
        } else {
            p_332185_.set(p_331895_, customdata);
        }
    }

    public static void set(DataComponentType<CustomData> p_330462_, ItemStack p_332015_, CompoundTag p_331019_) {
        if (!p_331019_.isEmpty()) {
            p_332015_.set(p_330462_, CustomData.of(p_331019_));
        } else {
            p_332015_.remove(p_330462_);
        }
    }

    public CustomData update(Consumer<CompoundTag> p_331451_) {
        CompoundTag compoundtag = this.tag.copy();
        p_331451_.accept(compoundtag);
        return new CustomData(compoundtag);
    }

    @Nullable
    public ResourceLocation parseEntityId() {
        return this.tag.read(TYPE_TAG, ResourceLocation.CODEC).orElse(null);
    }

    @Nullable
    public <T> T parseEntityType(HolderLookup.Provider p_390464_, ResourceKey<? extends Registry<T>> p_390439_) {
        ResourceLocation resourcelocation = this.parseEntityId();
        return resourcelocation == null ? null : p_390464_.lookup(p_390439_).flatMap(p_390316_ -> p_390316_.get(ResourceKey.create(p_390439_, resourcelocation))).map(Holder::value).orElse(null);
    }

    public void loadInto(Entity p_331834_) {
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(p_331834_.problemPath(), LOGGER);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter$scopedcollector, p_331834_.registryAccess());
            p_331834_.saveWithoutId(tagvalueoutput);
            CompoundTag compoundtag = tagvalueoutput.buildResult();
            UUID uuid = p_331834_.getUUID();
            compoundtag.merge(this.tag);
            p_331834_.load(TagValueInput.create((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)p_331834_.registryAccess(), compoundtag));
            p_331834_.setUUID(uuid);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean loadInto(BlockEntity p_331657_, HolderLookup.Provider p_331528_) {
        problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(p_331657_.problemPath(), CustomData.LOGGER);
        try {
            tagvalueoutput = TagValueOutput.createWithContext(problemreporter$scopedcollector, p_331528_);
            p_331657_.saveCustomOnly(tagvalueoutput);
            compoundtag = tagvalueoutput.buildResult();
            compoundtag1 = compoundtag.copy();
            compoundtag.merge(this.tag);
            if (compoundtag.equals(compoundtag1)) ** GOTO lbl23
            try {
                p_331657_.loadCustomOnly(TagValueInput.create((ProblemReporter)problemreporter$scopedcollector, p_331528_, compoundtag));
                p_331657_.setChanged();
                var8_9 = true;
                return var8_9;
            }
            catch (Exception exception1) {
                CustomData.LOGGER.warn("Failed to apply custom data to block entity at {}", (Object)p_331657_.getBlockPos(), (Object)exception1);
                try {
                    p_331657_.loadCustomOnly(TagValueInput.create(problemreporter$scopedcollector.forChild((ProblemReporter.PathElement)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/String;, lambda$loadInto$5(), ()Ljava/lang/String;)()), p_331528_, compoundtag1));
                }
                catch (Exception exception) {
                    CustomData.LOGGER.warn("Failed to rollback block entity at {} after failure", (Object)p_331657_.getBlockPos(), (Object)exception);
                }
lbl23:
                // 3 sources

                $$6 = false;
            }
        }
        finally {
            problemreporter$scopedcollector.close();
        }
        return $$6;
    }

    public <T> DataResult<CustomData> update(DynamicOps<Tag> p_346001_, MapEncoder<T> p_331823_, T p_332045_) {
        return p_331823_.encode(p_332045_, p_346001_, p_346001_.mapBuilder()).build((Object)this.tag).map(p_330397_ -> new CustomData((CompoundTag)p_330397_));
    }

    public <T> DataResult<T> read(MapDecoder<T> p_330352_) {
        return this.read(NbtOps.INSTANCE, p_330352_);
    }

    public <T> DataResult<T> read(DynamicOps<Tag> p_346230_, MapDecoder<T> p_344951_) {
        MapLike maplike = (MapLike)p_346230_.getMap((Object)this.tag).getOrThrow();
        return p_344951_.decode(p_346230_, maplike);
    }

    public int size() {
        return this.tag.size();
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public CompoundTag copyTag() {
        return this.tag.copy();
    }

    public boolean contains(String p_331843_) {
        return this.tag.contains(p_331843_);
    }

    public boolean equals(Object p_331195_) {
        boolean bl;
        if (p_331195_ == this) {
            return true;
        }
        if (p_331195_ instanceof CustomData) {
            CustomData customdata = (CustomData)p_331195_;
            bl = this.tag.equals(customdata.tag);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }

    @Deprecated
    public CompoundTag getUnsafe() {
        return this.tag;
    }

    private static /* synthetic */ String lambda$loadInto$5() {
        return "(rollback)";
    }
}

